
# @AreaName
# %AreaPath
# %AreaDesc
# %AreaGroup
# %AreaExec
# %AreaExclude
# %AreaSave
# %AreaLinks
# %AreaAKA
# %AreaNewfile
# %AreaMode
# %AreaRO
# %AreaDupes
# %AreaNocheck

sub ReadAreas {
	local( $handle, $Key, $Value, $Area );
	if( ! &TestConfig( 'AREAS' )) {
		&logger( 0, "Undefined Areas in config file.", "err" );
		return 0;
	}
	if( ! open( handle, $FConfig{'AREAS'} )) {
		&logger( 0, "Cannot open Areas file.", "err" );
		return 0;
	}
	while( <handle> ) {
		/^[ \t]*$/	&& next;
		/^[ \t]*#/	&& next;
		/^[ \t]*-+/	&& next;
		chop;
		( $Key, $Value ) = split( /[ \t]+/, $_, 2 );
		if( $Key =~ /^Area/ ) {
			$Area = $Value;
			$AreaName[$#AreaName + 1] = $Value;
			next;
		} elsif( $#AreaName eq -1 ) {
			&logger( 0, "Expected keyword Area in Areas file." );
			return 0;
		}
		$Key =~ tr/a-z/A-Z/;
		if( $Key =~ /^DESC/ ) {
			$AreaDesc{$Area} = $Value;
		} elsif( $Key =~ /^GROUP/ ) {
			$AreaGroup{$Area} = $Value;
		} elsif( $Key =~ /^PATH/ ) {
			$AreaPath{$Area} = $Value;
		} elsif( $Key =~ /^EXEC/ ) {
			$AreaExec{$Area} = $Value;
		} elsif( $Key =~ /^EXCLUDE/i ) {
			$AreaExclude{$Area} = $Value;
		} elsif( $Key =~ /^SAVE/ ) {
			$AreaSave{$Area} = $Value;
		} elsif( $Key =~ /^LINKS/ ) {
			$AreaLinks{$Area} = $Value;
		} elsif( $Key =~ /^AKA/ ) {
			$AreaAKA{$Area} = $Value;
		} elsif( $Key =~ /^NEWFILE/ ) {
			$AreaNewfile{$Area} = $Value;
		} elsif( $Key =~ /^MODE/ ) {
			$AreaMode{$Area} = $Value;
		} elsif( $Key =~ /^READONLY/ ) {
			$AreaRO{$Area} = 1;
		} elsif( $Key =~ /^DUPECHECK/ ) {
			$AreaDupes{$Area} = $Value;
		} elsif( $Key =~ /^NOCHECK/ ) {
			$AreaNocheck{$Area} = $Value;
		} else {
			&logger( 1, "Unknown $Key in Areas - ignored." );
		}
	}
	close( handle );
	&logger( 7, "Read Areas Ok." );
	return 1;
}
