sub Manager {
	local( @files, $file );

	if( ! &TestConfig( 'QUEUE' )) {
		&logger( 0, "Not define Queue path in config file.", "err" );
		return 0;
	}
	&ReadUsers() || return 0;
	&ReadAreas() || return 0;

	@files = <$FConfig{'QUEUE'}/*>;

	foreach $file (@files) {
        	if( -f $file ) {
			if( !open(IN,$file)) {
				&logger( 0,"Cannot open queue file $file", "err" );
				next;
			}
			if( &Manager1() ) {
				close( IN );
				unlink( $file ) || &logger( 0, "Cannot unlink queue file $file", "err" );
			} else {
				close( IN );
				&logger( 0, "Bad message header in message ".&basename($file)." - moving to $FConfig{'QUEUE'}/bad", "err" );
				mkdir( "$FConfig{'QUEUE'}/bad", 0777 ) || (&logger( 0, "Cannot make directory $FConfig{'QUEUE'}/bad", "err" ), next) unless ( -d "$FConfig{'QUEUE'}/bad" );
				rename( $file,"$FConfig{'QUEUE'}/bad/".&basename($file) ) || &logger( 0, "Cannot move $file to $FConfig{'QUEUE'}/bad", "err" );
			}
		}
	}
}

sub Manager1 {
	local( $Cmd, $Args );

	&ReadHeader() || return 0;
	open( OUT, "| ".$FConfig{'MAILCOMMAND'} );
#	open( OUT, "> out_mail" );
	if( defined( $FConfig{'ROBOTNAME'} )) {
		print OUT "From: ".$FConfig{'ROBOTNAME'}." <".$FConfig{'ROBOTNAME'}."\@".$FConfig{'MYFQDN'}.">\n";
	} else {
		print OUT "From: FileFix-Robot <FileFix-Robot\@".$FConfig{'MYFQDN'}.">\n";
	}
	print OUT "To: $UAddr\n";
	print OUT "Subject: Reply from Area Manager\n\n";

	if( &find( $UHost, @UserAddr ) == -1 ) {
		&logger( 3, "Unknown user $UHost", "warning" );
		&flame_nouser();
		return 0;
	}
	if( &toupper( $UserPasswd{$UHost} ) ne &toupper( $Subject )) {
		&logger( 3, "Passwd error [$UHost] : is \"$Subject\", should by \"$UserPasswd{$UHost}\"", "warning", 1 );
		&flame_nopasswd();
		return 0;
	}

	undef $ChangeAreas;
	undef $ChangeUsers;

	&logger( 5, "Reply to $UHost...", "info" );
	while( <IN> ) {
		chop;
		next if( /^[ \t]*$/ );
		if( /^\-\-+/ ) {
			print OUT "> --\nEnd.\n";
			last;
		}
		if( /^[ \t]*%/ ) {
			print OUT "\n> $_\n";
			( $Cmd, $Args ) = split( /[ \t]+/, $_, 2 );
			if( $Cmd =~ /%[Hh][Ee][Ll][Pp]/ ) {
				&logger( 5, "Processing %HELP...", "info" );
				&flame_help();
				next;
			} elsif( $Cmd =~ /%[Ll][Ii][Ss][Tt]/ ) {
				&logger( 5, "Processing %LIST...", "info" );
				&print_list( 0 );
				next;
			} elsif( $Cmd =~ /%[Ll][Ii][Nn][Kk][Ee][Dd]/ ) {
				&logger( 5, "Processing %LINKED...", "info" );
				&print_list( 1 );
				next;
			} elsif( $Cmd =~ /%[Uu][Nn][Ll][Ii][Nn][Kk][Ee][Dd]/ ) {
				&logger( 5, "Processing %UNLINKED...", "info" );
				&print_list( -1 );
				next;
			} elsif( $Cmd =~ /%[Pp][Aa][Uu][Ss][Ee]/ ) {
				&logger( 5, "Processing %PAUSE...", "info" );
				&paused_area( $Args );
				next;
			} elsif( $Cmd =~ /%[Rr][Ee][Ss][Uu][Mm][Ee]/ ) {
				&logger( 5, "Processing %RESUME...", "info" );
				&resumed_area( $Args );
				next;
			} elsif( $Cmd =~ /%[Pp][Aa][Ss][Ss][Ww][Dd]/ ) {
				&logger( 5, "Processing %PASSWD...", "info" );
				&change_passwd( $Args );
				next;
			} else {
				print OUT "Warning: Unknown command. See %HELP\n";
				next;
			}
		} elsif( /^[ \t]*-/ ) {
			&unlink_area( $_ );
			next;
		} else {
			&link_area( $_ );
			next;
		}
	}
	if( defined( $ChangeAreas )) {
		print OUT "\n";
		if( ! &WriteAreas() ) {
			print OUT "\nERROR: Areas not linked and/or unlinked, internal error.\n";
		}
	}
	if( defined( $ChangeUsers )) {
		if( ! &WriteUsers() ) {
			print OUT "\nPassword not changed, internal error.\n";
		}
	}
	print OUT "\n--\n\t$Version of ".$FConfig{'ADDRESS'}."\n";
	close( OUT );

	return 1;
}

sub ReadHeader {
	undef( $Uzone );
	undef( $Unet );
	undef( $UNode );
	undef( $UPoint );
	while( <IN> ) {
		chop;
		last if( /^\s*$/ ); # end of header
		next unless(( $key, $value ) = /([^:]+):\s+(.*$)/ );
		$Subject = $value if( $key =~ /^Subject/ );
		$From = $value if( $key =~ /^From/ );
	}
	return 0 unless( defined( $Subject ) && defined( $From ));
	if( $From =~ /[^<]*<(\S+@\S+)>/ ) {
		$UAddr = $1;
	} elsif( $From =~ m/(\S+@\S+)\s+[\(][^\)]+[\)]/ ) {
		$UAddr = $1;
	} else {
		$UAddr = $From;
	}
	( $UName, $UHost ) = split( "@", $UAddr );
	$UName =~ s/[\._]/ /;
	@ftn = split( /\./, $UHost );
	for( $i = 0; $i <= $#ftn; $i++ ) {
		$UZone = $ftn[$i] if( $ftn[$i] =~ /z[0-9]+/ );
		$UNet = $ftn[$i] if( $ftn[$i] =~ /n[0-9]+/ );
		$UNode = $ftn[$i] if( $ftn[$i] =~ /f[0-9]+/ );
		$UPoint = $ftn[$i] if( $ftn[$i] =~ /p[0-9]+/ );
	}
	$UZone =~ s/z//;
	$UNet =~ s/n//;
	$UNode =~ s/f//;
	$UPoint =~ s/p// if( defined( $UPoint ));
	$UHost = $UZone.":".$UNet."/".$UNode;
	$UHost .= ".".$UPoint if( defined( $UPoint ));
	return 1;
}

sub flame_nouser {
	print OUT "\nDear ".$UName."!\n\n";
	print OUT "I'm terribly sorry, but your site is not present\n";
	print OUT "in our Users file, so, you can not access\n";
	print OUT "Area Manager on this node. Please, contact with\n";
	print OUT $FConfig{'SYSOP'}.", our system operator.\n";
	print OUT "\n--\n\t$Version\n";
	close( OUT );
}

sub flame_nopasswd {
	print OUT "\nDear ".$UName."!\n\n";
	print OUT "You gave incorrect password for Area Manager, so,\n";
	print OUT "your FileFix query will be refused. Please repeat\n";
	print OUT "your request with correct password or contact with\n";
	print OUT $FConfig{'SYSOP'}.", our system operator.\n";
	print OUT "\n--\n\t$Version\n";
	close( OUT );
}

sub flame_help {
	local( $helpfile );
	if( ! &TestConfig( 'HELPFILE' )) {
		&logger( 0, "Help file not found.", "err" );
		print OUT "Problem with help file.\n\n";
		return 0;
	}
	if( ! open( helpfile, $FConfig{'HELPFILE'} )) {
		&logger( 0, "Cannot open help file [$!].", "err" );
		print OUT "Problem with help file.\n\n";
		return 0;
	}
	while( <helpfile> ) {
		print OUT $_;
	}
	close( helpfile );
	print OUT "\n\n";
	return 1;
}

sub print_list {
	local( $i, $j, $area, $desc, $flg, @links, $ag );
	for( $i = 0; $i <= $#AreaName; $i++ ) {
		$area = $AreaName[$i];
		$desc = $AreaDesc{$area};
		$flg = " ";
		if( $area !~ '^default$' ) {
			$ag = $AreaGroup{$area};
			if( $UserGroups{$UHost} !~ /$ag/ ) {
				$flg = "!";
			}
			my $tUHost = $UHost;
			$tUHost =~ s/\./\\./g;
			if(( $AreaLinks{$area} =~ /$tUHost[ \t]/ ) || ( $AreaLinks{$area} =~ /$tUHost$/ )) {
				if(( $AreaLinks{$area} =~ /-!*$tUHost[ \t]/ ) || ( $AreaLinks{$area} =~ /-!*$tUHost$/ )) {
					$flg = "-";
				} else {
					$flg = "+";
				}
			}
			$desc = "Description missing" if( $desc =~ /^[ \t]*$/ );
			if(( $_[0] == 0 ) ||
				(( $_[0] == -1 ) && (( $flg eq " " ) || ( $flg eq "!" ))) ||
				(( $_[0] == 1 ) && (( $flg ne " " ) && ( $flg ne "!" )))) {
				print OUT sprintf( "%s %-20s\t%s\n", $flg, $area, $desc );
			}
		}
	}
	print OUT "\n";
	print OUT "     + This area is linked\n" if( $_[0] != -1 );
	print OUT "     - This area is paused\n" if( $_[0] != -1 );
	print OUT "     ! This area is restricted\n" if( $_[0] != 1 );
	print OUT "\n\n";
	return 1;
}

sub paused_area {
	local( @areas );
	local( @links, $fndlnk, $nlinks, $ac );
	local( $i, $j, $p, $r );

	@areas = split( /[ \t]+/, toupper( $_[0] ));
	$ac = $#areas;
	@areas = @AreaName if( $ac < 0 );
	for( $i = 0; $i <= $#areas; $i++ ) {
		next if( $areas[$i] =~ /default/i );
		if( defined( $AreaLinks{$areas[$i]} )) {
			@links = split( /[ \t]+/, $AreaLinks{$areas[$i]} );
			$fndlnk = 0;
			$nlinks = "";
			for( $j = 0; $j <= $#links; $j++ ) {
				if( $links[$j] =~ /\!/ ) {
					$r = "!";
					$links[$j] =~ s/\!//;
				} else {
					$r = "";
				}
				if( $links[$j] =~ /\-/ ) {
					$p = "-";
					$links[$j] =~ s/\-//;
				} else {
					$p = "";
				}
				if( $links[$j] eq $UHost ) {
					$fndlnk = 1;
					if( $p eq "-" ) {
						print OUT $areas[$i]." - already paused.\n";
						&logger( 5, "pause $areas[$i] - already paused.", "info" );
					} else {
						$p = "-";
						print OUT $areas[$i]." - paused.\n";
						&logger( 5, "pause $areas[$i] - paused.", "info" );
						$ChangeAreas = 1;
					}
				}
				$nlinks .= " ".$p.$r.$links[$j];
			}
			$AreaLinks{$areas[$i]} = $nlinks;
			if(( $fndlnk == 0 ) && ( $ac >= 0 )) {
				print OUT $areas[$i]." - not linked.\n";
				&logger( 5, "pause $areas[$i] - not linked.", "info" );
			}
		} else {
			print OUT $areas[$i]." - not found.\n";
			&logger( 5, "pause $areas[$i] - not found.", "info" );
		}
	}
}

sub resumed_area {
	local( @areas );
	local( @links, $fndlnk, $nlinks, $ac );
	local( $i, $j, $p, $r );

	@areas = split( /[ \t]+/, toupper( $_[0] ));
	$ac = $#areas;
	@areas = @AreaName if( $ac < 0 );
	for( $i = 0; $i <= $#areas; $i++ ) {
		next if( $areas[$i] =~ /default/i );
		if( defined( $AreaLinks{$areas[$i]} )) {
			@links = split( /[ \t]+/, $AreaLinks{$areas[$i]} );
			$fndlnk = 0;
			$nlinks = "";
			for( $j = 0; $j <= $#links; $j++ ) {
				if( $links[$j] =~ /\!/ ) {
					$r = "!";
					$links[$j] =~ s/\!//;
				} else {
					$r = "";
				}
				if( $links[$j] =~ /\-/ ) {
					$p = "-";
					$links[$j] =~ s/\-//;
				} else {
					$p = "";
				}
				if( $links[$j] eq $UHost ) {
					$fndlnk = 1;
					if( $p eq "" ) {
						print OUT $areas[$i]." - not paused.\n";
						&logger( 5, "resume $areas[$i] - not paused.", "info" );
					} else {
						$p = "";
						print OUT $areas[$i]." - resumed.\n";
						&logger( 5, "resume $areas[$i] - resumed.", "info" );
						$ChangeAreas = 1;
					}
				}
				$nlinks .= " ".$p.$r.$links[$j];
			}
			$AreaLinks{$areas[$i]} = $nlinks;
			if(( $fndlnk == 0 ) && ( $ac >= 0 )) {
				print OUT $areas[$i]." - not linked.\n";
				&logger( 5, "resume $areas[$i] - not linked.", "info" );
			}
		} else {
			print OUT $areas[$i]." - not found.\n";
			&logger( 5, "resume $areas[$i] - not found.", "info" );
		}
	}
}

sub change_passwd {
	local( $key, $value ) = split( /[ \t]+/, $_[0] );
	if( $value =~ /^[ \t]*$/ ) {
		print OUT "Password not changed.\n\n";
	} else {
		$UserPasswd{$UHost} = $value;
		$ChangeUsers = 1;
		print OUT "Password changed, new password \"$value\"\n\n";
	}
}

sub link_area {
	local( $i, $area, $ag );
	$area = $_[0];
	$area =~ s/\+//;
	$area =~ tr/a-z/A-Z/;
	for( $i = 0; $i <= $#AreaName; $i++ ) {
		next if( $AreaName[$i] eq "DEFAULT" );
		last if( $AreaName[$i] eq $area );
	}
	if( $i > $#AreaName ) {
		print OUT "$area - not found.\n";
		&logger( 5, "+$area - not found.", "info" );
		return 0;
	}
	my $tUHost = $UHost;
	$tUHost =~ s/\./\\./g;
	if(( $AreaLinks{$area} =~ /$tUHost[ \t]/ ) || ( $AreaLinks{$area} =~ /$tUHost$/ )) {
		print OUT "$area - already linked.\n";
		&logger( 5, "+$area - already linked.", "info" );
		return 0;
	}
	$ag = $AreaGroup{$area};
	if( $UserGroups{$UHost} !~ /$ag/ ) {
		print OUT "$area - restricted.\n";
		&logger( 5, "+$area - restricted.", "info" );
		return 0;
	}
	if( $UserFlags{$UHost} =~ /\+\!/ ) {
		$AreaLinks{$area} .= " !".$UHost;
		&logger( 5, "+$area - linked [RO].", "info" );
	} elsif( $AreaRO{$area} ) {
		$AreaLinks{$area} .= " !".$UHost;
		&logger( 5, "+$area - linked [RO].", "info" );
	} else {
		$AreaLinks{$area} .= " ".$UHost;
		&logger( 5, "+$area - linked [RW].", "info" );
	}
	print OUT "$area - linked.\n";
	$ChangeAreas = 1;
	return 1;
}

sub unlink_area {
	local( $i, $area, $ag, $links );
	$area = $_[0];
	$area =~ s/\-//;
	$area =~ tr/a-z/A-Z/;
	for( $i = 0; $i <= $#AreaName; $i++ ) {
		next if( $AreaName[$i] eq "DEFAULT" );
		last if( $AreaName[$i] eq $area );
	}
	if( $i > $#AreaName ) {
		print OUT "$area - not found.\n";
		&logger( 5, "$area - not found.", "info" );
		return 0;
	}
	if( ! (( $AreaLinks{$area} =~ /$UHost[^\.]/ ) || ( $AreaLinks{$area} =~ /$UHost$/ ))) {
		print OUT "$area - not linked.\n";
		&logger( 5, "$area - not linked.", "info" );
		return 0;
	}
	@links = split( /[ \t]+/, $AreaLinks{$area} );
	$AreaLinks{$area} = "";
	for( $i = 0; $i <= $#links; $i++ ) {
		next if( $links[$i] =~ /$UHost$/ );
		$AreaLinks{$area} .= " ".$links[$i];
	}
	print OUT "$area - unlinked.\n";
	&logger( 5, "$area - unlinked.", "info" );
	$AreaLinks{$area} =~ s/^ //;
	$ChangeAreas = 1;
	return 1;
}
