#!/usr/local/bin/perl

# $Id: rfc822.pl,v 1.3 1997/11/24 00:43:26 crosser Exp $
#
# $Log: rfc822.pl,v $
# Revision 1.3  1997/11/24 00:43:26  crosser
# Add parameter to rfc822putheader
#
# Revision 1.2  1997/11/23 23:47:22  crosser
# add comment
#

# RFC822 parser for fido7 "automoderator"
# Copyright (c) 1997 Eugene G. Crosser

sub rfc822parse {
	local($IN)=@_;
	local($isng,$i,$sender,@header);

	$sender="";
	$i=-1;
	while (<$IN>) {

		# stop processing if end of header line found

		last if (/^\s*$/);

		# Process new header line as opposed to continuation line

		unless (/^\s/) {
			$i++;
			#print STDERR "new  hdr: $_";

			# Check if we need to cut off foreign newsgroups
			# If not done, we can occationally approve
			# postings to newsgroup(s) other than fido7.
			# Here, we just set a trigger.

			if (/^Newsgroups:\s/i) {
				$isng=1;
			} else {
				$isng=0;
			}
		}

		# If we are currently reading the Newsgroups" header
		# (including continuation lines), split individual
		# group names and drop those out of fido7 hierarchy

		if ($isng) {
			($beg,$mid,$end)=(/(.*\s)([^\s].*[^\s])(\s*)$/);
			#print STDERR "beg=\"$beg\", mid=\"$mid\", end=\"$end\"\n";
			$_=$beg;
			foreach $el(split(/,/,$mid)) {
				$_.=$el.',' if ($el=~/^fido7\./);
			}
			chop;
			$_.=$end;
		}

		# OK, all preprocessing done here, put the line into the
		# header array (only if we did not empty it).

		$header[$i].=$_ unless (/^\s*$/);

		# Post-processing: find sender

		if (/^From:\s*(.*[^\s])\s*$/i) {
			$sender=$1;
			if ($sender=~/<([^<>]*)>/) {
				$sender=$1;
			}
			$sender=~s/\([^()]*\)//g;
			$sender=~s/\s+/ /g;
			$sender=~s/^\s*//g;
			$sender=~s/\s*$//g;
		}
	}
	#for ($i=0;$i<$#header;$i++) { print STDERR "($i): $header[$i]\n"; }
	return ($sender,@header);
}

sub rfc822putheader {
	local($OUT,$dofilter,@header)=@_;
	local($ln);

	while ($ln=shift(@header)) {

		if ($dofilter) {
			# If Path: header present, invalidate it,
			# otherwise the article will be invisible in the
			# origonating system.  Also invalidate Sender:
			# and NNTP-Posting-Host: because inews would
			# barf on them otherwise.

			$ln=~s/^/X-BeforeModerator-/
					if ($ln=~/^Path:/i);
			$ln=~s/^/X-BeforeModerator-/
					if ($ln=~/^NNTP-Posting-Host:/i);
			$ln=~s/^/X-BeforeModerator-/
					if ($ln=~/^Sender:/i);
			next if ($ln=~/^From\s/i);
			next if ($ln=~/^Received:/i);
			next if ($ln=~/^To:/i);
		}
		print $OUT $ln;
	}
}

sub rfc822hdr {
	local($key,@header)=@_;
	local($ln);

	while ($ln=shift(@header)) {
		if ($ln =~ /^$key/i) {
			$ln =~ s/^[^:]*://;
			$ln =~ s/^\s*//;
			$ln =~ s/\s*$//;
			return $ln;
		}
	}
	return "";
}

1;
