#!/usr/local/bin/perl

# $Id: db.pl,v 1.2 1997/11/23 23:47:22 crosser Exp $
#
# $Log: db.pl,v $
# Revision 1.2  1997/11/23 23:47:22  crosser
# add comment
#

# Database interface for fido7 "automoderator"
# Copyright (c) 1997 Eugene G. Crosser

$USERDB="/var/tmp/fido7user" unless (defined $USERDB);

$DB_NEEDSYNC=0;
dbmopen(DB,$USERDB,0600) || die "cannot open $USERDB: $!";

$SIG{'TERM'}='shutdown';
$SIG{'INT'}='shutdown';   
$SIG{'QUIT'}='shutdown';
$SIG{'HUP'}='shutdown'; 

sub u_insert {
	local(%rec)=@_;
	local($k,$v,$str,$user);

	unless ($rec{'user'}) {
		print STDERR time," u_store: no 'user' key\n";
		return 0;
	}
	$user=$rec{'user'};
	$user=~tr/[A-Z]/[a-z]/;
	foreach $k(keys %rec) {
	#	next if ($k eq 'user');
		$str.=":" if ($str);
		$v=$rec{$k};
		$k=~s/%/%p/g;
		$k=~s/:/%s/g;
		$k=~s/=/%e/g;
		$v=~s/%/%p/g;
		$v=~s/:/%s/g;
		$v=~s/=/%e/g;
		$str.=$k."=".$v;
		$DB{$user}=$str;
	}
	$DB_NEEDSYNC=1;
	return 1;
}

sub u_find {
	local($user)=@_;
	local($str,%rec);

	$rec{'user'}=$user;
	$user=~tr/[A-Z]/[a-z]/;
	$str=$DB{$user};
	return () unless($str);
	foreach $tok(split(/:/,$str)) {
		($k,$v)=split(/=/,$tok);
		$k=~s/%s/:/g;
		$k=~s/%e/=/g;
		$k=~s/%p/%/g;
		$v=~s/%s/:/g;
		$v=~s/%e/=/g;
		$v=~s/%p/%/g;
		$rec{$k}=$v;
	}
	return %rec;
}

sub u_delete {
	local($user)=@_;

	$user=~tr/[A-Z]/[a-z]/;
	delete $DB{$user};
	$DB_NEEDSYNC=1;
}

sub u_close {
	dbmclose(DB);
}

sub u_sync {
	if ($DB_NEEDSYNC) {
		dbmclose(DB);
		dbmopen(DB,$USERDB,0600) || die "cannot open $USERDB: $!";
		$DB_NEEDSYNC=0;
		print STDERR time," synchronized $USERDB\n";
	}
}

sub shutdown {
	&u_close;
	print STDERR time," shutdown\n";
	exit;
}

1;
