/* Neville's INI file implementation */

/* Some information as to why I wrote this */

#ifndef INIFILE_H
#define INIFILE_H

typedef void *INI;
typedef void *INISECT;

#define INI_PASS 1
#define INI_FAIL 0

extern INI  ini_create();
extern void ini_destroy(INI object);

extern char ini_load(INI object, const char *filename);
extern char ini_write(INI object, const char *filename);
extern char ini_writeFile(INI object, FILE *outfile);

extern INISECT ini_getSection(INI object,
                              const char *sectname);
extern INISECT ini_addSection(INI object,
                              const char *sectname);

extern char ini_addEntry(INI object,
                         const char *sectname,
                         const char *entryname,
                         const char *valuename);
extern char ini_addEntrySect(INI object,
                             INISECT section,
                             const char *entryname,
                             const char *valuename);

extern char *ini_getValueString(INI object,
                                const char *sectname,
                                const char *entryname);
extern char *ini_getValueStringSect(INI object,
                                    INISECT section,
                                    const char *entryname);
extern char ini_getValueNumber(INI object,
                               const char *sectname,
                               const char *entryname,
                               long *numpos);
extern char ini_getValueNumberSect(INI object,
                                   INISECT section,
                                   const char *entryname,
                                   long *numpos);
extern char ini_getValueBool(INI object,
                             const char *sectname,
                             const char *entryname,
                             const char thedefault);
extern char ini_getValueBoolSect(INI object,
                                 INISECT section,
                                 const char *entryname,
                                 const char thedefault);

#endif /* INIFILE_H */

/* EOF */

/*
    ini file
    
    [section1]
    entry1=value1
    entry2 = value2
    entry3 = 'value 3'
    entry4 ='value 4'
    
    [section2]
    entry1=value1
    .
    .
    .
*/
