/* 
    Initialize and terminate and other general functions
*/

#include "cmp3funcs.h"

/****************************************************************************
 *  Start up signals and initialize
 *  Returns: nothing
 ****************************************************************************/
extern void initialize()
{
    Signal(SIGINT,enditall);
    Signal(SIGTERM,enditall);
    Signal(SIGSEGV,enditall);

    shmptr->using++;

    initvol();

    move(1,(COLS/2)-(strlen(TITLE)/2));
    attron(A_REVERSE);
    printw(TITLE);
    attroff(A_REVERSE);
    wattron(win_left,A_REVERSE);
    mvwprintw(win_left,1,2,"Directory:");
    wattroff(win_left,A_REVERSE);
    mvwprintw(win_right,1,2,".mp3 files:");
    box(win_right, 0, 0);

    return;
}

/****************************************************************************
 *  Darling, we just can't go on like this
 *  Returns: nothing, muahaha
 ****************************************************************************/
extern void enditall(int signum)
{
    if (shmptr) {
        if ((signum==SIGINT)||(signum==SIGTERM)||(signum==SIGSEGV))
            kill(shmptr->managpid,SIGINT);
        if (signum != 69)
            shmptr->using--;
        if (shmdt((char*)shmptr) < 0)
            perror("can't detach shared memory");
    }
    if (signum != 69) {
        clear();
        refresh();
        endwin();
        if (cmp3rc != NULL)
            ini_destroy(cmp3rc);
    }
    endvol();
    exit(0);
}

/* EOF */
