/* Common functions everyone can use */

/* #include"cmp3common.h" */
#include"cmp3funcs.h"

/****************************************************************************
 *  Replacement signal function
 *  Since different libraries handle the signal(2) function differently,
 *  this function will use POSIX sigaction(2) to get correct behavior every
 *  time. Thanks to Richard Stevens and his Network Programming books.
 *  Returns: whatever signal(2) would return
 ****************************************************************************/
Sigfunc *Signal(int signo, Sigfunc *func)
{
    struct sigaction act, oact;

    act.sa_handler = func;
    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    if (signo == SIGALRM) {
#ifdef SA_INTERRUPT
        act.sa_flags |= SA_INTERRUPT;   /* SonOS 4.x */
#endif
    } else {
#ifdef SA_RESTART
        act.sa_flags |= SA_RESTART;     /* SVR4, 4.4BSD */
#endif
    }
    if (sigaction(signo, &act, &oact) < 0)
        return (SIG_ERR);
    return(oact.sa_handler);
}

/****************************************************************************
 *  Replacement strdup function
 *  Returns: whatever strdup returns
 ****************************************************************************/
char *Strdup(const char *str)
{
    char *string;

    string = Malloc(sizeof(char) * (strlen(str) + 1));
    strcpy(string, str);
    return(string);
}

/****************************************************************************
 *  Case insensitive strcmp
 *  Tolower's all characters in both strings and sends to strcmp
 *  Returns: whatever strcmp returns
 ****************************************************************************/
int Strcmp(const char *str1,    /* First string to compare */
           const char *str2     /* Second string to compare */)
{
    int i;                      /* Counter for loops and
                                     return value of strcmp */
    static char *tmp1 = NULL,   /* Temporary tolowered str1 */
                *tmp2 = NULL;   /* Teporary tolowered str2 */
 
    if (tmp1 == NULL) {
        tmp1 = (char*) malloc(MAX_FULL * sizeof(char));
        tmp2 = (char*) malloc(MAX_FULL * sizeof(char));
    }
    for(i = 0; i < (int) strlen(str1) ; i++)
    {
        tmp1[i] = (char) tolower(str1[i]);
    }
    tmp1[i] = '\0';
    for(i=0; i < (int) strlen(str2) ; i++)
    {
        tmp2[i] = (char) tolower(str2[i]);
    }
    tmp2[i] = '\0';
    i = strcmp(tmp1, tmp2);
    return(i);
}

int Strncmp(const char *str1,    /* First string to compare */
            const char *str2,    /* Second string to compare */
            int         num)
{
    int i;                      /* Counter for loops and
                                     return value of strcmp */
    static char *tmp1 = NULL,   /* Temporary tolowered str1 */
                *tmp2 = NULL;   /* Teporary tolowered str2 */
 
    if (tmp1 == NULL) {
        tmp1 = (char*) malloc(MAX_FULL * sizeof(char));
        tmp2 = (char*) malloc(MAX_FULL * sizeof(char));
    }
    for(i = 0; i < (int) strlen(str1) ; i++)
    {
        tmp1[i] = (char) tolower(str1[i]);
    }
    tmp1[i] = '\0';
    for(i=0; i < (int) strlen(str2) ; i++)
    {
        tmp2[i] = (char) tolower(str2[i]);
    }
    tmp2[i] = '\0';
    i = strncmp(tmp1, tmp2, num);
    return(i);
}

int getline(char *var,         /* Buffer to copy line into */
            int  maxbuf,       /* MAX to send to fgets */
            FILE *input        /* File descriptor to get line from */)
{
    int len;

    while (1) {
        if (fgets(var, maxbuf, input) == NULL)
            return(0);

        len = strlen(var);
        if (var[len-1] == '\n') {
            if (var[len-2] ==  '\r') {
                var[len-2] = '\0';
            } else {
                var[len-1]='\0';
            }
        }
        if (var[0] != '\0')
            return(1);
    }
}
                                                                                                                             
/****************************************************************************
 *  Wrapper for Malloc
 *  Returns: whatever malloc returned
 ****************************************************************************/
void *Malloc(size_t size)
{
    void *ptr;

    ptr = calloc(size, 1);
    if (ptr == NULL) {
        perror("malloc: ");
        exit(-1);
    }
    return(ptr);
}


/* EOF */