#
#   MailScanner - SMTP E-Mail Virus Scanner
#   Copyright (C) 2002  Julian Field
#
#   $Id: ConfigDefs.pl,v 1.37.2.62 2004/05/27 20:37:53 jkf Exp $
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The author, Julian Field, can be contacted by email at
#      Jules@JulianField.net
#   or by paper mail at
#      Julian Field
#      Dept of Electronics & Computer Science
#      University of Southampton
#      Southampton
#      SO17 1BJ
#      United Kingdom
#

1;

__DATA__
########################################################################
#
# Go through the entire source code, checking wherever any variable is
# used. Ensure they are used in a way that matches their spec.
#
########################################################################

#
# Translation between Internal and External keyword names.
# This lets me use nice brief names internally, and set the
# config file options to names that mean something.
#
# Format:
#    Internal = External
#

[Translation,Translation]

addenvfrom			= AddEnvelopeFromHeader
addenvto			= AddEnvelopeToHeader
AllowObjectTags			= AllowObjectCodebaseTags
AllowExternal			= AllowExternalMessageBodies
AllowPartial			= AllowPartialMessages
allowpasszips			= AllowPasswordProtectedArchives
AllowWebBugTags			= AllowWebBugs
AttachmentCharset		= AttachmentEncodingCharset
bayesrebuild			= RebuildBayesEvery
bayeswait			= WaitDuringBayesRebuild
blacklistedishigh		= definitespamishighscoring
BlockEncrypted			= BlockEncryptedMessages
BlockUnencrypted		= BlockUnencryptedMessages
CheckSAIfOnSpamList		= checkspamassassinifonspamlist
children			= maxchildren
clamwatchfiles			= monitorsforclamavupdates
cleanheader			= cleanheadervalue
contentprependsubject		= contentmodifysubject
contentsubjecttext		= contentsubjecttext
criticalqueuesize		= maxnormalqueuesize
dangerscan			= dangerouscontentscanning
deletedcontentmessage		= deletedbadcontentmessagereport
deletedfilenamemessage		= deletedbadfilenamemessagereport
deletedvirusmessage		= deletedvirusmessagereport
deliverdisinfected		= deliverdisinfectedfiles
deliversilent			= stilldeliversilentviruses
dirtyheader			= infectedheadervalue
disinfectedheader		= disinfectedheadervalue
disinfectedreporttext		= disinfectedreport
envfromheader			= EnvelopeFromHeader
envtoheader			= EnvelopeToHeader
hamactions                      = nonspamactions
hideworkdir			= hideincomingworkdir
hideworkdirinnotice		= hideincomingworkdirinnotices
highrbls                        = spamliststoreachhighscore
highscorespamactions		= highscoringspamactions
highscoremcpactions		= highscoringmcpactions
highspamprependsubject		= highscoringspammodifysubject
highspamsubjecttext		= highscoringspamsubjecttext
htmltotext			= converthtmltotext
includespamheader		= alwaysincludespamassassinreport
includemcpheader		= alwaysincludemcpreport
infoheader			= informationheader
infovalue			= informationheadervalue
inlinehtmlsig			= inlinehtmlsignature
inlinehtmlwarning		= inlinehtmlwarning
inlinetextsig			= inlinetextsignature
inlinetextwarning		= inlinetextwarning
inqueuedir			= incomingqueuedir
lastlookup			= alwayslookeduplast
listsascores                    = includescoresinspamassassinreport
logfacility			= syslogfacility
maxattachmentsize		= maximumattachmentsize
maxdirtybytes			= maxunsafebytesperscan
maxdirtymessages		= maxunsafemessagesperscan
maxmessagesize			= maximummessagesize
maxparts			= maximumattachmentspermessage
maxunscannedbytes		= maxunscannedbytesperscan
maxunscannedmessages		= maxunscannedmessagesperscan
maxzipdepth			= maximumarchivedepth
minstars			= minimumstarsifonspamlist
nameprependsubject		= filenamemodifysubject
namesubjecttext			= filenamesubjecttext
noisyviruses			= nonforgingviruses
nosenderprecedence		= nevernotifysendersofprecedence
noticefullheaders		= noticesincludefullheaders
noticerecipient			= noticesto
outqueuedir			= outgoingqueuedir
quarantinesilent		= quarantinesilentviruses
quarantineuser			= quarantineuser
quarantinegroup			= quarantinegroup
quarantineperms			= quarantinepermissions
rbltimeoutlen			= spamlisttimeoutshistory
satimeoutlen			= spamassassintimeoutshistory
reqspamassassinscore		= requiredspamassassinscore
saviwatchfiles                  = monitorsforsophosupdates
sendercontentreport		= senderbadcontentreport
senderfilenamereport		= senderbadfilenamereport
senderrblspamreport		= senderspamlistreport
sendersaspamreport		= senderspamassassinreport
sendersamcpreport		= sendermcpreport
senderbothspamreport		= senderspamreport
showscanner			= includescannernameinreports
signalreadyscanned		= signmessagesalreadyprocessed
signunscannedmessages		= markunscannedmessages
sophosallowederrors		= allowedsophoserrormessages
sophoside			= sophosidedir
sophoslib			= sophoslibdir
spamblacklist			= isdefinitelyspam
spamdetail			= detailedspamreport
spamprependsubject		= spammodifysubject
spamscorenotstars		= spamscorenumberinsteadofstars
spamstars			= spamscore
spamstarscharacter		= spamscorecharacter
spamstarsheader			= spamscoreheader
spamwhitelist			= isdefinitelynotspam
storedcontentmessage		= storedbadcontentmessagereport
storedfilenamemessage		= storedbadfilenamemessagereport
storedvirusmessage		= storedvirusmessagereport
storeentireasdfqf		= quarantinewholemessagesasqueuefiles
stripdangeroustags		= convertdangeroushtmltotext
mcpblacklist			= isdefinitelymcp
mcpblacklistedishigh		= definitemcpishighscoring
mcpdetail			= detailedmcpreport
mcplistsascores			= includescoresinmcpreport
mcpreqspamassassinscore		= mcprequiredspamassassinscore
mcpwhitelist			= isdefinitelynotmcp
unscannedheader			= unscannedheadervalue
usedefaultswithmanyrecips       = usedefaultruleswithmultiplerecipients
virusprependsubject		= virusmodifysubject
virusscan			= virusscanning
warnsenders			= notifysenders
warnvirussenders		= notifysendersofviruses
warnnamesenders			= notifysendersofblockedfilenamesorfiletypes
warnothersenders		= notifysendersofotherblockedcontent
whitelistmaxrecips		= ignorespamwhitelistifrecipientsexceed
workuser			= incomingworkuser
workgroup			= incomingworkgroup
workperms			= incomingworkpermissions


#
# Simple variables which can only have a single value, no rules allowed.
#

# These can be any of the words given, with the corresponding value stored.
# Format is	<Keyword Name>
#		<Default internal value>
#	      [ <External name> <Internal store value ] ...
#
[Simple,YesNo]
bayeswait		0	no	0	yes	1
debug			0	no	0	yes	1
debugspamassassin	0	no	0	yes	1
deliverinbackground	1	no	0	yes	1
lognonspam		0	no	0	yes	1
logspam			1	no	0	yes	1
logspeed		0	no	0	yes	1
logmcp			0	no	0	yes	1
expandtnef		1	no	0	yes	1
showscanner		0	no	0	yes	1
spamassassinautowhitelist 1	no	0	yes	1
spliteximspool		0	no	0	yes	1
storeentireasdfqf	0	no	0	yes	1
usedefaultswithmanyrecips	0	no	0	yes	1

# These should be checked for dir existence
[Simple,Dir]
incomingworkdir		/var/spool/MailScanner/incoming
lockfiledir		/tmp

# Check the first word of these for file existence
[Simple,File]
pidfile			/var/run/MailScanner.pid
spamassassinprefsfile	/etc/MailScanner/spam.assassin.prefs.conf
SpamListDefinitions	/etc/MailScanner/spam.lists.conf
mcpspamassassinprefsfile /etc/MailScanner/mcp/mcp.spam.assassin.prefs.conf
VirusScannerDefinitions	/etc/MailScanner/virus.scanners.conf

# Check these to ensure they are just numbers
[Simple,Number]
BayesRebuild			0
Children			1
CriticalQueueSize		5000
FileTimeout			30
MaxUnscannedBytes		100000000
MaxUnscannedMessages		100
MaxDirtyBytes			50000000
MaxDirtyMessages		100
MaxSpamAssassinTimeouts		10
MaxSpamAssassinSize		50000
QueueScanInterval		5
RBLTimeoutLen			10
RestartEvery			14400
SATimeoutLen			20
SpamListTimeout			5
SpamAssassinTimeout		10
VirusScannerTimeout		300
MCPMaxSpamAssassinTimeouts	20
MCPMaxSpamAssassinSize		100000
MCPSpamAssassinTimeout		10
TNEFTimeout			120
WhitelistMaxRecips		20

# These are all the other strings I haven't categorised.
# inqueuedir is here as it can be a glob (if it contains a * or a ?) or a
# filename containing a list of directories.
[Simple,Other]
ClamWatchFiles		/usr/local/share/clamav/*.cvd
CustomFunctionsDir	/usr/lib/MailScanner/MailScanner/CustomFunctions
FileCommand		/usr/bin/file
inqueuedir		/var/spool/mqueue.in
LDAPbase
LDAPserver
LDAPsite
# LockType *must not* have a static default
LockType
LogFacility		mail
MinimumCodeStatus	supported
MTA			sendmail
QuarantineUser
QuarantineGroup
QuarantinePerms		0600
RunAsUser		0
RunAsGroup		0
SAVIWatchFiles		/usr/local/Sophos/ide/*.zip
SophosAllowedErrors	
sophoside		
sophoslib		
SpamAssassinUserStateDir
SpamAssassinSiteRulesDir
SpamAssassinLocalRulesDir	
SpamAssassinDefaultRulesDir	
SpamAssassinInstallPrefix	
SpamStarsCharacter	s
MCPSpamAssassinUserStateDir
MCPSpamAssassinLocalRulesDir	/etc/MailScanner/mcp
MCPSpamAssassinDefaultRulesDir	/etc/MailScanner/mcp
MCPSpamAssassinInstallPrefix	/etc/MailScanner/mcp
TNEFExpander		/usr/bin/tnef --maxsize=100000000
VirusScanners		none  # Space-separated list
WorkUser
WorkGroup
WorkPerms		0600

#
# These variables match on any rule matching From:, else anything for To:
#

[First,YesNo]
AllowExternal		0	no	0	yes	1
AllowPartial		0	no	0	yes	1
ArchivePublicKeys	0	no	0	yes	1
blacklistedishigh	0	no	0	yes	1
CheckSAIfOnSpamList	1	no	0	yes	1
ContentPrependSubject	1	no	0	yes	1
DeliverDisinfected	1	no	0	yes	1
DeliverSilent		1	no	0	yes	1
deliverunparsabletnef	0	no	0	yes	1
deliverymethod		batch	batch	batch	queue	queue
EnableSpamBounce	0	no	0	yes	1
findarchivesbycontent	1	no	0	yes	1
HamActions		deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
HideWorkDir		1	no	0	yes	1
HideWorkDirInNotice	0	no	0	yes	1
HighScoreSpamActions	deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
HighScoreMCPActions	deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
HighSpamPrependSubject	1	no	0	yes	1
IncludeSpamHeader	0	no	0	yes	1
IncludeMCPHeader	0	no	0	yes	1
LastLookup		0	no	0	yes	1
ListSAScores		0	no	0	yes	1
#LoadSpamAssassin	0	no	0	yes	1
LogIFrameTags		0	no	0	yes	1
LogPermittedFilenames	0	no	0	yes	1
LogPermittedFiletypes	0	no	0	yes	1
MultipleHeaders		append	append	append	replace	replace	add	add
NamePrependSubject	1	no	0	yes	1
NonMCPActions		deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
NoticeFullHeaders	0	no	0	yes	1
scannedmodifysubject	0	no	0	start	start	end	end
SendNotices		1	no	0	yes	1
SignAlreadyScanned	0	no	0	yes	1
SignCleanMessages	1	no	0	yes	1
SignUnscannedMessages	1	no	0	yes	1
SpamActions		deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
SpamBlacklist		0	no	0	yes	1
SpamDetail		1	no	0	yes	1
SpamChecks		1	no	0	yes	1
SpamPrependSubject	1	no	0	yes	1
SpamScoreNotStars	0	no	0	yes	1
SpamWhitelist		0	no	0	yes	1
StripDangerousTags	0	no	0	yes	1
MCPActions		deliver	deliver	deliver	delete	delete	store	store					forward	forward	bounce	bounce							striphtml striphtml								attachment	attachment	notify	notify
MCPBlacklist		0	no	0	yes	1
MCPblacklistedishigh	0	no	0	yes	1
MCPChecks		0	no	0	yes	1
MCPDetail		1	no	0	yes	1
MCPListSAScores		0	no	0	yes	1
MCPWhitelist		0	no	0	yes	1
VirusPrependSubject	1	no	0	yes	1
VirusScan		1	no	0	yes	1
warningisattachment	1	no	0	yes	1
WarnSenders		0	no	0	yes	1
WarnVirusSenders	0	no	0	yes	1
WarnNameSenders		1	no	0	yes	1
WarnOtherSenders	1	no	0	yes	1

[First,File]
DeletedContentMessage	/etc/MailScanner/reports/en/deleted.content.message.txt
DeletedFilenameMessage	/etc/MailScanner/reports/en/deleted.filename.message.txt
DeletedVirusMessage	/etc/MailScanner/reports/en/deleted.virus.message.txt
DisinfectedReportText	/etc/MailScanner/reports/en/disinfected.report.txt
inlinehtmlsig		/etc/MailScanner/reports/en/inline.sig.html
inlinehtmlwarning	/etc/MailScanner/reports/en/inline.warning.html
inlinespamwarning	/etc/MailScanner/reports/en/inline.spam.warning.txt
inlinetextsig		/etc/MailScanner/reports/en/inline.sig.txt
inlinetextwarning	/etc/MailScanner/reports/en/inline.warning.txt
languagestrings		
recipientmcpreport	/etc/MailScanner/reports/en/recipient.mcp.report.txt
recipientspamreport	/etc/MailScanner/reports/en/recipient.spam.report.txt
sendercontentreport 	/etc/MailScanner/reports/en/sender.content.report.txt
sendererrorreport 	/etc/MailScanner/reports/en/sender.error.report.txt
senderfilenamereport	/etc/MailScanner/reports/en/sender.filename.report.txt
SenderRBLSpamReport	/etc/MailScanner/reports/en/sender.spam.rbl.report.txt
SenderSASpamReport	/etc/MailScanner/reports/en/sender.spam.sa.report.txt
SenderSAMCPReport	/etc/MailScanner/reports/en/sender.mcp.report.txt
SenderBothSpamReport	/etc/MailScanner/reports/en/sender.spam.report.txt
sendervirusreport 	/etc/MailScanner/reports/en/sender.virus.report.txt
StoredContentMessage	/etc/MailScanner/reports/en/stored.content.message.txt
StoredFilenameMessage	/etc/MailScanner/reports/en/stored.filename.message.txt
StoredVirusMessage	/etc/MailScanner/reports/en/stored.virus.message.txt

[First,Command]
Sendmail		/usr/sbin/sendmail

[First,Dir]
OutQueueDir			/var/spool/mqueue
PublicKeyArchiveDir		#/var/spool/MailScanner/keys
quarantinedir			/var/spool/MailScanner/quarantine

[First,Number]
HighRBLs			5
HighSpamAssassinScore		15
MaxAttachmentSize		-1
MaxMessageSize			0
MaxParts			200
MaxSpamListTimeouts		7
MaxZipDepth			2
MCPErrorScore			1
MCPHighSpamAssassinScore	10
MCPReqSpamAssassinScore		1
MinStars			0
ReqSpamAssassinScore		5

[First,Other]
AttachmentCharset		us-ascii
AttachmentWarningFilename	VirusWarning.txt
cleanheader			Found to be clean
ContentSubjectText		{DANGEROUS?}
dirtyheader			Found to be infected
DisinfectedHeader		Disinfected
EnvFromHeader			X-MailScanner-Envelope-From:
EnvToHeader			X-MailScanner-Envelope-To:
HighSpamSubjectText		{SPAM?}
Hostname			the MailScanner
InfoHeader			
InfoValue			See www.mailscanner.info for information
LocalPostmaster			postmaster
MailHeader			X-MailScanner:
NameSubjectText			{VIRUS?}
NoticesFrom			MailScanner
NoticeSignature			-- \nMailScanner\nEmail Virus Scanner\nwww.mailscanner.info
ScannedSubjectText		{Scanned}
Sendmail2			/usr/sbin/sendmail
SpamHeader			X-MailScanner-SpamCheck:
SpamSubjectText			{SPAM?}
SpamStarsHeader			X-MailScanner-SpamScore:
MCPHeader			X-MailScanner-MCPCheck:
UnscannedHeader			Not scanned: please contact your Internet E-Mail Service Provider for details
VirusSubjectText		{VIRUS?}

[All,YesNo]
AddEnvFrom		0	no	0	yes	1
AddEnvTo		0	no	0	yes	1
AllowIFrameTags		0	no	0	yes	1	disarm	convert
AllowFormTags		0	no	0	yes	1	disarm	convert
AllowObjectTags		0	no	0	yes	1	disarm	convert
AllowScriptTags		0	no	0	yes	1	disarm	convert
AllowPassZips		0	no	0	yes	1
AllowWebBugTags		1	yes	1	disarm	convert
BlockEncrypted		0	no	0	yes	1
BlockUnencrypted	0	no	0	yes	1
DangerScan		1	no	0	yes	1
DeliverCleanedMessages	1	no	0	yes	1
markinfectedmessages	1	no	0	yes	1
HtmlToText		0	no	0	yes	1
QuarantineInfections	1	no	0	yes	1
QuarantineSilent	1	no	0	yes	1
QuarantineWholeMessage	0	no	0	yes	1
SpamStars		0	no	0	yes	1
MCPUseSpamAssassin	1	no	0	yes	1
UseSpamAssassin		0	no	0	yes	1

[All,File]
#FilenameRules		/etc/MailScanner/filename.rules.conf

[All,Other]
# This is the other stuff that came up in the search that I haven't
# figured out what to do with yet...
ArchiveMail
FilenameRules		
FiletypeRules		
NoisyViruses			wm97
NoSenderPrecedence
NoticeRecipient			postmaster
SilentViruses			All-Viruses
SpamDomainList			
SpamList

