#!/bin/sh

echo
if [ -x /bin/rpmbuild ]; then
  RPMBUILD=/bin/rpmbuild
elif [ -x /usr/bin/rpmbuild ]; then
  RPMBUILD=/usr/bin/rpmbuild
elif [ -x /bin/rpm ]; then
  RPMBUILD=/bin/rpm
elif [ -x /usr/bin/rpm ]; then
  RPMBUILD=/usr/bin/rpm
else
  echo I cannot find any rpm or rpmbuild command on your path.
  echo Please check you are definitely using an RPM-based system.
  echo If you are, then please install the RPMs called rpm and
  echo rpm-build, then try running this script again.
  echo
  exit 1
fi

echo
if [ -x /bin/patch -o -x /usr/bin/patch ]; then
  echo Good. You have the patch command.
else
  echo You need to install the patch command from your Linux distribution.
  echo Once you have done that, please try running this script again.
  exit 1
fi

# Check that /usr/src/redhat exists
echo
if [ -d /usr/src/redhat ]; then
  echo Good, you have /usr/src/redhat in place.
  RPMROOT=/usr/src/redhat
elif [ -d /usr/src/RPM ]; then
  echo Okay, you have /usr/src/RPM.
  RPMROOT=/usr/src/RPM
elif [ -d /usr/src/packages ]; then
  echo Okay, you have /usr/src/packages.
  RPMROOT=/usr/src/packages
else
  echo Your /usr/src/redhat, /usr/src/RPM or /usr/src/packages
  echo tree is missing.
  echo If you have access to an RPM called rpm-build or rpmbuild
  echo then install it first and come back and try again.
  echo
  exit 1
fi

# Ensure that the RPM macro
# %_unpackaged_files_terminate_build 1
# is set. Otherwise package building will fail.
echo
if grep -qs '%_unpackaged_files_terminate_build[ 	][ 	]*0' ~/.rpmmacros
then
  echo Good, unpackaged files will not break the build process.
else
  echo Writing a .rpmmacros file in your home directory to stop
  echo unpackaged files breaking the build process.
  echo You can delete it once MailScanner is installed if you want to.
  echo '%_unpackaged_files_terminate_build 0' >> ~/.rpmmacros
  echo
  sleep 10
fi

# Check they don't have 2 Perl installations, this will cause all sorts
# of grief later.
echo
if [ \! "x$1" = "xignore-perl" ] ; then
  if [ -x /usr/bin/perl -a -f /usr/local/bin/perl -a -x /usr/local/bin/perl ] ;
  then
    echo You appear to have 2 versions of Perl installed,
    echo the normal one in /usr/bin and one in /usr/local.
    echo This often happens if you have used CPAN to install modules.
    echo I strongly advise you remove all traces of perl from
    echo within /usr/local and then run this script again.
    echo
    echo If you do not want to do that, and really want to continue,
    echo then you will need to run this script as
    echo '        ./install.sh ignore-perl'
    echo
    exit 1
  else
    echo Good, you appear to only have 1 copy of Perl installed.
  fi
fi

# Check to see if they want to ignore dependencies in the final
# MailScanner RPM install.
if [ "x$1" = "xnodeps" -o "x$2" = "xnodeps" ]
then
  NODEPS='--nodeps'
else
  NODEPS=
fi

# Check that they aren't on a RaQ3 with a broken copy of Perl 5.005003.
if [ -d /usr/lib/perl5/5.00503/i386-linux/CORE ]; then
  echo
  echo I think you are running Perl 5.00503.
  echo Ensuring that you have all the header files that are needed
  echo to build HTML-Parser which is used by both MailScanner and
  echo SpamAssassin.

  touch /usr/lib/perl5/5.00503/i386-linux/CORE/opnames.h
  touch /usr/lib/perl5/5.00503/i386-linux/CORE/perlapi.h
  touch /usr/lib/perl5/5.00503/i386-linux/CORE/utf8.h
  touch /usr/lib/perl5/5.00503/i386-linux/CORE/warnings.h
fi

# Check that they aren't missing pod2text but have pod2man.
if [ -x /usr/bin/pod2man -a \! -x /usr/bin/pod2text ] ; then
  echo
  echo You appear to have pod2man but not pod2text.
  echo Creating pod2text for you.
  ln -s pod2man /usr/bin/pod2text
fi

# Check they have the development tools installed on SuSE
if [ -f /etc/SuSE-release -o -f /etc/redhat-release ]; then
  echo
  echo I think you are running on RedHat Linux or SuSE Linux.
  GCC=gcc
  if [ -f /etc/redhat-release ] && fgrep -q ' 6.' /etc/redhat-release ; then
      # RedHat used egcs in RedHat 6 and not gcc
      GCC=egcs
  fi
  if rpm -q binutils glibc-devel $GCC make >/dev/null 2>&1 ; then
    echo Good, you appear to have the basic development tools installed.
    sleep 5
  else
    echo You must have the following RPM packages installed before
    echo you try and do anything else:
    echo '       binutils glibc-devel' $GCC 'make'
    echo You are missing at least 1 of these.
    echo Please install them all
    echo '(Read the manuals if you do not know how to do this).'
    echo Then come back and run this install.sh script again.
    echo
    exit 1
  fi
fi

echo
echo This script will pause for a few seconds after each major step,
echo so do not worry if it appears to stop for a while.
echo If you want it to stop so you can scroll back through the output
echo then press Ctrl-S to stop the output and Ctrl-Q to start it again.
echo
sleep 10

echo
echo If this fails due to dependency checks, and you wish to ignore
echo these problems, you can run
echo '    ./install.sh nodeps'
sleep 5

echo
echo Rebuilding all the Perl RPMs for your version of Perl
echo
sleep 5

while read MODNAME MODFILE VERS BUILD ARC
do
  # If the module version is already installed, go onto the next one
  # (unless it is MIME-tools which is always rebuilt.
  if ./CheckModuleVersion ${MODNAME} ${VERS} ; then
    echo Oh good, module ${MODNAME} version ${VERS} is already installed.
    echo
    sleep 5
  else
    FILEPREFIX=perl-${MODFILE}-${VERS}-${BUILD}
    echo Attempting to build and install ${FILEPREFIX}
    if [ -f ${FILEPREFIX}.src.rpm ]; then
      $RPMBUILD --rebuild ${FILEPREFIX}.src.rpm
      sleep 10
      echo
      echo
      echo
    else
      echo Missing file ${FILEPREFIX}.src.rpm. Are you in the right directory\?
      sleep 10
      echo
    fi
    if [ -f ${RPMROOT}/RPMS/${ARC}/${FILEPREFIX}.${ARC}.rpm ]; then
      echo
      echo Do not worry too much about errors from the next command.
      echo It is quite likely that some of the Perl modules are
      echo already installed on your system.
      echo
      echo The important ones are HTML-Parser and MIME-tools.
      echo
      sleep 10
      if [ -f /etc/SuSE-release -a "x${MODFILE}" = "xMIME-tools" ];
      then
        echo As you are running SuSE, I have to force installation of
        echo the MIME-tools package to ensure you have all the security
        echo patches applied.
        rpm -Uvh --force ${NODEPS} ${RPMROOT}/RPMS/${ARC}/${FILEPREFIX}.${ARC}.rpm
      else
        rpm -Uvh ${NODEPS} ${RPMROOT}/RPMS/${ARC}/${FILEPREFIX}.${ARC}.rpm
      fi
      sleep 10
      echo
      echo
      echo
    else
      echo Missing file ${RPMROOT}/RPMS/${ARC}/${FILEPREFIX}.${ARC}.rpm.
      echo Maybe it did not build correctly\?
      sleep 10
      echo
    fi
  fi
done << EOF
ExtUtils::MakeMaker ExtUtils-MakeMaker 6.05 1	noarch
Net::CIDR	Net-CIDR	0.09	3	noarch
IsABundle	IO-stringy	2.108	1	noarch
MIME::Base64	MIME-Base64	2.12	1	i386
IsABundle	TimeDate	1.1301	3	noarch
IsABundle	MailTools	1.50	1	noarch
File::Spec	File-Spec	0.82	1	noarch
File::Temp	File-Temp	0.12	1	noarch
HTML::Tagset	HTML-Tagset	3.03	1	noarch
HTML::Parser	HTML-Parser	3.26	2	i386
IsABundle	MIME-tools	5.411	pl4.3	noarch
Convert::TNEF	Convert-TNEF	0.17	1	noarch
Compress::Zlib	Compress-Zlib	1.33	2	i386
Archive::Zip	Archive-Zip	1.09	3	noarch
Convert::BinHex	Convert-BinHex	1.119	2	noarch
EOF

echo
echo Installing tnef decoder
echo

rpm -Uvh tnef*i386.rpm

echo
echo Now to install MailScanner itself.
echo

if [ -d /usr/local/MailScanner ] ; then
  echo
  echo
  echo Please remember to kill all the old mailscanner version 3
  echo processes before you start the new version.
  echo
fi

rpm -Uvh ${NODEPS} mailscanner*noarch.rpm

rpmnew=`ls /usr/lib/MailScanner/*rpmnew 2>/dev/null | wc -w`
if [ $rpmnew -ne 0 ]; then
  echo
  echo 'There are new *.rpmnew files in /usr/lib/MailScanner.'
  echo 'You should rename each of these over the top of the old'
  echo 'version of each file, but remember to copy any changes'
  echo 'you have made to the old versions.'
  echo
fi

