/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <ctype.h>
#include <string.hpp>
#include "video.h"
#include "misc.h"
#include "music.h"
#define INITGUID
#include <windows.h>
#include <ddraw.h>

#define vidScreenPtr	((uchar*)videoMem)

PAGE current_page = 0;

IDirectDraw* dd = 0;
IDirectDrawSurface *front, *back, *offscreen;
IDirectDrawPalette* ddpal;
int real_bpl = 0;

extern HWND hwnd;
extern HINSTANCE hInstance;

void vidDoInitVideo() {
  if( DirectDrawCreate( 0, &dd, 0 ) != DD_OK ) {
    error( "DirectDraw not supported" );
  }
}

void vidSetVideoMode( int num ) {

  int w = num >> 16, h = num & 0xFFFF;

  DDSURFACEDESC       ddsd;
  DDSCAPS	      ddscaps;

  if( DD_OK !=
      dd->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN ) ) {
    error( "Cannot go fullscreen" );
  }
  if( DD_OK != dd->SetDisplayMode( w, h, 8 ) ) {
    error( "Cannot set video mode" );
  }
  ddsd.dwSize = sizeof( ddsd );
  ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
  ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
			DDSCAPS_FLIP |
			DDSCAPS_COMPLEX;
  ddsd.dwBackBufferCount = 1;
  if( DD_OK != dd->CreateSurface( &ddsd, &front, NULL ) ) {
    error( "Cannot create primary surface" );
  }
  ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
  if( DD_OK != front->GetAttachedSurface(&ddscaps, &back) ) {
    error( "Cannot get attached surface" );
  }

/*
  ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
  ddsd.dwWidth = w;
  ddsd.dwHeight = h;
  ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
  if( DD_OK != dd->CreateSurface( &ddsd, &offscreen, NULL ) ) {
    error( "Cannot create offscreen surface" );
  }
*/

  PALETTEENTRY foo[256];
  for( int i=0; i<256; i++ ) {
    foo[i].peRed = foo[i].peGreen = foo[i].peBlue = i;
  }
  if( DD_OK !=
      dd->CreatePalette( DDPCAPS_8BIT | DDPCAPS_ALLOW256, foo, &ddpal, 0 ) ) {
    error( "Cannot create palette" );
  }
  if( DD_OK != front->SetPalette( ddpal ) ) {
    error( "Cannot set surface palette" );
  }
  front->GetSurfaceDesc( &ddsd );
  vidBytesPerLine = vidSizeX = ddsd.dwWidth;
  vidSizeY = ddsd.dwHeight;;
  real_bpl = ddsd.lPitch;
  vidPageSize = vidBytesPerLine*vidSizeY;
  vidMaxPage = 1;
  current_page = vidAllocPage();
  vidInitialized = true;
}

void vidDoCloseVideo() {
  if(dd) {
    dd->Release();
    dd = 0;
  }
//  vidFreePage(current_page);
  current_page = 0;
}

int modes[256]={0};

HRESULT WINAPI enumCallback( LPDDSURFACEDESC sd, void* hwnd )
{
  uint w=sd->dwWidth, h=sd->dwHeight, bpp=sd->ddpfPixelFormat.dwRGBBitCount;
  if( bpp == 8 && w <= VID_MAX_SIZE_X && h <= VID_MAX_SIZE_Y ) {
    char str[256];
    sprintf( str, "%dx%d %dbpp", w, h, bpp );
    SendMessage( *(HWND*)hwnd, LB_SETITEMDATA,
		 SendMessage( *(HWND*)hwnd, LB_ADDSTRING, 0, (LPARAM)str ),
		 (w<<16)+h );
  }
  return S_FALSE;
}

BOOL CALLBACK DialogProc( HWND hwnd, UINT uMsg,
			  WPARAM wParam, LPARAM lParam )
{
  switch( uMsg ) {
    case WM_INITDIALOG: {
      HWND lb = GetDlgItem( hwnd, 667 );
      if( DD_OK != dd->EnumDisplayModes( 0, 0, &lb, enumCallback ) ) {
	error( "Cannot enumerate display modes" );
      }
      return TRUE;
    }
    case WM_COMMAND: {
      if( HIWORD(wParam) == BN_CLICKED ) {
	HWND lb = GetDlgItem( hwnd, 667 );
	EndDialog( hwnd, SendMessage( lb, LB_GETITEMDATA,
	  SendMessage( lb, LB_GETCURSEL, 0, 0 ), 0 ) );
      }
    }
  }
  return FALSE;
}

int vidChooseVideoMode() {
  return (640<<16)+480;

//  return DialogBox( hInstance, MAKEINTRESOURCE(666),
//		    hwnd, (DLGPROC)DialogProc );

}

void vidDoSetPalette( vidRGB* pal, int border )
{
  PALETTEENTRY win_pal[256];
  for( int i=0; i<256; i++ ) {
    win_pal[i].peRed = pal[i].r;
    win_pal[i].peGreen = pal[i].g;
    win_pal[i].peBlue = pal[i].b;
  }
  if( DD_OK != ddpal->SetEntries( 0, 0, 256, win_pal ) ) {
    error( "Cannot change palette" );
  }
}

void vidShowPage( uchar* page )
{
  DDSURFACEDESC ddsd;
  ddsd.dwSize = sizeof(ddsd);
  HRESULT ddrval;
/*
  while( (ddrval = offscreen->Lock(NULL, &ddsd, 0, NULL))
	 == DDERR_WASSTILLDRAWING);
  if( ddrval == DD_OK ) {
    uchar* to = (uchar*)ddsd.lpSurface;
    for( int y=0; y<vidSizeY; y++ ) {
      memcpy( to, page, vidSizeX );
      to += real_bpl; page += vidBytesPerLine;
    }
    offscreen->Unlock(0);
  }
  RECT r = { 0, 0, vidSizeX-1, vidSizeY-1 };
  back->BltFast( 0, 0, offscreen, &r, DDBLTFAST_NOCOLORKEY );
*/

  while( ddrval = back->Lock(NULL, &ddsd, 0, NULL) == DDERR_SURFACELOST ) {
    if( front->Restore() != DD_OK ) return;
  }
  if( ddrval != DD_OK ) {
    return;
  }
  uchar* to = (uchar*)ddsd.lpSurface;
  for( int y=0; y<vidSizeY; y++ ) {
    memcpy( to, page, vidSizeX );
    to += real_bpl; page += vidBytesPerLine;
  }
  back->Unlock(0);

  while( DDERR_SURFACELOST == front->Flip(0,DDFLIP_WAIT) ) {
    front->Restore();
  }
}

static int total;

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage((PAGE)current_page);
}

void vidMessage( char* msg )
{
  MessageBox( hwnd, msg, PROJECT_NAME, MB_OK );
}
