/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <vga.h>
#include "video.h"
#include "misc.h"

enum { vidMode13, vidModeLinear, vidModeBanked } vidModeType;
int bank_size = 65536; // fuck
PAGE current_page = 0;

void vidDoSetPalette( vidRGB pal[256], int border )
{
  int tmp[768];
  for( int i=0; i<256; i++ ) {
    tmp[i*3] = pal[i].r >> 2;
    tmp[i*3+1] = pal[i].g >> 2;
    tmp[i*3+2] = pal[i].b >> 2;
  }
  vga_setpalvec( 0, 256, tmp );
}

void vidShowPage( unsigned char* page )
{
  if( !vga_oktowrite() ) return;
  if( vidModeType == vidMode13 || vidModeType == vidModeLinear ) {
    memcpy( graph_mem, page, vidPageSize );
  }
  else {
    for( int i=0; i<vidPageSize; i+=bank_size ) {
      vga_setpage(i/bank_size);
      if( i+bank_size > vidPageSize ) {
        memcpy( graph_mem, page, vidPageSize-i );
      }
      else {
        memcpy( graph_mem, page, bank_size );
      }
      page += bank_size;
    }
  }
}

void vidDoInitVideo()
{
  vga_init();
  vga_runinbackground(1);
}

int vidChooseVideoMode()
{
  return G640x480x256;

  int modes[256] = {0};
  char maxmode = '0';
  for( int i=0; i<=G640x480x256; i++ ) {
    if( vga_hasmode(i) ) {
      vga_modeinfo* mi = vga_getmodeinfo(i);
      if( mi->width <= VID_MAX_SIZE_X &&
          mi->height <= VID_MAX_SIZE_Y &&
          mi->bytesperpixel == 1 ) {
        printf( "%c) %dx%dx256\n", maxmode, mi->width, mi->height );
        vidHiResMode = modes[ maxmode++ ] = i;
      }
    }
  }
  int c;
  do {
    printf( "Choose video mode : " );
    c = getchar();
  } while( c < '0' || c >= maxmode );
  return modes[c];
}

void vidSetVideoMode( int mode )
{
  if( vga_setmode( mode ) ) {
    error( "cannot set video mode" );
  }
//  vga_setlinearaddressing();
  vga_modeinfo* mi = vga_getmodeinfo( mode );
  if( mi->flags & IS_LINEAR) {
    vidModeType = vidModeLinear;
    graph_mem = vga_getgraphmem();
  }
  else if( mode == G320x200x256 )
    vidModeType = vidMode13;
  else
    vidModeType = vidModeBanked;

  vidSizeX = mi->width;
  vidBytesPerLine = mi->linewidth;
  vidSizeY = mi->height;
  vidPageSize = vidBytesPerLine*vidSizeY;
  if( current_page ) cfree(current_page);
  current_page = vidAllocPage();
}

void vidDoCloseVideo()
{
  vga_setmode(0);
}

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage(current_page);
}

void vidMessage( char* str )
{
  puts(str);
}
