/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <mem.h>
#include <ctype.h>
#define INCL_DOS
#define INCL_GPI
#define INCL_WIN
#include <os2.h>
#include <pmddi.h>
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>
#include "video.h"
#include "misc.h"

PAGE current_page = 0;

#define  IDD_SIZEDLG	666
#define  IDD_SPIN	667

#define  ID_ERROR	667
#define  ID_BLIT	668
#define  ID_SNAP	669
#define  ID_SETMODE	670
#define  ID_FPS 	671

HWND	  vidWindow = 0,  hwndClient;
HAB	  hab;
BOOL	  physPalette;
LONG	  cxWidthWindow;
LONG	  cyHeightWindow;
HDIVE	  hDive;
ULONG	  diveBuffer = 0;
BOOL	  needResize = FALSE;
HEV	  syncSem;
BOOL	  release_timeslices=0;
KB	  current_key = KB_NONE;
char*	  restore_hint;
MRESULT EXPENTRY SizeDlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{

  switch(msg) {
    case WM_INITDLG: {
       WinSendDlgItemMsg( hwnd, IDD_SPIN, SPBM_SETLIMITS, (MPARAM)640, (MPARAM)320 );
       break;
    }
    case WM_COMMAND: {
      if( (SHORT)mp1 == DID_OK ) {
	WinSendDlgItemMsg( hwnd, IDD_SPIN, SPBM_QUERYVALUE, &vidSizeX, 0 );
	WinDismissDlg(hwnd, vidSizeX);
	break;
      }
    }
    default:
      return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

MRESULT EXPENTRY MyWindowProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  switch( msg ) {

    case WM_CHAR: {

      if( SHORT1FROMMP(mp1) & (KC_PREVDOWN|KC_KEYUP) ) break;

      switch( SHORT2FROMMP ( mp2 ) ) {
	case VK_ESC: {
	  current_key = KB_ESC;
	  break;
	}
	case VK_F11: {
	  current_key = KB_F11;
	  break;
	}
	case VK_F5: {
	  WinSendMsg ( hwnd, WM_COMMAND, (MPARAM)ID_SNAP, 0 );
	  break;
	}
	case VK_F6: {
	  SWP swp;
	  WinQueryWindowPos(vidWindow,&swp);
	  swp.cy = (swp.cx-WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)*vidSizeY/vidSizeX+
		   WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2+
		   WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
	  WinSetWindowPos( vidWindow,0,
			   ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - swp.cx ) / 2,
			   ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - swp.cy ) / 2,
			   swp.cx,swp.cy,SWP_MOVE|SWP_SIZE|SWP_SHOW|SWP_ACTIVATE );
	  break;
	}
	case VK_F12: {
	  release_timeslices = !release_timeslices;
	  break;
	}
	default: {
	  switch( (uchar)SHORT1FROMMP ( mp2 ) ) {
	    case '+': {
	      current_key = KB_PLUS;
	      break;
	    }
	    case '-': {
	      current_key = KB_MINUS;
	      break;
	    }
	  }
	}
      }
      break;
    }

    case WM_COMMAND: {

      switch ( (int)mp1 ) {

	case ID_SNAP: {
	  LONG	    cxWindowPos;
	  LONG	    cyWindowPos;
	  cxWindowPos = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN)
			  - cxWidthWindow ) / 2;
	  cyWindowPos = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)
			   - cyHeightWindow ) / 2;
	  WinSetWindowPos ( vidWindow, HWND_TOP, cxWindowPos, cyWindowPos,
			    cxWidthWindow, cyHeightWindow,
			    SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );
	  restore_hint = "";
	  WinShowWindow( vidWindow, TRUE );
	  break;
	}

	case ID_ERROR: {
	  WinAlarm( HWND_DESKTOP, WA_WARNING );
	  WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
			     (PSZ)mp2, PROJECT_NAME, 0, MB_OK | MB_INFORMATION );
	  DosPostEventSem(syncSem);
	  break;
	}

	case IDD_SIZEDLG: {
	  WinDlgBox( HWND_DESKTOP, HWND_DESKTOP, &SizeDlgProc, 0, IDD_SIZEDLG, 0 );
	  DosPostEventSem(syncSem);
	  break;
	}

	case ID_FPS: {
	  char str[256];
	  sprintf( str, PROJECT_NAME": %5.2f fps      %s",
		   *(float*)mp2, restore_hint );
	  WinSetWindowText( vidWindow, str );
	  break;
	}

	case ID_SETMODE: {
	  vidSizeX = vidBytesPerLine = (((int)mp2+3)/4)*4;
	  vidSizeY = vidSizeX*3/4;
	  vidPageSize = vidSizeX*vidSizeY;
	  vidMaxPage = 1;

	  if( !diveBuffer ) DiveFreeImageBuffer ( hDive, diveBuffer );
	  if ( DiveAllocImageBuffer ( hDive, &diveBuffer, FOURCC_LUT8,
				      vidSizeX,vidSizeY, 0, 0 ) ) {
	    error( "DIVE: cannot allocate image buffer" );
	  }

	  LONG cxWidthBorder = (LONG) WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER);
	  LONG cyWidthBorder = (LONG) WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER);
	  LONG cyTitleBar    = (LONG) WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);

	  cxWidthWindow  = vidSizeX + cxWidthBorder * 2;
	  cyHeightWindow = vidSizeY + (cyWidthBorder * 2 + cyTitleBar );

	  WinSendMsg( vidWindow, WM_VRNENABLED, 0, 0 );
	  WinPostMsg ( hwnd, WM_COMMAND, (MPARAM)ID_SNAP, 0 );

	  DosPostEventSem(syncSem);
	  break;
	}
      }
      break;
    }

    case WM_MINMAXFRAME: {
      if( ((PSWP)mp1)->fl | (SWP_HIDE|SWP_MINIMIZE) ) {
    case WM_VRNDISABLED:
	DiveSetupBlitter ( hDive, 0 );
      }
      break;
    }

    case WM_VRNENABLED: {

      POINTL	pointl;
      SWP	swp;
      HRGN	hrgn;
      HPS	hps;
      RECTL	rcls[50];
      RGNRECT	rgnCtl;
      SETUP_BLITTER SetupBlitter;
      hps = WinGetPS ( hwnd );
      if ( !hps ) break;
      hrgn = GpiCreateRegion ( hps, 0L, NULL );
      if ( hrgn ) {
	WinQueryVisibleRegion ( hwnd, hrgn );
	rgnCtl.ircStart     = 0;
	rgnCtl.crc	    = 50;
	rgnCtl.ulDirection  = 1;

	if ( GpiQueryRegionRects ( hps, hrgn, NULL, &rgnCtl, rcls) ) {
	  WinQueryWindowPos ( hwndClient, &swp );
	  pointl.x = swp.x;
	  pointl.y = swp.y;
	  WinMapWindowPoints ( vidWindow, HWND_DESKTOP, &pointl, 1 );
	  SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
	  SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
	  SetupBlitter.ulSrcWidth = vidSizeX;
	  SetupBlitter.ulSrcHeight = vidSizeY;
	  SetupBlitter.ulSrcPosX = 0;
	  SetupBlitter.ulSrcPosY = 0;
	  SetupBlitter.fInvert = TRUE;
	  SetupBlitter.ulDitherType = 0;

	  SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
	  SetupBlitter.ulDstWidth = swp.cx;
	  SetupBlitter.ulDstHeight = swp.cy;
	  if( swp.cx != vidSizeX || swp.cy != vidSizeY ) {
	    restore_hint = "(press 'F5' to restore original window size)";
	  }
	  else {
	    restore_hint = "";
	  }
	  SetupBlitter.lDstPosX = 0;
	  SetupBlitter.lDstPosY = 0;
	  SetupBlitter.lScreenPosX = pointl.x;
	  SetupBlitter.lScreenPosY = pointl.y;
	  SetupBlitter.ulNumDstRects = rgnCtl.crcReturned;
	  SetupBlitter.pVisDstRects = rcls;
	  DiveSetupBlitter ( hDive, &SetupBlitter );
	}
	else DiveSetupBlitter ( hDive, 0 );

	GpiDestroyRegion( hps, hrgn );
      }
      WinReleasePS( hps );
      break;
    }

    case WM_REALIZEPALETTE: {
      DiveSetDestinationPalette ( hDive, 0, 0, 0 );
      break;
    }

    default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
  }
  return ( FALSE );
}

void MessageLoop( void* foo )
{
   ULONG     flCreate;		   /* Window creation control flags	   */
   QMSG      qmsg;			   /* Message from message queue	   */
   HMQ	     hmq;			   /* Message queue handle		   */

   hab = WinInitialize ( 0 );
   hmq = WinCreateMsgQueue ( hab, 0 );

   WinRegisterClass ( hab, PROJECT_NAME, MyWindowProc, 0, sizeof(ULONG) );
   flCreate =  FCF_TASKLIST | FCF_SYSMENU  | FCF_TITLEBAR /*| FCF_ICON*/ |
	       FCF_SIZEBORDER | FCF_MINMAX | FCF_SHELLPOSITION;
   vidWindow = WinCreateStdWindow ( HWND_DESKTOP,
				    WS_VISIBLE, &flCreate,
				    PROJECT_NAME, PROJECT_NAME,
				    WS_SYNCPAINT | WS_VISIBLE,
				    0, 0, &hwndClient);
   WinShowWindow( vidWindow, FALSE );

   WinSetVisibleRegionNotify( hwndClient, TRUE );
   DosPostEventSem(syncSem);

  DosSetPrty( 2, 2, -31, 0 );
   while ( WinGetMsg ( hab, &qmsg, 0, 0, 0 ) ) {
      WinDispatchMsg ( hab, &qmsg );
   }

   DiveSetupBlitter ( hDive, 0 );
   WinSetVisibleRegionNotify ( hwndClient, FALSE );
   WinDestroyWindow ( vidWindow );
   WinDestroyMsgQueue ( hmq );
   WinTerminate ( hab );
   DosExit( 1, 0 );
}

void vidDoInitVideo() {
  DosCreateEventSem(0,&syncSem,0,0);
  _beginthread( &MessageLoop, malloc(16384), 16384, 0 );
  DosWaitEventSem(syncSem,SEM_INDEFINITE_WAIT);

  DIVE_CAPS DiveCaps = {0};
  FOURCC   fccFormats[100] = {0};
  DiveCaps.pFormatData = fccFormats;
  DiveCaps.ulFormatLength = 100;
  DiveCaps.ulStructLen = sizeof(DIVE_CAPS);
  if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN )) {
    error( "DIVE: cannot query capabilities" );
  }
  if ( DiveCaps.ulDepth < 8 ) {
    error( "DIVE: at least 256-color capable display required" );
  }
  if ( DiveOpen ( &hDive, FALSE, 0 ) ) {
    error( "DIVE: cannot open" );
  }
  physPalette = DiveCaps.fccColorEncoding == FOURCC_LUT8;
}

void vidSetVideoMode( int num ) {
  ULONG foo;
  DosResetEventSem(syncSem,&foo);
  WinPostMsg( vidWindow, WM_COMMAND, (MPARAM)ID_SETMODE, (MPARAM)num );
  DosWaitEventSem(syncSem,SEM_INDEFINITE_WAIT);
  if( current_page ) cfree(current_page);
  current_page = vidAllocPage();
}

void vidDoCloseVideo() {
  DiveFreeImageBuffer( hDive, diveBuffer );
  DiveClose( hDive );
}

int vidChooseVideoMode() {

  return VID_MAX_SIZE_X;

  ULONG foo;

  DosResetEventSem(syncSem,&foo);
  if( WinIsWindow( hab, hwndClient ) ) WinPostMsg( vidWindow, WM_COMMAND, (MPARAM)IDD_SIZEDLG, 0 );
  DosWaitEventSem(syncSem,SEM_INDEFINITE_WAIT);

  vidHiResMode=VID_MAX_SIZE_X;
  return vidSizeX;
}

void vidDoSetPalette( vidPalette pal ) {
  ULONG auTable[256];
  for( int i=0; i<256; i++ )
    auTable[i] = (PC_RESERVED<<24)|
		 (pal[i].r<<16)|(pal[i].g<<8)|(pal[i].b);

  if( physPalette ) {

    static HPAL oldHpal = 0;
    HPAL hpal = GpiCreatePalette( hab, 0L, LCOLF_CONSECRGB, 256, auTable );
    HPS hps = WinGetPS(vidWindow);
    GpiSelectPalette(hps,hpal);
    ULONG foo ;
    WinRealizePalette(vidWindow,hps,&foo);
    if( oldHpal ) GpiDeletePalette(oldHpal);
    oldHpal = hpal;
    WinReleasePS(hps);
/*
    static HPAL oldHpal = 0;
    HPS hps = WinGetPS(HWND_DESKTOP);
    GpiCreateLogColorTable ( hps, LCOL_PURECOLOR | LCOL_REALIZABLE,
			     LCOLF_CONSECRGB, 0, 256, (PLONG)auTable );
    HPAL hpal = GpiCreatePalette( hab, 0L, LCOLF_CONSECRGB, 256, auTable );
    HDC hdc = GpiQueryDevice(hps);
    GpiSelectPalette(hps,hpal);
    Gre32Entry3( hdc, 0, 0x60C6L );
    WinInvalidateRect ( HWND_DESKTOP, (PRECTL)NULL, TRUE );
    if( oldHpal ) GpiDeletePalette(oldHpal);
    oldHpal = hpal;
    WinReleasePS(hps);
*/
  }
  DiveSetSourcePalette(hDive, 0, 256, (PBYTE)auTable);
}

void vidShowPage( PAGE Page )
{
  static prevTime = 0;
  if( WinIsWindow( hab, vidWindow ) ) {
    ULONG    foo;
    char* Buffer;
    DiveBeginImageBufferAccess ( hDive, diveBuffer, &Buffer, &foo, &foo );
    for( int i=0; i<vidSizeY; i++ )
      memcpy( Buffer+vidBytesPerLine*i, Page+vidBytesPerLine*(vidSizeY-i-1), vidBytesPerLine );
    DiveEndImageBufferAccess ( hDive, diveBuffer );
    DiveBlitImage ( hDive, diveBuffer, DIVE_BUFFER_SCREEN );
    if( !(vidFrameCount%10) ) {
      if( prevTime ) {
	static float fps;
	fps = vidFrameCount*sysTimerRes/(sysTimer()-vidStartTime);
	WinPostMsg( vidWindow, WM_COMMAND, (MPARAM)ID_FPS, &fps );
      }
      prevTime = sysTimer();
    }
  }
  if( release_timeslices ) DosSleep(0);
}

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage(current_page);
}

void vidMessage(char* msg)
{
  if( vidWindow ) {
    ULONG foo;
    DosResetEventSem(syncSem,&foo);
    WinPostMsg( vidWindow, WM_COMMAND, (MPARAM)ID_ERROR, (MPARAM)msg );
    DosWaitEventSem(syncSem,SEM_INDEFINITE_WAIT);
  }
}

KB sysGetKey()
{
  KB foo = current_key;
  current_key = KB_NONE;
  return foo;
}
