/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "parts.h"
#include "font.h"
#include "misc.h"
#include "smooth.h"
#include <string.h>

struct Text: public Part {
  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what );

  RFont* font;
  int n_strings;
  Image* str[16];
  int str_x[16], str_y[16];
  TCollection<char> strings;
  int next_row;
  uchar cur_color;
  int n_string;
};

void Text::Init()
{
  Part::Init();
  font = new RFont( "courie36", true );
  n_strings = 0;
  Parser p( "text.txt" );
  while( !p.eof ) {
    char* s = p.getToken("\r\n");
    if(s) {
      char* str = new char[ strlen(s)+1 ];
      memcpy( str, s, strlen(s)+1 );
      strings.Insert(str);
    }
  }
  n_string = 0;
}

void Text::Start( int what )
{
  Part::Start();
  for( i=0; i<n_strings; i++ ) delete str[i];
  n_strings = 0;
  next_row = 0;
  cur_color = rand()%80+80;
  if( what ) n_string = 0;
}

void Text::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);

  if( row >= next_row || what == 1 ) {
    if( *strings[n_string] == '-' && n_strings != 0 ) {
      next_row = 666;
    }
    else {
      if( *strings[n_string] == '-' ) {
	n_string = (n_string+1) % strings.Count;
      }
      next_row += 12;
      str[n_strings] = font->CreateImage( strings[n_string] );
      str_x[n_strings] = rand()%(vidSizeX-str[n_strings]->sizeX);
      str_y[n_strings] = vidSizeY/10+n_strings*(vidSizeY/6);
      n_strings++;
    }
    n_string = (n_string+1) % strings.Count;
  }
  for( i=0; i<n_strings; i++ ) {
    if( what ) {
//	str[i]->ShowT( str_x[i], str_y[i], color );
      str[i]->ShowT( str_x[i], str_y[i], bw );
    }
    else {
      int dx = rand()%3, dy = rand()%3;
//	int dx = 0, dy = 0;
      str[i]->ShowTC( dx+str_x[i], dy+str_y[i], cur_color, color );
      str[i]->ShowT( dx+str_x[i], dy+str_y[i], bw );
/*
      str[i]->ShowRTC( str_x[i], str_y[i],
		       str[i]->sizeX+dx, str[i]->sizeY+dy,
		       cur_color, color );
      str[i]->ShowRT( str_x[i], str_y[i],
		      str[i]->sizeX+dx, str[i]->sizeY+dy,
		      bw );
*/
    }
  }
}

Part* partText = new Text;
