/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
//#include <stdio.h>
//#include <stdlib.h>
#include <time.h>
#include <process.h>
#include <windows.h>
#include "sys.h"
#include "music.h"

HWND hwnd;
HINSTANCE hInstance;
static HANDLE mainTid = 0;
static KB last_key;

void sysStartup()
{
//  puts( "\n"PROJECT_NAME". (c)97 Queue Members Group Art Division\n" );
  sysResetTimer();
}

void sysCleanup()
{
  PostMessage(hwnd, WM_CLOSE, 0, 0);
  SuspendThread( GetCurrentThread() );
}

uint sysCurrentTime()
{
  return GetTickCount()*1000/sysTimerRes;
}

long FAR PASCAL WindowProc( HWND hWnd, UINT message,
			    WPARAM wParam, LPARAM lParam )
{

  switch( message )  {

    case WM_SETCURSOR: {
      SetCursor(NULL);
      return TRUE;
    }
    case WM_KEYDOWN:
      switch( wParam ) {
	case VK_ESCAPE: {
	  last_key = KB_ESC;
	  break;
	}
	case VK_F11: {
	  last_key = KB_F11;
	  break;
	}
	case VK_ADD: {
	  last_key = KB_PLUS;
	  break;
	}
	case VK_SUBTRACT: {
	  last_key = KB_MINUS;
	  break;
	}
	default: {
	  return 0;
	}
      }
      break;

    case WM_DESTROY: {
      PostQuitMessage( 0 );
      break;
    }
  }
  return DefWindowProc(hWnd, message, wParam, lParam);
}

void demo_thread( void* cmdline )
{
  Startup( (char*)cmdline );
  sysMain(0,0);
  Shutdown();
}

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE prev,
		    LPSTR cmdline, int cmdShow )
{
  WNDCLASS wc;
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = WindowProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  ::hInstance = wc.hInstance = hInstance;
  wc.hIcon = 0;
  wc.hCursor = LoadCursor( NULL, IDC_ARROW );
  wc.hbrBackground = NULL;
  wc.lpszMenuName = PROJECT_NAME;
  wc.lpszClassName = PROJECT_NAME;
  RegisterClass( &wc );

  hwnd = CreateWindowEx(
      WS_EX_TOPMOST,
      PROJECT_NAME,
      PROJECT_NAME,
      WS_POPUP,
      0, 0,
      GetSystemMetrics( SM_CXSCREEN ),
      GetSystemMetrics( SM_CYSCREEN ),
      NULL,
      NULL,
      hInstance,
      NULL );

  if( !hwnd ) {
    error( "Cannot create window" );
  }

  ShowWindow( hwnd, cmdShow );
  UpdateWindow( hwnd );

  mainTid = (HANDLE)_beginthread( &demo_thread, 100*1024, cmdline );
  SetPriorityClass( GetCurrentProcess, HIGH_PRIORITY_CLASS );
//  SetThreadPriority( mainTid, THREAD_PRIORITY_HIGHEST );

  MSG msg;
  while( GetMessage(&msg, NULL, 0, 0) ) {
//    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return msg.wParam;
}

KB sysGetKey()
{
  KB tmp = last_key;
  last_key = KB_NONE;
  return tmp;
}
