/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "video.h"
#include "smooth.h"

extern "C" {

void _SmoothPage( PAGE from, PAGE to )
{
  int n = vidPageSize - vidBytesPerLine*2;
  int bpl = vidBytesPerLine;
  for( int i=0; i<n; i++ ) {
    to[i] = ( 0x001001 + from[i-1] + from[i+1] +
	      from[i-bpl] + from[i+bpl] ) >> 2;
  }
}

void _SmoothPageNorm( PAGE frompage, PAGE topage )
{
}

void _AlignPage( PAGE page, uchar step, uchar value )
{
  int n = vidPageSize;
  for( int i=0; i<n; i++ ) {
    if( page[i] < value ) {
      if( value-page[i] < step ) {
	page[i] = value;
      }
      else {
	page[i] += step;
      }
    }
    else {
      if( page[i]-value < step ) {
	page[i] = value;
      }
      else {
	page[i] -= step;
      }
    }
  }
}


void _AlignToPage( PAGE page, PAGE to, uchar step )
{
  int n = vidPageSize;
  for( int i=0; i<n; i++ ) {
    uchar value = to[i];
    if( page[i] < value ) {
      if( value-page[i] < step ) {
	page[i] = value;
      }
      else {
	page[i] += step;
      }
    }
    else {
      if( page[i]-value < step ) {
	page[i] = value;
      }
      else {
	page[i] -= step;
      }
    }
  }
}

}
