/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "video.h"
#include "smooth.h"

void SmoothPage( PAGE frompage, PAGE topage )
{
  memcpy( topage, frompage, vidBytesPerLine );
  memcpy( topage+vidPageSize-vidBytesPerLine,
	  frompage+vidPageSize-vidBytesPerLine,
	  vidBytesPerLine );
  _SmoothPage( frompage, topage );
}

void SmoothPageNorm( PAGE frompage, PAGE topage )
{
  memcpy( topage, frompage, vidBytesPerLine );
  memcpy( topage+vidPageSize-vidBytesPerLine,
	  frompage+vidPageSize-vidBytesPerLine,
	  vidBytesPerLine );
  _SmoothPageNorm( frompage, topage );
}

void AlignPage( PAGE page, uchar step, uchar value )
{
  _AlignPage( page, step, value );
}

void AlignToPage( PAGE frompage, PAGE topage, uchar step )
{
  _AlignToPage( frompage, topage, step );
}
