/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "parts.h"
#include "image.h"
#include "music.h"
#include "common.h"

const ANGLE_TIME = 6*sysTimerRes;

class Rotate: public Part {
  void Init();
  void Frame( PAGE color, PAGE bw, int what );

  Image* backpic;
};

void Rotate::Init()
{
  Part::Init();
  backpic = new Image( "back.raw" );
  int n = backpic->sizeY*backpic->bytesPerLine;
  for( i=0; i<n; i++ ) backpic->data[i] >>= 2;
}

void Rotate::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);

  if( what ) {
    vidCopyPage( bw, bcar1_bw->data );
  }

  int u[4] = { -backpic->sizeX/2, backpic->sizeX/2,
	       -backpic->sizeX/2, backpic->sizeX/2 };
  int v[4] = { -backpic->sizeY/2, -backpic->sizeY/2,
	       backpic->sizeY/2, backpic->sizeY/2 };
  for( i=0; i<4; i++ ) {
//    float scale = sin( timer*M_PI/musGetPatternTime())*0.7;
    float scale = 0.7;
    u[i] *= scale; v[i] *= scale;
    float angle = (float)timer/ANGLE_TIME*2*M_PI * (1-(part_count%2)*2);
    int uu = cos(angle)*u[i] + sin(angle)*v[i];
    uu = max(uu,-backpic->sizeX/2); uu = min(uu,backpic->sizeX/2-1);
    int vv = cos(angle)*v[i] - sin(angle)*u[i];
    vv = max(vv,-backpic->sizeY/2); vv = min(vv,backpic->sizeY/2-1);
    u[i] = uu+backpic->sizeX/2; v[i] = vv+backpic->sizeY/2;

  }
  static offset=0;
  backpic->MapToPage2( u[0], v[0], u[1], v[1], u[2], v[2], u[3], v[3],
		       bw+offset );
  offset = 1-offset;
}

Part* partRotate = new Rotate;
