/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "video.h"
#include "image.h"
#include "poly2d.h"
#include "parts.h"
#include "smooth.h"
#include "music.h"
#include "lines.h"
#include "common.h"

Image* pic;

class Points: public Part {
  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what );
  int u[4], v[4];

  Image *bcar1_1;
};

void Points::Init()
{
  Part::Init();
  bcar1_1 = new Image( "bcar1_1.raw", STRETCH_SCREEN );
}

void Points::Start( int what )
{
  u[0] = -vidSizeX/2; u[1] = vidSizeX/2-1;
  u[2] = -vidSizeX/2; u[3] = vidSizeX/2-1;
  v[0] = -vidSizeY/2; v[1] = -vidSizeY/2;
  v[2] = vidSizeY/2-1; v[3] = vidSizeY/2-1;
  if( what & 1 ) {
    ::dither = dither3;
  }
  else {
    ::dither = dither2;
  }
  if( what & 0x80 ) {
    static vidPalette pal;
    for( i=0; i<256; i++ ) {
      pal[i].r = 255-::dither->palette[i].r;
      pal[i].g = 255-::dither->palette[i].g;
      pal[i].b = 255-::dither->palette[i].b;
    }
    part_pal = pal;
  }
  else {
    part_pal = ::dither->palette;
  }
  vidClearPage( bw, VID_AVG_BRIGHT );
}

void Points::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);

  Image* pic;

  switch( what ) {

    case 0: {
      pic = bcar1;
      break;
    }

    case 3: {
      pic = bcar2;
      break;
    }

    case 4: {
      pic = bcar2;
      break;
    }

    case 1: {
      static old_row=-1, scale_timer = -1;
      if( row != old_row &&
	  (row == 2 || row == 6 || row == 9 || row == 11 || row == 14) ) {
	old_row = row;
	scale_timer = cur_timer;
      }
      float scale = 0.4+(cur_timer-scale_timer)/sysTimerRes;
      if( scale > 1 || old_row == -1 ) scale = 1;
      vidCopyPage( color, bcar1_1->data );
      bcar1_1->MapToPage2( u[0]*scale+vidSizeX/2,
			   v[0]*scale+vidSizeY/2,
			   u[1]*scale+vidSizeX/2,
			   v[1]*scale+vidSizeY/2,
			   u[2]*scale+vidSizeX/2,
			   v[2]*scale+vidSizeY/2,
			   u[3]*scale+vidSizeX/2,
			   v[3]*scale+vidSizeY/2,
			   color );
      break;
    }

    case 2: {
      if( row%24 > 11 )
	vidCopyPage( color, bcar1->data );
      else
	vidCopyPage( color, bcar1_1->data );
      return;
    }
  }
  if( what == 0 || what == 3 || what == 4 ) {
    if( what == 4 ) {
      vidCopyPage( color, pic->data );
    }
    static offset = 0;
    static int old_row=-1;
    if( row/6 != old_row && row > 18 ) {
      old_row = row/6;
      static coord = 0;
      coord = (coord+1) % 4;
      u[coord] *= 0.7; v[coord] *= 0.7;
    }
    pic->MapToPage2( u[0]+vidSizeX/2+rand()%(vidSizeX/80),
		       v[0]+vidSizeY/2+rand()%(vidSizeY/80),
		       u[1]+vidSizeX/2-rand()%(vidSizeX/80),
		       v[1]+vidSizeY/2+rand()%(vidSizeY/80),
		       u[2]+vidSizeX/2+rand()%(vidSizeX/80),
		       v[2]+vidSizeY/2-rand()%(vidSizeY/80),
		       u[3]+vidSizeX/2-rand()%(vidSizeX/80),
		       v[3]+vidSizeY/2-rand()%(vidSizeY/80),
		       color+offset );
    offset = 1-offset;
  }
}

Part* partPoints = new Points;
