/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __MUSIC__
#define __MUSIC__

#include "misc.h"
#include "mikmod/mikmod.h"

void musInitMusic(void);
UNIMOD* musLoadModule( char* name );
void musSetModule( uchar* );
void musFreeModule( uchar* gm );
void musStartMusic();
void musStopMusic();
SAMPLE* musLoadSample( char* name );
void musPlaySample( SAMPLE* s, uchar volume, uchar panning, int frequency );
void musFreeSample( SAMPLE* );
void musGetPosition( int* order, int* row=0 );
void musSetPosition( int order, int row=0 );
int musGetRowTime(); // the same resolution as sysTimer()
inline int musGetPatternTime() { return musGetRowTime()*64; }
void musSetVolume(int vol); //0..100
int musGetVolume();

// system dependent
// 05.09.97 - no more system dependent parts. all now defined in Makefile.

void musSystemInit();
void musChooseCard();
void musInitCard();
void musCloseMusic();

extern bool musInitialized, musPlaying, musNoSound;

#define SampleChannels 8

#endif
