/*

Name:
DRV_NOS.C

Description:
Mikmod driver for no output on any soundcard, monitor, keyboard, or whatever :)

       17.07.97 - but still playing module and
		  updating song info / Mad Max / QMG

Portability:
All systems - All compilers

*/

/* 
   uncomment one of the following lines to choose function used
   to get current time with subsecond presicion
*/

#define TIMES
/* #define FTIME */
/* #define GETTIMEOFDAY */

#include <stdio.h>
#include <time.h>
#include "mikmod.h"
#ifdef __DJGPP__
  #include <sys/nearptr.h>
#endif

#define TIMER_RES	1000	
#define FOOBUFFERSIZE	1024
static signed char FOO_DMABUF[FOOBUFFERSIZE];
int buf_time = 0;

#ifdef __WATCOMC__

#ifdef W32
#include <windows.h>
#endif

unsigned get_current_time()
{
#ifdef DOS
  return *(unsigned*)(0x46C)*55*TIMER_RES/1000;
#elif defined(W32)
  return GetTickCount()*TIMER_RES/1000;
#else
  return clock()*TIMER_RES/CLOCKS_PER_SEC;
#endif
}

#elif __DJGPP__
unsigned get_current_time()
{
  return *(unsigned*)(0x46C+__djgpp_conventional_base)*55*TIMER_RES/1000;
}

#elif defined(TIMES)
#include <sys/times.h>
unsigned get_current_time()
{
  struct tms foo;
  return times( &foo )*TIMER_RES/CLK_TCK;
}
#elif defined(FTIME)
#include <sys/timeb.h>
unsigned get_current_time()
{
  struct timeb tb;
  ftime(&tb);
  return (tb.time*TIMER_RES + (unsigned)tb.millitm*TIMER_RES/1000);
}
#elif defined(GETTIMEOFDAY)
#include <sys/time.h>
#include <unistd.h>
unsigned get_current_time()
{
  struct timeval tv;
  gettimeofday( &tv, 0 );
  return tv.tv_sec*TIMER_RES + tv.tv_usec*TIMER_RES/1000000;
}
#endif

BOOL NS_IsThere(void)
{
  return 1;
}

BOOL NS_Init()
{
  VC_Init();
  md_mixfreq = FOOBUFFERSIZE*10; /* precision of 10 updates per second
				    ought to be enough for everybody ;-) */
  md_mode &= ~(DMODE_16BITS | DMODE_STEREO);
  buf_time = TIMER_RES * FOOBUFFERSIZE / md_mixfreq;
  return 1;
}

void NS_Update(void)
{
  static unsigned prev_time = 0;
  unsigned cur_time = get_current_time();
  md_mode &= ~(DMODE_16BITS | DMODE_STEREO);
  if( !prev_time ) prev_time = cur_time;
  while( cur_time - prev_time > buf_time ) {
    VC_WriteBytes(FOO_DMABUF,FOOBUFFERSIZE);
    prev_time += buf_time;
  }
}

DRIVER drv_nos = {
	NULL,
	"No Sound",
	"MikMod Nosound Driver v4.1 - (c) Creative Silence & Mad Max / QMG",
	NS_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	NS_Init,
	VC_Exit,
	VC_PlayStart,
	VC_PlayStop,
	NS_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay
};
