/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "lines.h"

void DrawLinePix( PAGE page, int x1, int y1, int x2, int y2, uchar color )
{
  if( x1==x2 && y1==y2 ) {
    if( x1>=0 && x1<vidSizeX && y1>=0 && y1<vidSizeY )
      page[ y1*vidBytesPerLine+x1 ] = color;
  }
  else {
    if( abs(x1-x2) > abs(y1-y2) ) {
      int y=y1<<16, stepy=((y2-y1)<<16)/abs(x2-x1);
      int stepx=(x2-x1)/abs(x2-x1);
      for( int x=x1; x!=x2; x+=stepx,y+=stepy ) {
	if( x>=0 && x<vidSizeX && y>=0 && (y>>16)<vidSizeY )
	  page[ (y>>16)*vidBytesPerLine+x ] = color;
      }
    }
    else {
      int x=x1<<16, stepx=((x2-x1)<<16)/abs(y2-y1);
      int stepy=(y2-y1)/abs(y2-y1);
      for( int y=y1; y!=y2; x+=stepx,y+=stepy ) {
	if( x>=0 && (x>>16)<vidSizeX && y>=0 && y<vidSizeY )
	  page[ y*vidBytesPerLine+(x>>16) ] = color;
      }
    }
  }
}

void DrawLinePicAdd( PAGE page, int x1, int y1, int x2, int y2, Image* p )
{
  if( abs(x1-x2) > abs(y1-y2) ) {
    for( int i=x1; i!=x2; i+=(x2-x1)/abs(x2-x1) ) {
      p->ShowAdd( i-p->sizeX/2,
		  (y1+(y2-y1)*(i-x1)/(x2-x1))-p->sizeY/2, page );
    }
  }
  else {
    for( int i=y1; i!=y2; i+=(y2-y1)/abs(y2-y1) ) {
//	page[ (x1+(x2-x1)*(i-y1)/(y2-y1))+i*vidBytesPerLine ] = color;
      p->ShowAdd( (x1+(x2-x1)*(i-y1)/(y2-y1))-p->sizeX/2,
		      i-p->sizeY/2, page );
    }
  }
}
