/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "parts.h"
#include "sys.h"
#include "lines.h"
#include "smooth.h"
#include "image.h"

const MIN_LINE_LIFE = 2*sysTimerRes,
      MAX_LINE_LIFE = 4*sysTimerRes,
      MAX_LINES = 300;

class DLines: public Part {

  void Frame( PAGE color, PAGE bw, int what );

  struct line {
    int start, life;
    float angle, angle_step;
    int length;
    bool dead;
    int color;

    line( int timer, int c = VID_AVG_BRIGHT )
    {
      start = timer;
      life = MIN_LINE_LIFE+rand()%MAX_LINE_LIFE;
      int foo = max(vidSizeX/4,vidSizeY/4);
      length = foo + rand()%foo;
      angle = float(rand()%1000) / 1000 * M_PI*2;
      angle_step = float(rand()%1000) / 1000 * M_PI/200;
      dead = false;
      color = c;
    }
    void draw( PAGE page, int timer, int xc, int yc )
    {
      if( timer-start > life ) {
	dead = true;
	return;
      }
      int l;
      if( timer-start < life/2 )
	l = length*(timer-start)/(life/2);
      else
	l = length-length*(timer-start-life/2)/(life/2);
      DrawLinePix( page, xc, yc,
		   xc+cos(angle+l*angle_step)*l,
		   yc+sin(angle+l*angle_step)*l, color );
    }
  };
  TCollection<line> lines;
};

void DLines::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);
  if( what ) {
    if( lines.Count < MAX_LINES*2 ) {
      lines.Insert( new line(timer, rand()%VID_MAX_BRIGHT ) );
    }
  }
  else {
    if( lines.Count < MAX_LINES ) {
      lines.Insert( new line(timer) );
    }
  }
  static int xc, yc, old_row=-1;
  if( what ) {
    switch( what ) {
      case 1: {
	if( row/6 != old_row ) {
	  old_row = row/6;
	  xc = vidSizeX/2 + vidSizeX/4 - rand()%(vidSizeX/2);
	  yc = vidSizeY/2 + vidSizeY/4 - rand()%(vidSizeY/2);
	}
	break;
      }
      case 2: {
	if( row != old_row &&
	    (row == 2 || /*row == 4 ||*/ row == 8 /*|| row == 12*/) ) {
	  xc = vidSizeX/2 + vidSizeX/4 - rand()%(vidSizeX/2);
	  yc = vidSizeY/2 + vidSizeY/4 - rand()%(vidSizeY/2);
	  old_row = row;
	}
	break;
      }
    }
  }
  for( i=0; i<lines.Count; i++ ) {
    if( !lines[i] ) continue;
    if( what ) {
      lines[i]->draw( bw, timer, xc, yc );
    }
    else {
      lines[i]->draw( bw, timer, vidSizeX/2, vidSizeY/2 );
    }
    if( lines[i]->dead ) {
      lines.Free(i);
    }
  }
  lines.Pack();
  SmoothPage( bw, bw );
  memset( bw, 0, vidBytesPerLine );
  memset( bw+(vidSizeY-1)*vidBytesPerLine, 0, vidBytesPerLine );
}

Part* partDLines = new DLines;
