/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "video.h"

extern "C" {
void vidDitherPage( PAGE colorpage, PAGE bwpage, PAGE topage,
		    uchar* dithertable )
#pragma aux vidDitherPage parm [eax] [ebx] [esi] [edi] modify [ecx edx];
{
  int n = vidPageSize;
  for( int i=0; i<n; i+=4 ) {
    topage[i] = dithertable[   (bwpage[i]<<8)	+ colorpage[i] ];
    topage[i+1] = dithertable[ (bwpage[i+1]<<8) + colorpage[i+1] ];
    topage[i+2] = dithertable[ (bwpage[i+2]<<8) + colorpage[i+2] ];
    topage[i+3] = dithertable[ (bwpage[i+3]<<8) + colorpage[i+3] ];
  }
}

}
