/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "3d.h"
#include "image.h"
#include "music.h"
#include "sys.h"
#include "lines.h"
#include "smooth.h"
#include "parts.h"
#include "common.h"

struct Cars: Part {
  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what=0 );

  TCollection<FacedObject> car_phases;
  FacedObject* car;
};

static PAGE bw_;
static int line_color;

static bool callback( Face* face )
{
  DrawLinePix( bw_, face->vert[0]->x>>16, face->vert[0]->y,
	       face->vert[1]->x>>16, face->vert[1]->y, line_color );
  DrawLinePix( bw_, face->vert[1]->x>>16, face->vert[1]->y,
	       face->vert[2]->x>>16, face->vert[2]->y, line_color );
  DrawLinePix( bw_, face->vert[2]->x>>16, face->vert[2]->y,
	       face->vert[0]->x>>16, face->vert[0]->y, line_color );
  return false;
}

void Cars::Init()
{
  Part::Init();
  Image texture( "oldmeta1.raw" );
  for( int i='1'; i<='3'; i++ ) {
    char name[] = "hotrod?.asc";
    name[6] = i;
    FacedObject* phase = new FacedObject( PHONG | SORT |/*ZBUFFER |*/ TWO_SIDES );
    phase->ImportASC( name, 0, VID_MAX_SIZE_Y*1, &texture, MAP_XZ );
    phase->Prepare();
    car_phases.Insert(phase);
  }
  car = new FacedObject(*car_phases[0]);
}

void Cars::Start( int what )
{
  Part::Start();
  if( what & 1 ) {
    ::dither = dither3;
  }
  else {
    ::dither = dither2;
  }
  if( what & 0x80 ) {
    static vidPalette pal;
    for( i=0; i<256; i++ ) {
      pal[i].r = 255-::dither->palette[i].r;
      pal[i].g = 255-::dither->palette[i].g;
      pal[i].b = 255-::dither->palette[i].b;
    }
    part_pal = pal;
  }
  else {
    part_pal = ::dither->palette;
  }
}

void Cars::Frame( PAGE color, PAGE b, int what )
{
  Part::Frame(color,bw);

  bw_ = b;

  Image *back, *back_bw;

  if( what & 0x80 ) {
    back = bcar2;
    back_bw = bcar2_bw;
  }
  else {
    back = bcar1;
    back_bw = bcar1_bw;
  }
  what &= 0xF;

  static old_order = -1, next_row = 5, scale_timer = 0;
  static bool scale_flag = false;
  if( old_order != order ) {
    old_order = order;
    next_row = 8;
  }
  if( row >= next_row ) {
    next_row += 6;
    scale_timer = timer;
    scale_flag = !scale_flag;
  }

  static offset = 0;

  float scale = 1;

  switch(what) {
    case 0: {
      car->setFaceCallback(0);
      car->flags &= ~NO_TEXTURE;
      vidSizeY /= 2; vidBytesPerLine *= 2;
      vidClearPage( color+offset, 109-32 );
      vidCopyPage( bw+offset, back_bw->data+offset );
      if( row < 7 ) {
	scale = 0.7+cur_timer*1.0/(musGetRowTime()*7);
      }
      else if( row < 16 ) {
	scale = 1.7-(cur_timer-musGetRowTime()*7)*0.7/(musGetRowTime()*9);
      }
      else if( row < 24 ) {
	scale = 1;
      }
      else {
	scale = 1.5 - 1.5 * ( (cur_timer-musGetRowTime()*24) %
			      (musGetRowTime()*16)) /
			    (musGetRowTime()*16);
	if( scale < 1 ) scale = 1;
      }
      break;
    }
    case 4: {
      car->setFaceCallback(0);
      car->flags &= ~NO_TEXTURE;
      vidSizeY /= 2; vidBytesPerLine *= 2;
      vidClearPage( color+offset, 109-32 );
      vidCopyPage( bw+offset, back_bw->data+offset );
      scale = 1 + 0.4*(cur_timer % (musGetRowTime()*8)) /
		      (musGetRowTime()*8);
      break;
    }
    case 1: {
      car->setFaceCallback(0);
      car->flags |= NO_TEXTURE;
      vidCopyPage( color, back->data );
      vidClearPage( bw, VID_AVG_BRIGHT );
      scale = 1.3 - (timer-scale_timer)*0.7/sysTimerRes;
      if( scale < 0.8 ) scale = 0.8;
      break;
    }
    case 2: {
      car->setFaceCallback(&callback);
      line_color = 0;
      car->flags |= NO_TEXTURE;
      vidCopyPage( color, back->data );
      vidClearPage( bw, VID_AVG_BRIGHT );
      scale = 1.3 - (timer-scale_timer)*0.7/sysTimerRes;
      if( scale < 0.8 ) scale = 0.8;
      break;
    }
    case 5: {
      car->setFaceCallback(&callback);
      line_color = 0;
      car->flags |= NO_TEXTURE;
      vidCopyPage( color, back->data );
      scale = 1.3 - (timer-scale_timer)*0.7/sysTimerRes;
      if( scale < 0.8 ) scale = 0.8;
      break;
    }
    case 3: {
      car->setFaceCallback(&callback);
      line_color = VID_MAX_BRIGHT-1;
      car->flags |= NO_TEXTURE;
      vidClearPage( color, 109-32 );
      vidCopyPage( bw, back_bw->data );
      scale = 1.3 - (timer-scale_timer)*0.7/sysTimerRes;
      if( scale < 0.8 ) scale = 0.8;
      break;
    }
  }

  if( car->flags & NO_TEXTURE ) {
    offset = 0;
  }

  int steps = musGetRowTime()*48,
      step = timer % steps,
      n1 = (timer / steps) % car_phases.Count,
      n2 = (n1+1) % car_phases.Count;
  if( steps < 0 || timer < 0 ) error( "shit" );
  car->Morph( *car_phases[n1], *car_phases[n2], step, steps );

  car->RotateTo( timer*COS_STEPS_3D*0.05/sysTimerRes,
		 timer*COS_STEPS_3D*0.1/sysTimerRes, 0 );

  car->ScaleTo( scale, scale, scale );

  if( !(car->flags & SORT) && what != 2 && what != 3 )
    Object3D::ClearZBuffer( zbuffer+offset, MIN_Z );

  car->Draw( zbuffer+offset, color+offset, bw+offset );
//  car->Draw( zbuffer, color, bw);

  if( !(car->flags & NO_TEXTURE) ) {
    vidSizeY *= 2; vidBytesPerLine /= 2;
    offset = vidBytesPerLine - offset;
  }
  if( what > 1 ) {
    SmoothPage(bw,bw);
  }
}

Part* partCars = new Cars;
