/* ibitstr.cpp

	Input bitstream class implementation



 */

#ifdef  __WIN32__
#include <windows.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#endif   // __WIN32__

#ifndef GUI
#include <iostream.h>
#endif // GUI

#include "all.h"
#include "ibitstr.h"
#include "header.h"
#include "MPEx.h"

#ifdef  DAMN_INTEL_BYTE_ORDER
#define swap_int32(int_32) (((int_32) << 24) | (((int_32) << 8) & 0x00ff0000) | \
				               (((int_32) >> 8) & 0x0000ff00) | ((int_32) >> 24))
#endif

int ResultError;

Ibitstream::Ibitstream(ResCreateStream CSProc,
                       ResCloseStream ClSProc,
                       ResRestartStream RSSProc,
                       ResReadStream RSProc,
                       ResSetPointer RSPProc,
                       ResGetSize RGSProc,
                       void* object)
{
  from_res = true;
  ResCreateStream CSProcVar = CSProc;
  playerobj  = object;
  ClSProcVar = ClSProc;
  RSSProcVar = RSSProc;
  RSProcVar  = RSProc;
  RSPProcVar = RSPProc;
  RGSProcVar = RGSProc;
  CSProcVar(playerobj, &nonseekable,&stream_handle);
  if (stream_handle == NULL)
  {
   ResultError = mpStreamError;
   throw TMPEGError("Stream error");
  }
  wordpointer       = buffer;
  bitindex          = 0;
  // Seeking variables
  current_frame_number = -1;
  last_frame_number    = -1;
}

Ibitstream::Ibitstream(const char *filename)
{

  SECURITY_ATTRIBUTES security;
  security.nLength              = sizeof(SECURITY_ATTRIBUTES);
  security.lpSecurityDescriptor = NULL;
  security.bInheritHandle       = FALSE;

  FH = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ,
                  &security, OPEN_EXISTING, NULL, NULL);

  if (FH == INVALID_HANDLE_VALUE) {
    ResultError = mpStreamError;
   throw TMPEGError("Stream error");
  }
  from_res = false;
  wordpointer       = buffer;
  bitindex          = 0;

  // Seeking variables
  current_frame_number = -1;

  last_frame_number    = -1;
  nonseekable = false;
}

Ibitstream::~Ibitstream()
{
  // close the file
  if (!from_res) {CloseHandle(FH);}
      else {ClSProcVar(playerobj, stream_handle);}
}

bool Ibitstream::restart()
{
   DWORD res;
   bool res1;
   if (from_res) {
      RSSProcVar(playerobj, stream_handle, &res1);
      if (!res1) {ResultError = mpStreamError;}
   } else
   {
  	  res = SetFilePointer(FH, 0, NULL, FILE_BEGIN);
     if (res == 0xFFFFFFFF) {ResultError = mpStreamError;}
     res1 = res!= 0xFFFFFFFF;
   }
   if (!res1) {return(false);}
   wordpointer       = buffer;
   bitindex          = 0;

  // Seeking variables
   current_frame_number = -1;

   last_frame_number    = -1;
   return(true);
}

bool Ibitstream::get_header (uint32 *headerstring, enum e_syncmode syncmode)
{
  bool result, sync;
  DWORD res;
  int32 numread;

  do {

	// Read 4 bytes from the file, placing the number of bytes actually
   // read in numread
   if (!from_res) {
     result = (bool) ReadFile(FH, (char *) headerstring, 4,
     							    (DWORD *) &numread, NULL);

     if (!(result && (numread == 4)))
     {
       ResultError = mpStreamError;
       return(FALSE);}
   } else
   {
     RSProcVar(playerobj, stream_handle, (char *) headerstring, 4,
     							    (DWORD *) &numread, &result);
     if (!(result && (numread == 4)))
     { ResultError = mpStreamError;
       return(FALSE); 
     }
   }
	if (syncmode == INITIAL_SYNC) {
	   sync =  ((*headerstring & 0x0000F0FF) == 0x0000F0FF);
   } else {
   	sync =  ((*headerstring & 0x000CF8FF) == syncword) &&
             (((*headerstring & 0xC0000000) == 0xC0000000) == single_ch_mode);
   }
   if ((*headerstring & 0x0000FFFF) == 0x0000FFFF) {sync = false;}
   if (!sync)
 	// rewind 3 bytes in the file so we can try to sync again, if
   // successful set result to TRUE
#ifdef __WIN32__
   if (from_res) {
      RSPProcVar(playerobj , stream_handle, -3, FILE_CURRENT,&res);
      result = (bool) res;
   } else
   {
      result = (bool) SetFilePointer(FH, -3, NULL, FILE_CURRENT);
   }
#else
		result = (bool) (lseek(fd, -3, SEEK_CUR) != -1);
#endif // __WIN32__

  } while (!sync && result);

  if (!result)
  {  ResultError = mpStreamError;
     return(FALSE);
  }

#ifdef DAMN_INTEL_BYTE_ORDER
  uint32 header = *headerstring;
  *headerstring = swap_int32(header);
#endif // DAMN_INTEL_BYTE_ORDER

  current_frame_number++;

#ifdef SEEK_STOP
  if (last_frame_number < current_frame_number)
	  last_frame_number = current_frame_number;
#endif

  return(TRUE);
}

int32 Ibitstream::last_frame()
{
   return(last_frame_number);
}

bool Ibitstream::read_frame(uint32 bytesize)
{

  int32 numread;
  bool result;

  // read bytesize bytes from the file, placing the number of bytes
  // actually read in numread and setting result to TRUE if
  // successful
#ifdef __WIN32__
  if (from_res) {
    RSProcVar(playerobj, stream_handle, buffer, bytesize, (DWORD *) &numread, &result);
  } else
  {
    result = ReadFile(FH, buffer, bytesize, (DWORD *) &numread, NULL);
  }
#else
  result = (bool) ((numread=read(fd,buffer,bytesize)) != -1);
#endif // __WIN32__


/*  if (bytesize > (bufferintsize << 2))
  {
	 cerr << "Internal error: framelength > bufferlength?!\n";
	 exit (1);
  } */

  wordpointer = buffer;
  bitindex    = 0;
  framesize   = bytesize;

#ifdef DAMN_INTEL_BYTE_ORDER
  uint32 *wordp;
  for (wordp = buffer + ((bytesize - 1) >> 2); wordp >= buffer; --wordp)
  {

#ifdef INTEL386

  // inline 386 assembly doesn't work on Borland compiler

  __asm {
      mov eax, wordp
		mov ebx, [eax]
      bswap ebx
      mov [eax], ebx
  }

#else

	 uint32 word   = *wordp;
    *wordp = swap_int32(word);

#endif // INTEL386

  } // for (wordp ...

#endif // DAMN_INTEL_BYTE_ORDER
  if (!(bool) (result && (numread == framesize))) {
     ResultError = mpStreamError;
  }
  return((bool) (result && (numread == framesize)));
}

uint32 Ibitstream::get_bits(uint32 number_of_bits)
{
  static uint32 bitmask[18] =
  {
	 0,	// dummy
	 0x00000001, 0x00000003, 0x00000007, 0x0000000F,
	 0x0000001F, 0x0000003F, 0x0000007F, 0x000000FF,
	 0x000001FF, 0x000003FF, 0x000007FF, 0x00000FFF,
	 0x00001FFF, 0x00003FFF, 0x00007FFF, 0x0000FFFF,
    0x0001FFFF
  };
  uint32 returnvalue;
  uint32 sum = bitindex + number_of_bits;

  if (sum <= 32)
  {
	 // all bits contained in *wordpointer
	 returnvalue = (*wordpointer >> (32 - sum)) & bitmask[number_of_bits];
	 if ((bitindex += number_of_bits) == 32)
	 {
		bitindex = 0;

/*		if ((char *)++wordpointer > (char *)buffer + framesize)
		{
	cerr << "Ibitstream::get_bits(): no more bits in buffer!\n";
	exit (1);
		} */
		wordpointer++; // added by me!
	 }
	 return(returnvalue);
  }

#ifdef DAMN_INTEL_BYTE_ORDER
  *((int16 *)&returnvalue + 1) = *(int16 *)wordpointer;
  wordpointer++; // Added by me!
  *(int16 *)&returnvalue = *((int16 *)wordpointer + 1);
#else
  *(int16 *)&returnvalue = *((int16 *)wordpointer + 1);
  wordpointer++; // Added by me!
  *((int16 *)&returnvalue + 1) = *(int16 *)wordpointer;
#endif // DAMN_INTEL_BYTE_ORDER

  returnvalue >>= 48 - sum;	// returnvalue >>= 16 - (number_of_bits - (32 - bitindex))
  returnvalue &= bitmask[number_of_bits];
  bitindex = sum - 32;

  return(returnvalue);
}

void Ibitstream::set_syncword(uint32 syncword0)
{

#ifdef DAMN_INTEL_BYTE_ORDER
   syncword = swap_int32(syncword0 & 0xFFFFFF3F);
#else
	syncword = syncword0 & 0xFFFFFF3F;
#endif // DAMN_INTEL_BYTE_ORDER

   single_ch_mode = ((syncword0 & 0x000000C0) == 0x000000C0);
}

uint32 Ibitstream::file_size()
// return the file size of the file
{
   DWORD res;
   if (from_res)
   {
      RGSProcVar(playerobj, stream_handle, &res);
      if (res == 0xFFFFFFFF) {ResultError = mpStreamError;} 
      return(res);
   }
   else { 
          res = GetFileSize(FH, NULL);
          if (res == 0xFFFFFFFF) {ResultError = mpStreamError;} 
          return(res);
        }
}

bool Ibitstream::seek(int32 frame, int32 frame_size)
// set the file pointer to frame * (frame_size + 4) bytes after the
// beginning of the file and return TRUE if successful
{
   DWORD res;
	current_frame_number = frame - 1;
   if (nonseekable) {
     ResultError = mpIsNonseekable;
     return(false);
   }
   if (from_res) {
      RSPProcVar(playerobj, stream_handle, frame * (frame_size + 4), FILE_BEGIN, &res);
      if (res == 0xFFFFFFFF) {ResultError = mpStreamError;}
      return(res!= 0xFFFFFFFF);
   } else
   {
  	  res = SetFilePointer(FH, frame * (frame_size + 4), NULL, FILE_BEGIN);
     if (res == 0xFFFFFFFF) {ResultError = mpStreamError;}
     return(res!= 0xFFFFFFFF);
   }
}

bool Ibitstream::seek_pad(int32 frame, int32 base_frame_size,
                          Header *header, uint32 *offset)
{
	// base_frame_size is the frame size _without_ padding.
   if (nonseekable) {
      ResultError = mpIsNonseekable;
      return(false);
   }
   Crc16 *crc = NULL;

   int32 total_frame_size = base_frame_size + 4;
   int32 diff;
   DWORD res;

   if (last_frame_number < frame) {
      diff = (last_frame_number >= 0) ?  offset[last_frame_number] : 0;

     // set the file pointer to ((last_frame_number+1) * total_frame_size)
     // bytes after the beginning of the file
     if (from_res) {
        RSPProcVar(playerobj, stream_handle, (last_frame_number + 1) * total_frame_size +
                 diff, FILE_BEGIN, &res);
     } else
     {
       SetFilePointer(FH, (last_frame_number + 1) * total_frame_size +
                      diff, NULL, FILE_BEGIN);
     }

     current_frame_number = last_frame_number;
   
     do {
      if (!header->read_header(this, &crc)) // will increment last_frame_number
      {
        ResultError = mpStreamError;
        return(FALSE);
      }
     } while (last_frame_number < frame);

     return(TRUE);

   } else {
     diff = (frame > 0) ? offset[frame - 1] : 0;

     // set the file pointer to (frame * total_frame_size  + diff) bytes
     // after the beginning of the file
     if (from_res) {
        RSPProcVar(playerobj, stream_handle, frame * total_frame_size + diff, FILE_BEGIN,&res);
     } else
     {
       SetFilePointer(FH, frame * total_frame_size + diff, NULL, FILE_BEGIN);
     }
     current_frame_number = frame - 1;
     return(header->read_header(this, &crc));
   }
}
         