/* obuffer.h

   Declarations for output buffer, includes operating system
   implementation of the virtual Obuffer. Optional routines
   enabling seeks and stops add by Jeff Tsay. */

#ifndef OBUFFER_H
#define OBUFFER_H

#include "all.h"
#include <stdio.h> // needed for definition of NULL
#include "args.h"

static const uint32 OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
static const uint32 MAXCHANNELS = 2;		// max. number of channels

// Abstract base class for audio output classes:
class Obuffer
{
public:

  virtual     ~Obuffer() {}		// dummy

  virtual void append(uint32 channel, int16 value) = 0;
			 // this function takes a 16 Bit PCM sample
  virtual void write_buffer(int32 fd) = 0;
			 // this function should write the samples to the filedescriptor
			 // or directly to the audio hardware

#ifdef SEEK_STOP
  virtual void clear_buffer() = 0;
			 // Clears all data in the buffer (for seeking)

  virtual void set_stop_flag() = 0;
			 // Notify the buffer that the user has stopped the stream
#endif // SEEK_STOP

};

Obuffer *create_obuffer(MPEG_Args *maplay_args);

#include "fileobuf.h"

#ifdef __WIN32__
#include "mci_obuf.h"
#include "wavefile_obuffer.h"
#endif

#endif // OBUFFER_H
