//---------------------------------------------------------------------------
#pragma hdrstop
#include <string.h>

#include "all.h"
#include "crc.h"
#include "header.h"
#include "subband.h"
#include "sublay1.h"
#include "sublay2.h"
#include "synfilt.h"
#include "ibitstr.h"
#include "obuffer.h"
#include "args.h"
#include "layer3.h"
#include <winbase.h>
#include <classlib/thread.h>
#include <winsys/wsysinc.h>
#include "maplay.h"
#include "MPex.h"

MPEG_Args *ma = NULL;
char Stream_Name[512] = "";
HWAVEOUT hwo;
volatile uint32 musicsize = -1;


extern bool* StopHook;
extern int ResultError;

extern uint32 startplay(MPEG_Args *);

extern uint32 layer;
extern Header *header;
extern Crc16 *crc;
extern Ibitstream *stream;
extern enum e_channels which_channels;
extern enum e_mode mode;
extern bool read_ready, write_ready;
extern HANDLE PauseSemaphore;
extern SynthesisFilter *filter1, *filter2;
extern Obuffer *buffer;
extern LayerIII_Decoder *l3decoder;

extern TPlayThread *player;

extern "C" bool _export _stdcall __declspec(dllexport) init()
{
  ResultError = mpSuccess;
  if (ma !=NULL) {
    ResultError = mpIncorrectMode;
    return(false);
  }
  try {
    ma = new MPEG_Args;
  }
  catch (...) {
    ResultError = mpInternalError;
    return(false);
  }
  ma->phwo 		= &hwo;
  ma->musicpos = -1;
  ma->playmode = 0;
  ma->DevNum = 0;
  ma->output_mode = O_WAVEMAPPER;
  lstrcpy(ma->output_filename, "");
  musicsize = -1;
  return (true);
}

extern "C" bool _export _stdcall __declspec(dllexport) UseScaleFactor (bool usescale, float factor) {
   ResultError = mpSuccess;
   if (ma == NULL) {
      ResultError = mpIncorrectMode;
      return(false);
   }
   ma->use_own_scalefactor = usescale;
   if (usescale) {
      ma->scalefactor = factor;
   }
   return(true);
}

extern "C" bool _export _stdcall __declspec(dllexport) SetSndDevice (int Num){
   ResultError = mpSuccess;
   if (ma == NULL) {
     ResultError = mpIncorrectMode;
     return(false);
   }
   int NumDevs=waveOutGetNumDevs();
   if (Num>(NumDevs-1)) {
      ResultError = mpNoOutput;
      return(false);
   }
   ma->DevNum = Num;
   return(true);
}

extern "C" bool _export _stdcall __declspec(dllexport) SetOutputDevice (int mode, char* outputname){
// 0 - wavemapper, 1 - directsound, 2- wavefile
   ResultError = mpSuccess;
   if (ma == NULL) {
     ResultError = mpIncorrectMode;
     return(false);
   }
   switch (mode) {
     case 0: ma->output_mode = O_WAVEMAPPER;
             break;
     case 1: ma->output_mode = O_DIRECTSOUND;
             break;
     case 2: ma->output_mode = O_WAVEFILE;
             strcpy(ma->output_filename, outputname);
  	     break;
   }
   return(true);
}

extern "C" int _export _stdcall __declspec(dllexport) LastError()
{
  int res;
  res = ResultError;
  ResultError = 0;
  return(res);
}

extern "C" int32 _export _stdcall __declspec(dllexport) GetCurrentPos()
{
   ResultError = mpSuccess;
   if (ma == NULL) {
      ResultError = mpIncorrectMode;
      return(-1);
   }
   return(ma->musicpos*ma->MPEGheader->ms_per_frame());
}

extern "C" int32 _export _stdcall __declspec(dllexport) GetLength()
{
  return(musicsize);
}

extern "C" e_mode _export _stdcall __declspec(dllexport) GetStereoMode()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(-1);
  } else { return(ma->MPEGheader->mode()); }
}

extern "C" uint32 _export _stdcall __declspec(dllexport) GetLayer()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(-1);
  } else {  return(ma->MPEGheader->layer()); }
}

extern "C" uint32 _export _stdcall __declspec(dllexport) GetBitrate()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(-1);
  }
  return(ma->MPEGheader->bitrate());
}

extern "C" uint32 _export _stdcall __declspec(dllexport) GetFrequency()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(-1);
  }
  return(ma->MPEGheader->frequency());
}

extern "C" bool _export _stdcall __declspec(dllexport) Seekable()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(false);
  }
  return(!ma->nonseekable);
}

extern "C" void _export _stdcall __declspec(dllexport) ResetPlayerMode()
{
   ResultError = mpSuccess;
   if (ma == NULL) {
     ResultError = mpIncorrectMode;
     return;
   } else {
       if (ma->playmode == 2) {
           ma->playmode = 1;
           *StopHook = false;
       }
     }
}

extern "C" int32 _export _stdcall __declspec(dllexport) GetPlayerMode()
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(-1);
  } else {
        return(ma->playmode);
     }
}

/*

enum TPriority {
   Idle         = THREAD_PRIORITY_IDLE,
   Lowest       = THREAD_PRIORITY_LOWEST,
   BelowNormal  = THREAD_PRIORITY_BELOW_NORMAL,
   Normal       = THREAD_PRIORITY_NORMAL,
   AboveNormal  = THREAD_PRIORITY_ABOVE_NORMAL,
   Highest      = THREAD_PRIORITY_HIGHEST,
   TimeCritical = THREAD_PRIORITY_TIME_CRITICAL,
};

*/
extern "C" bool _export _stdcall __declspec(dllexport) SetPriority(TThread::TPriority value)
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(false);
  }
  ma->playpriority = value;
  if (ma->playmode == 3 || ma->playmode == 4) {
     player->SetPriority(value);
  }
  return(true);
}

/* extern "C" bool _export _stdcall __declspec(dllexport) GetPriority(TThread::TPriority* value)
{
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return(false);
  }
  *value =  ma->playpriority;
  return(true);
}  */

extern "C" bool _export _stdcall __declspec(dllexport) Seek(uint32 pos)
{
  ResultError = mpSuccess;
  if (ma == NULL) {
    ResultError = mpIncorrectMode;
    return (false);
  }
  if (ma->nonseekable) {
    ResultError = mpIsNonseekable;
    return (false);
  }
  if (ma->playmode == 3 || ma->playmode == 4) {
     if (pos > musicsize) {
        return(false);
     }
     ma->position_change = true;
     ma->desired_position = pos/ma->MPEGheader->ms_per_frame();
  } else {
      ResultError = mpIncorrectMode;
      return(false);
    }
  return (true);
}

extern "C" bool _export _stdcall __declspec(dllexport) Open(char *Name, bool from_res,
                                                       ResCreateStream CSProc,
                                                       ResCloseStream ClSProc,
                                                       ResRestartStream RSSProc,
                                                       ResReadStream RSProc,
                                                       ResSetPointer RSPProc,
                                                       ResGetSize RGSProc,
                                                       void* object)
{
  ResultError = mpSuccess;
  try
  {
    Crc16 *crc = NULL;
    if (ma ==NULL || ma->playmode >1){
      ResultError = mpIncorrectMode;
      return(false);
    }
    if (from_res) {
      ma->stream = new Ibitstream(CSProc,
                                  ClSProc,
                                  RSSProc,
                                  RSProc,
                                  RSPProc,
                                  RGSProc,
                                  object);
    } else {
      if (Name==NULL) {
        ResultError = mpStreamError;
        return(false);
      }
      strcpy(Stream_Name, Name);
      ma->stream = new Ibitstream(Stream_Name);		// read from file
    }
    ma->MPEGheader = new Header;
  }
  catch (...) {
    if (ResultError == 0) { ResultError = mpInternalError; }
    return(false);
  }
  ma->nonseekable = ma->stream->nonseekable;
  if (!ma->MPEGheader->read_header(ma->stream, &crc)) {
    ResultError = mpStreamError;
    return(false);
  }
  ma->playmode = 1;
  musicsize = ma->MPEGheader->total_ms(ma->stream);
  ma->endpos = musicsize;
  ma->startpos = 0;
  return(true);
}

extern "C" int _export _stdcall __declspec(dllexport) Play(uint32 startpos, uint32 endpos , bool* PlayStopped)
{
   ResultError = mpSuccess;
   if (ma==NULL || ma->playmode >2) {
      ResultError = mpIncorrectMode;
      return(0);
   }
   StopHook = PlayStopped;
   ma->stop = false;
   *StopHook = false;
   if (startpos >0 && startpos<endpos && startpos < musicsize) {
      ma->startpos = startpos/ma->MPEGheader->ms_per_frame();
   }
   if (endpos <=musicsize ) {
      ma->endpos = endpos/ma->MPEGheader->ms_per_frame();
   } else {ma->endpos = musicsize/ma->MPEGheader->ms_per_frame();}
   if (endpos == 0) {
      ma->endpos = musicsize/ma->MPEGheader->ms_per_frame();
   }
   return(startplay(ma));
}

extern "C" bool _export _stdcall __declspec(dllexport) Pause(bool resume)
{
  ResultError = mpSuccess;
  if (ma == NULL || player == NULL) {
      ResultError = mpIncorrectMode;
  		return(false);
  }
  if ((ma->playmode == 4 && resume) || (ma->playmode == 3 && !resume)) {
    ma->pause = true;
  }
/*  if (ma->playmode == 4 && resume) {
     ma->playmode = 3;
     ma->pause = true;
//     player->Resume();
  } else
  if (ma->playmode == 3 && !resume) {
     ma->playmode = 4;
     ma->pause = true;
//     player->Suspend();
  }
/*
  if (ma->playmode == 3 && !resume) {
     ma->pause = true;
     return(true);
  }
  if (ma->playmode == 4 && resume) {
     if (PauseSemaphore) ReleaseSemaphore(PauseSemaphore,1,NULL);
  }
*/
  return(true);
}

extern "C" bool _export _stdcall __declspec(dllexport) Restart()
{
   if (ma==NULL || ((ma->playmode != 1) && (ma->playmode != 2))) {
      ResultError = mpIncorrectMode;
      return(false);
   }
  *StopHook = false;
  if (!ma->MPEGheader) {delete ma->MPEGheader;}
  try
  {
    ma->MPEGheader = new Header;
  }
  catch (...) {
    if (ResultError == 0) { ResultError = mpInternalError; }
    return(false);
  }
  if ((!ma->stream->restart()) || (!ma->MPEGheader->read_header(ma->stream, &crc))) {
    ResultError = mpStreamError;
    return(false);
  }
  ma->playmode = 1;
  if (Play(ma->startpos*ma->MPEGheader->ms_per_frame(),
           ma->endpos*ma->MPEGheader->ms_per_frame(),
           StopHook)!=0)
  {
    return(false);
  } else {return(true);}
}

extern "C" bool _export _stdcall __declspec(dllexport) Stop()
{
   ResultError = mpSuccess;
   if (ma == NULL || (ma->playmode < 2)) {
     ResultError = mpIncorrectMode;
     return(false);
   } else {
   	if (ma->playmode == 2) {
        ma->playmode = 1;
        return(true);
      } else
      {
       ma->stop = true;
       if (ma->playmode == 4) {
         Pause(true);
         while (ma->playmode == 4)
         {
           Sleep(0);
           ma->pause = false;
         }
       }
       player->WaitForExit(INFINITE);
       ma->playmode = 1;
       *StopHook = false;
       return(true);
      }
     }
}

extern "C" bool _export _stdcall __declspec(dllexport) Close()
{
   ResultError = mpSuccess;
   if (ma == NULL || ma->playmode<1) {
      ResultError = mpIncorrectMode;
      return(false);
   }
   if (ma->playmode == 3 || ma->playmode == 4) {
     Stop();
   }
   delete ma->MPEGheader;
   ma->MPEGheader = NULL;
   delete ma->stream;
   ma->stream = NULL;

   musicsize = -1;
   ma->musicpos  = -1;
   ma->playmode  = 0;
   return(true);
}

extern "C" bool _export _stdcall __declspec(dllexport) deinit()
{
   ResultError = mpSuccess;
   if (ma == NULL) {
      return(true);
   }
   if (ma -> playmode>0) {
     Close();
   }
   delete ma;
   ma = NULL;
   return(true);
}

//---------------------------------------------------------------------------
