unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, Buttons, MPEGPlay, ExtCtrls, ComCtrls, slider;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    PlayBtn: TBitBtn;
    StopBtn: TBitBtn;
    PauseBtn: TBitBtn;
    OpenBtn: TBitBtn;
    Timer1: TTimer;
    Label1: TLabel;
    LengthLabel: TLabel;
    RxSlider1: TSlider;
    PriorityCombo: TComboBox;
    Label2: TLabel;
    LoopedCB: TCheckBox;
    MPlayer: TMPEGPlayer;
    procedure PlayBtnClick(Sender: TObject);
    procedure PauseBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure RxSlider1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MPlayerPosUpdate(Pos, Len: LongInt);
    procedure MPlayerPlayEnd(Sender: TObject);
    procedure PriorityComboChange(Sender: TObject);
  private
    procedure DoOpen;
  public
    { Private declarations }
    Dontseek : boolean; {means that slider has to be updated}
    procedure CallBackCreateStream (var cant_seek:boolean; var res:pointer);
    procedure CallBackCloseStream (handle :pointer);
    procedure CallBackRestartStream (handle :pointer; var res:boolean);
    procedure CallBackReadStream (handle:pointer;
                   var read_buffer;
                   nNumberOfBytesToRead:longint;
                   var nNumberOfBytesRead:longInt; var res:boolean);
     procedure CallBackSeekStream (handle:pointer;
                        NumBytes,MoveMethod:LongInt; var res:LongInt);
     procedure CallBackGetStreamSize (handle:pointer; var res:longint);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CallBackCreateStream;
var t:TFileStream;
begin
  t:=TFileStream.Create(MPlayer.StreamName, fmOpenRead or fmShareExclusive);
  res:=pointer(t);
  Cant_seek:=false;
end;

procedure TForm1.CallBackCloseStream;
begin
  TFileStream(handle).free;
end;

procedure TForm1.CallBackRestartStream;
begin
  res:=((TFileStream(handle).Seek(0,soFromBeginning))=0);
end;

procedure TForm1.CallBackReadStream;
begin
  nNumberOfBytesRead:=TFileStream(handle).Read(read_buffer, nNumberOfBytesToRead);
  res:=true;
end;

procedure TForm1.CallBackSeekStream;
begin
  res:=(TFileStream(handle).Seek(NumBytes,MoveMethod));
end;

procedure TForm1.CallBackGetStreamSize;
begin
  res:=TFileStream(handle).Size;
end;

procedure TForm1.PlayBtnClick(Sender: TObject);
begin
  if MPlayer.paused then
  begin
    MPlayer.Paused:=false;
    PlayBtn.Enabled:=false;
    PauseBtn.Enabled:=true;
  end
  else
  begin
    MPlayer.Play;
    PlayBtn.Enabled:=false;
    StopBtn.Enabled:=true;
    PauseBtn.Enabled:=true;
  end;
end;

procedure TForm1.PauseBtnClick(Sender: TObject);
begin
  MPlayer.paused:=not (Mplayer.Paused);
  PauseBtn.Enabled:=not (MPlayer.Paused);
  PlayBtn.Enabled:=MPlayer.Paused;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  RXSlider1.Value:=0;
  StopBtn.Enabled:=false;
  PauseBtn.Enabled:=false;
  PlayBtn.Enabled:=true;
  MPlayer.Stop;
end;

procedure TForm1.DoOpen;
var s:string;
begin
  MPlayer.Open;
  RxSlider1.MaxValue:=MPlayer.Length;
  RXSlider1.Value:=0;
  Str(RxSlider1.MaxValue, s);
  LengthLabel.Caption:=s;
  PlayBtn.Enabled:=true;
  StopBtn.Enabled:=false;
  PauseBtn.Enabled:=false;
end;

procedure TForm1.OpenBtnClick(Sender: TObject);
begin
  if not OpenDialog1.Execute then exit;
  MPlayer.StreamName:=OpenDialog1.FileName;
  DoOpen;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  MPlayer.init;
  MPlayer.OnOpenStream:=CallBackCreateStream;
  MPlayer.OnCloseStream:=CallBackCloseStream;
  MPlayer.OnRestartStream:=CallBackRestartStream;
  MPlayer.OnGetStreamSize:=CallBackGetStreamSize;
  MPlayer.OnSeekStream:=CallBackSeekStream;
  MPlayer.OnReadStream:=CallBackReadStream;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if not MPlayer.DLLLoaded then exit;
  if (MPlayer.mode=plmPlaying) then
  begin
    DontSeek:=true;
    RXSlider1.Value:=MPlayer.CurrentPosition;
    DontSeek:=false;
  end;
  if MPlayer.PlayStopped then
  begin
    RXSlider1.Value:=0;
    PlayBtn.Enabled:=true;
    StopBtn.Enabled:=false;
    PauseBtn.Enabled:=false;
    if LoopedCB.checked then
    begin
      MPlayer.Restart;
      PlayBtn.Enabled:=false;
      StopBtn.Enabled:=true;
      PauseBtn.Enabled:=true;
    end;
  end;
end;

procedure TForm1.RxSlider1Change(Sender: TObject);
begin
  if not (DontSeek) then
    if (MPlayer.mode=plmPlaying) or ((MPlayer.mode=plmPaused))
      then MPlayer.CurrentPosition:=RXSlider1.Value;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  MPlayer.Deinit;
end;

procedure TForm1.MPlayerPosUpdate(Pos, Len: Integer);
begin
  DontSeek:=true;
  RXSlider1.Value:=MPlayer.CurrentPosition;
  DontSeek:=false;
end;

procedure TForm1.MPlayerPlayEnd(Sender: TObject);
begin
  RXSlider1.Value:=0;
  PlayBtn.Enabled:=true;
  StopBtn.Enabled:=false;
  PauseBtn.Enabled:=false;
  if LoopedCB.checked then
  begin
    MPlayer.Restart;
    PlayBtn.Enabled:=false;
    StopBtn.Enabled:=true;
    PauseBtn.Enabled:=true;
  end;
end;

procedure TForm1.PriorityComboChange(Sender: TObject);
begin
  with MPlayer do
  case PriorityCombo.ItemIndex of
    0:  PlayerPriority := Idle;
    1 : PlayerPriority := Lowest;
    2 : PlayerPriority := BelowNormal;
    3 : PlayerPriority := Normal;
    4 : PlayerPriority := AboveNormal;
    5 : PlayerPriority := Highest;
    6 : PlayerPriority := TimeCritical;
   end;
end;

end.
