// ਬ ࠡ᪮ ⥪஢

// 稬  ᢮ ⥪
#include "video.h"
#include "3d.h"

// 楤 ᮢ ࠭  
void drawParabolicTexturedFace(face *f) {
  vertex *a, *b, *c, *tmp_vertex;
  int current_sx, current_sy, length, len;
  float tmp, k, x_start, x_end;
  float uz_start, uz_end, vz_start, vz_end, z1_start, z1_end;
  float u_a, v_a, u_b, v_b, u_c, v_c, u, v, du, dv, ddu, ddv;
  float pa, pb, pc;
  char *dest;

  a = f->v1;
  b = f->v2;
  c = f->v3;

  // ஥㥬 設 ࠭
  projectVertex(a);
  projectVertex(b);
  projectVertex(c);

  // ⠥ u/z, v/z, 1/z   設
  a->z1 = 1 / (a->z + dist);
  a->uz = a->u * a->z1;
  a->vz = a->v * a->z1;
  b->z1 = 1 / (b->z + dist);
  b->uz = b->u * b->z1;
  b->vz = b->v * b->z1;
  c->z1 = 1 / (c->z + dist);
  c->uz = c->u * c->z1;
  c->vz = c->v * c->z1;

  // 㥬 設 ࠭  sy
  if (a->sy > b->sy) { tmp_vertex = a; a = b; b = tmp_vertex; }
  if (a->sy > c->sy) { tmp_vertex = a; a = c; c = tmp_vertex; }
  if (b->sy > c->sy) { tmp_vertex = b; b = c; c = tmp_vertex; }

  // ࠭ 㫥  ᮢ  㤥
  if ((int)c->sy == (int)a->sy) return;

  // 筠 ᮢ ࠭
  for (current_sy = (int)a->sy; current_sy <= (int)c->sy; current_sy++) {
    // ⠥ x, u/z, v/z, 1/z  ஭ AC
    k = (current_sy - a->sy) / (c->sy - a->sy);
    x_start = a->sx + (c->sx - a->sx) * k;
    uz_start = a->uz + (c->uz - a->uz) * k;
    vz_start = a->vz + (c->vz - a->vz) * k;
    z1_start = a->z1 + (c->z1 - a->z1) * k;

    if (current_sy >= b->sy) {
      //  室  設 B, ⠥ x, u/z, v/z, 1/z  ஭ BC
      k = (current_sy - b->sy) / (c->sy - b->sy);
      x_end = b->sx + (c->sx - b->sx) * k;
      uz_end = b->uz + (c->uz - b->uz) * k;
      vz_end = b->vz + (c->vz - b->vz) * k;
      z1_end = b->z1 + (c->z1 - b->z1) * k;
    } else {
      //  室  設 B, ⠥ x, u/z, v/z, 1/z  ஭ AB
      k = (current_sy - a->sy) / (b->sy - a->sy);
      x_end = a->sx + (b->sx - a->sx) * k;
      uz_end = a->uz + (b->uz - a->uz) * k;
      vz_end = a->vz + (b->vz - a->vz) * k;
      z1_end = a->z1 + (b->z1 - a->z1) * k;
    }

    // x_start  室  x_end
    if (x_start > x_end) {
      tmp = x_start; x_start = x_end; x_end = tmp;
      tmp = uz_start; uz_start = uz_end; uz_end = tmp;
      tmp = vz_start; vz_start = vz_end; vz_end = tmp;
      tmp = z1_start; z1_start = z1_end; z1_end = tmp;
    }

    // ⠥  砫 ப  
    dest = &videoBuffer;
    dest += current_sy * xSize + (int)x_start;

    // ⠥  㥬 ப
    length = (int)x_end - (int)x_start;

    // ப 㫥  ᮢ  㤥
    if (length == 0) continue;

    // ⠥ u, v  砫, ।   ப
    u_a = uz_start / z1_start;
    v_a = vz_start / z1_start;
    u_b = (uz_start + uz_end) / (z1_start + z1_end);
    v_b = (vz_start + vz_end) / (z1_start + z1_end);
    u_c = uz_end / z1_end;
    v_c = vz_end / z1_end;

    // ⠥ 砫쭮 du  ddu
    pa = 2 * ((u_c - u_a) - 2 * (u_b - u_a)) / (length * length);
    pb = (4 * (u_b - u_a) - (u_c - u_a)) / length;
    pc = u_a;
    u   = pc;
    du  = pa + pb;
    ddu = 2 * pa;

    // ⠥ 砫쭮 dv  ddv
    pa = 2 * ((v_c - v_a) - 2 * (v_b - v_a)) / (length * length);
    pb = (4 * (v_b - v_a) - (v_c - v_a)) / length;
    pc = v_a;
    v   = pc;
    dv  = pa + pb;
    ddv = 2 * pa;

    // 㥬 ᮪
    while (length--) {
      *dest++ = f->texture[((int)v) * 256 + (int)u];
      u += du;
      v += dv;
      du += ddu;
      dv += ddv;
    }
  }
}

void main() {
  vertex v1, v2, v3;
  face f;

  setVideoMode(0x13); // ⠢ ० 320x200x256c
  initPalette();      // ⠢ 
  makeTexture();      // ᣥ㥬 ⥪
  clearVideoBuffer(); // ⨬  ᮢ

  // "ந" ࠭
  f.v1 = &v1;
  f.v2 = &v2;
  f.v3 = &v3;
  f.texture = &exampleTexture;

  // ⮢ 祭 न 設
  v1.x = -120;
  v1.y = 80;
  v1.z = 0;
  v2.x = -120;
  v2.y = -80;
  v2.z = 0;
  v3.x = -80;
  v3.y = 80;
  v3.z = 160;

  // ⮢ 祭 न ⥪  設
  v1.u = 0;
  v1.v = 0;
  v2.u = 0;
  v2.v = 255;
  v3.u = 255;
  v3.v = 0;

  // 㥬 ࠭  
  drawParabolicTexturedFace(&f);

  // ᪮㥬   ࠭
  showVideoBuffer();

  //   
  getch();

  // ୥  ⥪⮢ ०
  setVideoMode(0x03);
}