/*
 * Decompiled with CFR 0.152.
 */
package com.denova.util;

import com.denova.io.FixZipBugInputFilter;
import com.denova.io.ZipEntryInputStream;
import com.denova.io.Zipper;
import com.denova.util.PathEnumeration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DataFinder {
    private static final boolean debugging = false;
    static Vector datapath = new Vector();
    static boolean getResourceEnabled = true;
    static boolean datapathEnabled = true;
    static boolean classpathEnabled = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream getStream(String string) {
        Object object;
        Object object2;
        InputStream inputStream = null;
        DataFinder.debug("DataFinder getting stream for " + string);
        if (inputStream == null && datapathEnabled) {
            object2 = datapath.elements();
            while (inputStream == null && object2.hasMoreElements()) {
                object = (File)object2.nextElement();
                inputStream = DataFinder.getFileStream((File)object, string);
                Thread.yield();
            }
            if (inputStream == null) {
                DataFinder.debug("Not in datapath");
            }
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(new File(string));
                if (inputStream == null) {
                    DataFinder.debug("Not an ordinary file");
                }
            }
            catch (Exception exception) {
                DataFinder.debug(exception);
            }
        }
        if (inputStream == null && getResourceEnabled && (inputStream = new DataFinder().getClass().getResourceAsStream(string)) == null) {
            DataFinder.debug("Not found by getResourceAsStream");
        }
        if (inputStream == null && getResourceEnabled) {
            try {
                inputStream = new DataFinder().getClass().getResource(string).openStream();
            }
            catch (Exception exception) {
                DataFinder.debug(exception);
            }
        }
        if (inputStream == null && classpathEnabled) {
            object2 = System.getProperty("java.class.path", "");
            object = new PathEnumeration((String)object2);
            while (inputStream == null && ((PathEnumeration)object).hasMoreElements()) {
                String string2 = (String)((PathEnumeration)object).nextElement();
                File file = new File(string2);
                if (file.isDirectory()) {
                    inputStream = DataFinder.getFileStream(file, string);
                } else {
                    ZipEntry zipEntry;
                    ZipFile zipFile = Zipper.getZipFile(string2);
                    if (zipFile != null && (zipEntry = Zipper.getZipEntry(zipFile, string)) != null) {
                        try {
                            ZipEntryInputStream zipEntryInputStream = new ZipEntryInputStream(zipFile, zipEntry);
                            inputStream = new FixZipBugInputFilter(zipEntryInputStream);
                        }
                        catch (Exception exception) {
                            DataFinder.debug(exception);
                        }
                    }
                }
                Thread.yield();
            }
            if (inputStream == null) {
                DataFinder.debug("Not in classpath");
            }
        }
        if (inputStream == null) {
            DataFinder.debug("Unable to find stream for resource: " + string);
            return inputStream;
        }
        DataFinder.debug("got stream for resource: " + string);
        return inputStream;
    }

    public static synchronized void addDirectory(String string) {
        DataFinder.addDirectory(new File(string));
    }

    public static synchronized void addDirectory(File file) {
        if (file.isDirectory()) {
            datapath.addElement(file);
        }
    }

    public static boolean isGetResourceEnabled() {
        return getResourceEnabled;
    }

    public static void setGetResourceEnabled(boolean bl) {
        getResourceEnabled = bl;
    }

    public static boolean isDatapathEnabled() {
        return datapathEnabled;
    }

    public static void setDatapathEnabled(boolean bl) {
        datapathEnabled = bl;
    }

    public static boolean isClasspathEnabled() {
        return classpathEnabled;
    }

    public static void setClasspathEnabled(boolean bl) {
        classpathEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileInputStream getFileStream(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            File file2 = new File(file, string);
            return new FileInputStream(file2);
        }
        catch (Exception exception) {
        }
        return fileInputStream;
    }

    private static void debug(String string) {
    }

    private static void debug(Throwable throwable) {
    }
}

