/*
 * Decompiled with CFR 0.152.
 */
package com.denova.util;

public class Base64 {
    private static final char[] codes = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] bytes;
    private static int byteOffset;
    private static int bitOffset;

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Base64.resetBitShifter(byArray);
        int n2 = Base64.next6bits();
        while (n2 >= 0) {
            stringBuffer.append(codes[n2]);
            ++n;
            n2 = Base64.next6bits();
        }
        while (n % 4 > 0) {
            stringBuffer.append('=');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void resetBitShifter(byte[] byArray) {
        bytes = byArray;
        byteOffset = 0;
        bitOffset = 0;
    }

    private static int next6bits() {
        int n;
        int n2 = 63;
        if (byteOffset >= bytes.length) {
            n = -1;
        } else if (bitOffset == 0) {
            n = bytes[byteOffset] >> 2;
            bitOffset = 6;
            n &= 0x3F;
        } else if (bitOffset == 2) {
            n = bytes[byteOffset];
            ++byteOffset;
            bitOffset = 0;
            n &= 0x3F;
        } else if (bitOffset == 4) {
            n = (bytes[byteOffset] & 0xF) << 2;
            if (++byteOffset < bytes.length) {
                n |= (bytes[byteOffset] & 0xC0) >> 6;
                bitOffset = 2;
            }
            n &= 0x3F;
        } else if (bitOffset == 6) {
            n = (bytes[byteOffset] & 3) << 4;
            if (++byteOffset < bytes.length) {
                n |= (bytes[byteOffset] & 0xF0) >> 4;
                bitOffset = 4;
            }
            n &= 0x3F;
        } else {
            n = -1;
        }
        return n;
    }
}

