/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.ui.GridBagControl;
import com.denova.ui.UiUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SubListDialog
extends JDialog
implements Runnable {
    boolean ok;
    Vector availableListVector;
    Vector subListVector;
    JTextField name;
    JTextField description;
    JList availableList;
    JList subList;
    JButton addButton;
    JButton removeButton;
    JButton okButton;
    JButton cancelButton;
    String noteText;

    JPanel createActionButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        gridBagControl.addHorizontalSpace();
        this.addButton = new JButton("Select");
        this.addButton.setToolTipText("Select an available item");
        gridBagControl.add(this.addButton);
        gridBagControl.addHorizontalSpace();
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove a selected item");
        gridBagControl.add(this.removeButton);
        gridBagControl.addHorizontalSpace();
        return jPanel;
    }

    JPanel createExitButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        gridBagControl.addHorizontalSpace();
        this.okButton = new JButton("Ok");
        gridBagControl.add(this.okButton);
        gridBagControl.addHorizontalSpace();
        this.cancelButton = new JButton("Cancel");
        gridBagControl.add(this.cancelButton);
        gridBagControl.addHorizontalSpace();
        return jPanel;
    }

    public String getName() {
        return this.name.getText();
    }

    public String getDescription() {
        return this.description.getText();
    }

    public Vector getSubList() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.subList.getModel().getSize()) {
            vector.addElement(this.subList.getModel().getElementAt(n));
            ++n;
        }
        return vector;
    }

    public boolean isOk() {
        return this.ok;
    }

    Vector subtractSublist(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector2.contains(e)) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    boolean moveSelection(JList jList, Vector vector, Vector vector2) {
        int n = jList.getSelectedIndex();
        if (n >= 0) {
            Object e = vector.elementAt(n);
            vector.removeElement(e);
            vector2.addElement(e);
        }
        return n >= 0;
    }

    void updateLists() {
        UiUtilities.update((Component)this.availableList, (Object)this.availableListVector);
        UiUtilities.update((Component)this.subList, (Object)this.subListVector);
    }

    void SubListDialog_WindowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    void addButton_Clicked(ActionEvent actionEvent) {
        if (this.moveSelection(this.availableList, this.availableListVector, this.subListVector)) {
            this.updateLists();
        } else {
            this.noteText = "Click an available item, then click Select";
            SwingUtilities.invokeLater(this);
        }
    }

    void removeButton_Clicked(ActionEvent actionEvent) {
        if (this.moveSelection(this.subList, this.subListVector, this.availableListVector)) {
            this.updateLists();
        } else {
            this.noteText = "Click a selected item, then click Remove";
            SwingUtilities.invokeLater(this);
        }
    }

    void okButton_Clicked(ActionEvent actionEvent) {
        this.ok = true;
        this.exit();
    }

    void cancelButton_Clicked(ActionEvent actionEvent) {
        this.ok = false;
        this.exit();
    }

    public void run() {
        UiUtilities.note(this.noteText);
    }

    void exit() {
        ((Component)this).hide();
        this.dispose();
    }

    public SubListDialog(Container container, String string, Vector vector, Vector vector2) {
        this(container, string, null, null, vector, vector2);
    }

    public SubListDialog(Container container, String string, String string2, Vector vector, Vector vector2) {
        this(container, null, string, string2, vector, vector2);
    }

    public SubListDialog(Container container, String string, String string2, String string3, Vector vector, Vector vector2) {
        super((Frame)UiUtilities.forceJFrameParent(container), true);
        JComponent jComponent;
        this.subListVector = (Vector)vector2.clone();
        this.availableListVector = this.subtractSublist(vector, vector2);
        Container container2 = this.getContentPane();
        JPanel jPanel = new JPanel();
        int n = 12;
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        Font font = new Font("BoldFont", 1, 12);
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.anchor = 12;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        GridBagConstraints gridBagConstraints4 = GridBagControl.getDefaultConstraints();
        gridBagConstraints4.gridheight = 5;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 1;
        if (string != null) {
            jComponent = new JLabel(string);
            jComponent.setFont(font);
            gridBagControl.addVerticalSpace();
            gridBagControl.addCentered(jComponent);
            gridBagControl.addVerticalSpace();
        }
        if (string2 == null) {
            this.name = new JTextField();
        } else {
            gridBagControl.add(gridBagConstraints, new JLabel("Name: "));
            this.name = new JTextField(string2);
            gridBagControl.endRow(gridBagConstraints3, this.name);
        }
        if (string3 == null) {
            this.description = new JTextField();
        } else {
            gridBagControl.add(gridBagConstraints, new JLabel("Description: "));
            this.description = new JTextField(string3);
            gridBagControl.endRow(gridBagConstraints3, this.description);
        }
        gridBagControl.add(gridBagConstraints2, new JLabel("Selected: "));
        this.subList = new JList(this.subListVector);
        jComponent = new JScrollPane();
        ((JScrollPane)jComponent).getViewport().add(this.subList);
        gridBagControl.endRow(gridBagConstraints4, jComponent);
        gridBagControl.addBlankCell();
        gridBagControl.endRow(this.createActionButtonPanel());
        gridBagControl.add(gridBagConstraints2, new JLabel("Available: "));
        this.availableList = new JList(this.availableListVector);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.availableList);
        gridBagControl.endRow(gridBagConstraints4, jScrollPane);
        gridBagControl.addCentered(this.createExitButtonPanel());
        gridBagControl.addVerticalSpace();
        container2.add(jPanel);
        this.pack();
        UiUtilities.centerComponent(this);
        SubListDialog subListDialog = this;
        if (subListDialog == null) {
            throw null;
        }
        SubListDialogWindow subListDialogWindow = subListDialog.new SubListDialogWindow();
        this.addWindowListener(subListDialogWindow);
        SubListDialog subListDialog2 = this;
        if (subListDialog2 == null) {
            throw null;
        }
        SubListDialogAction subListDialogAction = subListDialog2.new SubListDialogAction();
        this.addButton.addActionListener(subListDialogAction);
        this.removeButton.addActionListener(subListDialogAction);
        this.okButton.addActionListener(subListDialogAction);
        this.cancelButton.addActionListener(subListDialogAction);
    }

    class SubListDialogWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof SubListDialog) {
                SubListDialog.this.SubListDialog_WindowClosing(windowEvent);
            }
        }

        SubListDialogWindow() {
        }
    }

    class SubListDialogAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SubListDialog.this.addButton) {
                SubListDialog.this.addButton_Clicked(actionEvent);
            } else if (object == SubListDialog.this.removeButton) {
                SubListDialog.this.removeButton_Clicked(actionEvent);
            } else if (object == SubListDialog.this.okButton) {
                SubListDialog.this.okButton_Clicked(actionEvent);
            } else if (object == SubListDialog.this.cancelButton) {
                SubListDialog.this.cancelButton_Clicked(actionEvent);
            }
        }

        SubListDialogAction() {
        }
    }
}

