/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.io.LineEndingInputFilter;
import com.denova.io.Log;
import com.denova.runtime.JRE;
import com.denova.ui.UiUtilities;
import com.denova.util.DataFinder;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public class LocaleTranslator {
    public static final String EnglishResources = "english";
    public static final String SpanishResources = "spanish";
    public static final String GermanResources = "german";
    public static final String FrenchResources = "french";
    public static final String PolishResources = "polish";
    public static final String JapaneseResources = "japanese";
    public static final String PortugueseResources = "portuguese";
    public static final String ItalianResources = "italian";
    public static final String DutchResources = "dutch";
    public static final String DefaultExtension = ".resources";
    public static final String LocaleLog = "locale";
    String resourceExtension = ".resources";
    String defaultLanguage = "english";
    LocaleTranslator localeTranslator = this;
    PropertyResourceBundle localizedBundle;
    PropertyResourceBundle defaultBundle;
    boolean inited = false;
    Log localeLog;

    private void init() {
        this.setResourceBundle();
        this.inited = true;
        this.log("inited LocaleTranslator");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        try {
            inputStream = DataFinder.getStream(string);
        }
        catch (Exception exception) {
            this.log(exception);
        }
        if (inputStream == null) {
            try {
                inputStream = this.localeTranslator.getClass().getResourceAsStream(string);
            }
            catch (Exception exception) {
                this.log(exception);
            }
        }
        if (inputStream != null) return inputStream;
        try {
            return this.localeTranslator.getClass().getResource(string).openStream();
        }
        catch (Exception exception) {
            this.log(exception);
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setResourceBundle() {
        Object object;
        String string = "es";
        String string2 = "pl";
        String string3 = "pt";
        String string4 = "se";
        String string5 = "nl";
        this.log("setting resource bundle");
        boolean bl = false;
        InputStream inputStream = null;
        String string6 = null;
        String string7 = Locale.getDefault().getLanguage();
        this.log("user's native language " + string7);
        if (this.resourceExtension == null) {
            this.resourceExtension = DefaultExtension;
            this.log("using default resources");
        }
        if (!this.resourceExtension.startsWith(".")) {
            object = this.resourceExtension;
            this.resourceExtension = "." + (String)object;
            this.log("added . to resourceExtension " + this.resourceExtension);
        }
        if (string7.equals(Locale.ENGLISH.getLanguage())) {
            string6 = EnglishResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals("es")) {
            string6 = SpanishResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals(Locale.GERMAN.getLanguage())) {
            string6 = GermanResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals(Locale.FRENCH.getLanguage())) {
            string6 = FrenchResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals("pl")) {
            string6 = PolishResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals(Locale.ITALIAN.getLanguage())) {
            string6 = ItalianResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals("pt")) {
            string6 = PortugueseResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals("nl")) {
            string6 = DutchResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl && string7.equals(Locale.JAPANESE.getLanguage())) {
            string6 = JapaneseResources + this.resourceExtension;
            this.log("looking for resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                object = new File(JRE.getActiveJavaHome() + "lib", "font.properties." + Locale.JAPANESE.getLanguage());
                if (((File)object).exists()) {
                    bl = true;
                } else {
                    this.log("Japanese font *not* found");
                }
            }
        }
        if (!bl) {
            string6 = this.defaultLanguage + this.resourceExtension;
            this.log("looking for default resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl) {
            string6 = EnglishResources + this.resourceExtension;
            this.log("looking for English resource filename " + string6);
            inputStream = this.getResourceAsStream(string6);
            if (inputStream != null) {
                bl = true;
            }
        }
        if (!bl) {
            this.log("Unable to find any resources");
            UiUtilities.note("Unable to find any resources");
            System.exit(0);
            return;
        }
        if (string6 != null) {
            this.log("found resources " + string6);
        }
        try {
            object = new LineEndingInputFilter(inputStream);
            ((LineEndingInputFilter)object).setIsText(true);
            this.localizedBundle = new PropertyResourceBundle((InputStream)object);
            this.log("returned from PropertyResourceBunde instantiation");
        }
        catch (Throwable throwable) {
            this.log("Exception getting local resources");
            UiUtilities.note("Exception getting local resources: " + throwable);
            System.exit(0);
        }
        try {
            string6 = EnglishResources + this.resourceExtension;
            object = this.getResourceAsStream(string6);
            if (object == null) return;
            LineEndingInputFilter lineEndingInputFilter = new LineEndingInputFilter((InputStream)object);
            lineEndingInputFilter.setIsText(true);
            this.defaultBundle = new PropertyResourceBundle(lineEndingInputFilter);
            this.log("found default resources " + string6);
            return;
        }
        catch (Exception exception) {
            string6 = EnglishResources + this.resourceExtension;
            this.log("Exception getting default resources " + string6);
            UiUtilities.note("Exception getting default resources " + string6 + ": " + exception);
            System.exit(0);
            return;
        }
    }

    public void setLocale(String string, String string2) {
        Locale locale = new Locale(string, string2);
        Locale.setDefault(locale);
        this.log("setLocale to " + string + " " + string2);
    }

    public String getLanguage() {
        this.log("getLanguage " + Locale.getDefault().getLanguage());
        return Locale.getDefault().getLanguage();
    }

    public String getCountry() {
        this.log("getCountry " + Locale.getDefault().getCountry());
        return Locale.getDefault().getCountry();
    }

    public void setDefaultLanguage(String string) {
        this.defaultLanguage = string;
        this.log("setDefaultLanguage to " + this.defaultLanguage);
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setLanguageExtension(String string) {
        this.log("setLanguageExtension from " + this.resourceExtension + " to " + string);
        this.resourceExtension = string;
    }

    public String getLanguageExtension() {
        this.log("getLanguageExtension " + this.resourceExtension);
        return this.resourceExtension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(String string) {
        String string2;
        this.log("getString for " + string);
        if (!this.inited) {
            this.log("! inited");
            this.init();
        }
        try {
            string2 = this.localizedBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
            this.log("value missing in locale file");
        }
        if (string2 == null) {
            try {
                if (this.defaultBundle != null) {
                    string2 = this.defaultBundle.getString(string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
                this.log("value missing in default file");
            }
            if (string2 == null || string2.length() == 0) {
                string2 = " ";
                this.log("value set to blank");
            }
        }
        this.log("value /" + string2 + "/");
        return string2;
    }

    private void log(String string) {
        this.startLog();
        this.localeLog.write(string);
    }

    private void log(Exception exception) {
        this.startLog();
        this.localeLog.write(exception);
    }

    private void startLog() {
        if (this.localeLog == null) {
            this.localeLog = new Log(LocaleLog);
        }
    }

    public LocaleTranslator(String string) {
        this.resourceExtension = string;
        this.init();
        this.log("LocaleTranslator instantiated with " + string);
        this.log("resourceExtension is " + this.resourceExtension);
    }
}

