/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.ui.GridBagControl;
import com.denova.ui.UiUtilities;
import com.denova.util.StringConversions;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ListEditor
extends JPanel
implements Runnable {
    Vector items;
    JList list;
    boolean editingItemsEnabled;
    JButton addButton;
    JButton editButton;
    JButton deleteButton;
    boolean addPending;
    boolean editPending;
    boolean deletePending;

    public synchronized void setItems(Vector vector) {
        this.items = (Vector)vector.clone();
        UiUtilities.update((Component)this.list, (Object)this.items);
    }

    public synchronized Vector getItems() {
        return (Vector)this.items.clone();
    }

    public JList getList() {
        return this.list;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getEditButton() {
        return this.editButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    protected synchronized Object addItem() {
        String string = JOptionPane.showInputDialog("Please input a value");
        return string;
    }

    protected synchronized Object editItem(Object object) {
        return null;
    }

    protected synchronized boolean isItemDeletable(Object object) {
        return true;
    }

    public synchronized boolean isEditingItemsEnabled() {
        return this.editingItemsEnabled;
    }

    public synchronized void setEditingItemsEnabled(boolean bl) {
        if (this.editingItemsEnabled != bl) {
            this.editingItemsEnabled = bl;
            this.editButton.setVisible(this.isEditingItemsEnabled());
        }
    }

    public String toString() {
        return StringConversions.fromVector(this.items);
    }

    public void fromString(String string) {
        this.items = StringConversions.toVector(string);
        UiUtilities.update((Component)this.list, (Object)this.items);
    }

    void addButton_Clicked(ActionEvent actionEvent) {
        this.addPending = true;
        new Thread(this).start();
    }

    void editButton_Clicked(ActionEvent actionEvent) {
        this.editPending = true;
        new Thread(this).start();
    }

    void deleteButton_Clicked(ActionEvent actionEvent) {
        this.deletePending = true;
        new Thread(this).start();
    }

    public void run() {
        Object object;
        if (this.addPending) {
            this.addPending = false;
            Object object2 = this.addItem();
            if (object2 != null) {
                this.items.addElement(object2);
                Thread.yield();
                UiUtilities.update((Component)this.list, (Object)this.items);
                Thread.yield();
                object = UiUtilities.findJFrameParent(this.list);
                if (object != null) {
                    UiUtilities.redraw((Component)object);
                }
                Thread.yield();
            }
        }
        if (this.editPending) {
            this.editPending = false;
            int n = this.list.getSelectedIndex();
            if (n >= 0) {
                object = this.editItem(this.items.elementAt(n));
                if (object != null) {
                    this.items.setElementAt(object, n);
                    Thread.yield();
                    UiUtilities.update((Component)this.list, (Object)this.items);
                    Thread.yield();
                    JFrame jFrame = UiUtilities.findJFrameParent(this.list);
                    if (jFrame != null) {
                        UiUtilities.redraw(jFrame);
                    }
                    Thread.yield();
                }
            } else {
                UiUtilities.note("You must select an item before you edit it");
            }
        }
        if (this.deletePending) {
            this.deletePending = false;
            int n = this.list.getSelectedIndex();
            if (n >= 0) {
                if (this.isItemDeletable(this.items.elementAt(n))) {
                    this.items.removeElementAt(n);
                    Thread.yield();
                    UiUtilities.update((Component)this.list, (Object)this.items);
                    Thread.yield();
                    object = UiUtilities.findJFrameParent(this.list);
                    if (object != null) {
                        UiUtilities.redraw((Component)object);
                    }
                    Thread.yield();
                }
            } else {
                UiUtilities.note("You must select an item before you delete it");
            }
        }
    }

    public void showDialog() {
        this.showDialog(null);
    }

    public void showDialog(String string) {
        JDialog jDialog = new JDialog((Frame)new JFrame(), true);
        if (string != null) {
            jDialog.setTitle(string);
        }
        GridBagControl gridBagControl = new GridBagControl(jDialog.getContentPane());
        gridBagControl.addVerticalSpace();
        gridBagControl.add(this);
        gridBagControl.addVerticalSpace();
        gridBagControl.endRow();
        jDialog.show();
    }

    public ListEditor() {
        int n = 12;
        int n2 = 450;
        int n3 = 150;
        this.items = new Vector();
        this.list = new JList(this.items);
        this.editingItemsEnabled = false;
        this.addPending = false;
        this.editPending = false;
        this.deletePending = false;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.addButton = new JButton("Add");
        this.editButton = new JButton("Edit");
        this.deleteButton = new JButton("Delete");
        GridBagControl gridBagControl = new GridBagControl(this);
        gridBagControl.endRow(Box.createHorizontalStrut(450));
        GridBagConstraints gridBagConstraints = gridBagControl.getConstraints();
        gridBagConstraints.fill = 3;
        gridBagControl.add(Box.createVerticalStrut(150));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.list);
        gridBagConstraints.fill = 1;
        gridBagControl.endRow(gridBagConstraints, jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        this.addButton.setToolTipText("Add item");
        jPanel.add(this.addButton);
        this.editButton.setToolTipText("Edit selected item");
        jPanel.add(this.editButton);
        this.deleteButton.setToolTipText("Delete selected item");
        jPanel.add(this.deleteButton);
        this.editingItemsEnabled = this.isEditingItemsEnabled();
        if (!this.editingItemsEnabled) {
            this.editButton.setVisible(false);
        }
        gridBagControl.addCentered(jPanel);
        gridBagControl.addVerticalSpace();
        ListEditor listEditor = this;
        if (listEditor == null) {
            throw null;
        }
        Action action = listEditor.new Action();
        this.addButton.addActionListener(action);
        this.editButton.addActionListener(action);
        this.deleteButton.addActionListener(action);
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ListEditor.this.addButton) {
                ListEditor.this.addButton_Clicked(actionEvent);
            } else if (object == ListEditor.this.editButton) {
                ListEditor.this.editButton_Clicked(actionEvent);
            } else if (object == ListEditor.this.deleteButton) {
                ListEditor.this.deleteButton_Clicked(actionEvent);
            }
        }

        Action() {
        }
    }
}

