/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.ui.UiUtilities;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class FileSelectionDialog {
    static File defaultDirectory;
    final boolean debug = false;
    JFrame parent;
    boolean dirsOnly;
    FileFilter filter;
    String prompt;
    String approveText;
    JFileChooser filechooser;

    public void show() {
    }

    public static File getDefaultDirectory() {
        return defaultDirectory;
    }

    public static void setDefaultDirectory(String string) {
        FileSelectionDialog.setDefaultDirectory(new File(string));
    }

    public static void setDefaultDirectory(File file) {
        defaultDirectory = file;
    }

    public boolean getDirectoriesOnly() {
        return this.dirsOnly;
    }

    public void setDirectoriesOnly(boolean bl) {
        this.dirsOnly = bl;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getApproveButtonText() {
        return this.approveText;
    }

    public void setApproveButtonText(String string) {
        this.approveText = string;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getSelection() {
        Object object;
        File file = null;
        if (defaultDirectory == null && (object = System.getProperty("user.dir")) != null) {
            FileSelectionDialog.setDefaultDirectory((String)object);
        }
        this.filechooser = defaultDirectory != null ? new JFileChooser(defaultDirectory.getPath()) : new JFileChooser();
        if (this.prompt != null) {
            this.filechooser.setDialogTitle(this.prompt);
        }
        if (this.approveText != null) {
            this.filechooser.setApproveButtonText(this.approveText);
        }
        if (this.filter != null) {
            this.filechooser.setFileFilter(this.filter);
        }
        if (this.dirsOnly) {
            this.filechooser.setFileSelectionMode(1);
        } else {
            this.filechooser.setFileSelectionMode(2);
        }
        this.filechooser.setMultiSelectionEnabled(false);
        if (this.getSelectionResult() != 0) {
            return null;
        }
        try {
            object = this.filechooser.getSelectedFile();
            if (object != null) {
                String string = ((File)object).getCanonicalPath();
                file = new File(string);
            }
        }
        catch (IOException iOException) {
        }
        if (file == null) {
            defaultDirectory = this.filechooser.getCurrentDirectory();
            return defaultDirectory;
        }
        if (file.isDirectory()) {
            defaultDirectory = file;
            return file;
        }
        defaultDirectory = new File(file.getParent());
        return file;
    }

    public static File askForFileOrDirectory() {
        FileSelectionDialog fileSelectionDialog = new FileSelectionDialog();
        fileSelectionDialog.setPrompt("Select file or directory");
        fileSelectionDialog.show();
        File file = fileSelectionDialog.getSelection();
        return FileSelectionDialog.fixDoubledDirBug(file);
    }

    protected static File fixDoubledDirBug(File file) {
        String string;
        if (file != null && !file.exists() && (string = file.getParent()) != null && string.length() > 0) {
            File file2 = new File(string);
            if (file.getName().equals(file2.getName())) {
                file = file2;
            }
        }
        return file;
    }

    public static File askForExistingFileOrDirectory() {
        File file = FileSelectionDialog.askForFileOrDirectory();
        if (file != null && !file.exists()) {
            UiUtilities.note(file.getPath() + " does not exist");
            file = null;
        }
        return file;
    }

    protected int getSelectionResult() {
        return this.getFilechooser().showOpenDialog(this.getParent());
    }

    protected JFrame getParent() {
        return this.parent;
    }

    protected JFileChooser getFilechooser() {
        return this.filechooser;
    }

    public FileSelectionDialog() {
        this(null);
    }

    public FileSelectionDialog(JFrame jFrame) {
        this.parent = UiUtilities.forceJFrameParent(jFrame);
    }
}

