/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.io.ExtensionFileFilter;
import com.denova.io.Log;
import com.denova.runtime.Exec;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import com.denova.ui.FileSelectionDialog;
import com.denova.ui.UiUtilities;
import java.io.File;
import java.net.URL;

public class ExternalBrowser
implements Runnable {
    String executable;
    URL baseUrl;
    URL url;
    final boolean debugging = false;
    Log browserLog = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showURL(String string) {
        try {
            URL uRL;
            if (this.getBaseURL() != null) {
                uRL = new URL(this.getBaseURL(), string);
                this.log("url with baseUrl: " + uRL.toString());
            } else {
                uRL = new URL(string);
                this.log("url without baseUrl: " + uRL.toString());
            }
            this.showURL(uRL);
            return;
        }
        catch (Exception exception) {
            this.noteUrlException(string, exception);
            this.log(exception);
        }
    }

    public void showURL(URL uRL) {
        this.setExecutable();
        if (this.executable != null && this.executable.length() > 0) {
            this.url = uRL;
            new Thread(this).start();
        }
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void setExecutable() {
        if (this.executable == null || this.executable.length() <= 0) {
            if (OS.isWindows()) {
                this.executable = ExternalBrowser.findExecutableInRegistry();
            }
            if (this.executable == null || this.executable.length() <= 0) {
                String[] stringArray = new String[]{"The help system uses your web", "browser for maximum flexibility.", " ", "In the next dialog box, please enter", "the full pathname to your browser."};
                UiUtilities.note(stringArray);
                this.selectExecutable();
            }
        } else if (!ExternalBrowser.browserOk(this.executable)) {
            String[] stringArray = new String[]{this.executable + " is not valid.", "Please select another browser program"};
            UiUtilities.note(stringArray);
            this.selectExecutable();
        }
    }

    public String getExecutable() {
        return this.executable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = this.url.toString();
        String string2 = "file:";
        String string3 = "/";
        if (string.startsWith("file:")) {
            while (!string.startsWith("file:" + "/" + "/" + "/")) {
                string = "file:" + "/" + string.substring("file:".length());
                this.log(" arg: " + string);
            }
        }
        try {
            String[] stringArray = new String[]{this.executable, string};
            this.log("executable: " + this.executable);
            this.log("arg: " + string);
            Exec.runCommand(stringArray);
            return;
        }
        catch (Exception exception) {
            this.noteUrlException(string, exception);
            this.log(exception);
        }
    }

    public static String findExecutableInRegistry() {
        String string = null;
        if (OS.isWindows()) {
            WindowsOS windowsOS = new WindowsOS();
            string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\htmlfile\\shell\\open\\command", "");
            if (!ExternalBrowser.browserOk(string = ExternalBrowser.cleanupBrowserFilename(string))) {
                string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\htmfile\\shell\\open\\command", "");
                string = ExternalBrowser.cleanupBrowserFilename(string);
            }
        }
        return string;
    }

    public static boolean browserOk(String string) {
        File file;
        boolean bl = false;
        if (string != null && string.length() > 0 && !(file = new File(string)).isDirectory() && file.exists()) {
            bl = true;
        }
        return bl;
    }

    public boolean selectExecutable() {
        String[] stringArray;
        boolean bl = false;
        FileSelectionDialog fileSelectionDialog = new FileSelectionDialog();
        fileSelectionDialog.setPrompt("Select the executable file for your web browser");
        if (OS.isWindows()) {
            stringArray = new String[]{"exe", "bat", "com"};
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(stringArray, "Executables");
            fileSelectionDialog.setFileFilter(extensionFileFilter);
            FileSelectionDialog.setDefaultDirectory("\\");
        }
        fileSelectionDialog.show();
        stringArray = fileSelectionDialog.getSelection();
        if (stringArray != null) {
            this.executable = stringArray.getAbsolutePath();
            bl = true;
        }
        return bl;
    }

    static String cleanupBrowserFilename(String string) {
        if (string != null && string.length() > 0) {
            String string2;
            int n = string.indexOf("\"");
            if (n == 0 && (n = (string2 = string.substring(1)).indexOf("\"")) > 0) {
                string = string2.substring(0, n);
            }
            if (OS.isWindows() && (n = string.indexOf("%")) >= 0) {
                string2 = string.substring(0, n);
                string = string2.trim();
            }
        }
        return string;
    }

    void noteUrlException(String string, Exception exception) {
        String[] stringArray = new String[]{"Unable to show " + string + ": ", exception.toString()};
        UiUtilities.note(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URL getBaseURL() {
        if (this.baseUrl != null) return this.baseUrl;
        String string = System.getProperty("user.dir", "");
        if (!(string = string.replace(File.separatorChar, '/')).endsWith("/")) {
            string = string + "/";
        }
        try {
            String string2 = "file:///" + string + "x";
            this.log("baseUrlString: " + string2);
            this.baseUrl = new URL(string2);
            this.log("base URL: " + this.baseUrl.toString());
            return this.baseUrl;
        }
        catch (Exception exception) {
        }
        return this.baseUrl;
    }

    private void log(String string) {
        this.startLogging();
        this.browserLog.write(string);
    }

    private void log(Throwable throwable) {
        this.startLogging();
        this.browserLog.write(throwable);
    }

    private void startLogging() {
        if (this.browserLog == null) {
            this.browserLog = new Log("browser");
        }
    }
}

