/*
 * Decompiled with CFR 0.152.
 */
package com.denova.runtime;

import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.runtime.OS;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;

public class Exec {
    static final boolean debugging = false;
    static Log execLog = null;
    public static final String WindowsCommandFilename = "_tempcmd.bat";
    public static final String UnixCommandFilename = ".tmpjcmd";
    static final String EndOfStreamToken = "qzEOSqz";
    static boolean launchBatchCommand = false;

    public static void runCommand(String string, String string2) throws Exception {
        Exec.runCommand(string, new File(string2));
    }

    public static void runCommand(String string, File file) throws Exception {
        Exec.log("runCommand: " + string);
        Exec.log("      from: " + file.getPath());
        if (OS.isWindows()) {
            string = Exec.getWindowsCommand(string, file.getPath());
        } else if (OS.isUnix()) {
            string = Exec.getUnixCommand(string, file.getPath());
        }
        Exec.log("batchCommand: " + string);
        Exec.runCommand(string);
        Exec.removeCommandFile();
    }

    public static void runCommand(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        if (stringArray != null && stringArray.length > 0) {
            Exec.runCommand(stringArray);
        }
    }

    public static void runCommand(String[] stringArray) throws Exception {
        Process process = Exec.execCommand(stringArray);
        Exec.log("about to waitFor process");
        process.waitFor();
        Exec.log("finished waiting for process");
        Exec.log("Custom command process result: " + process.exitValue());
    }

    public static void launchCommand(String string, String string2) throws Exception {
        File file = new File(string2);
        Exec.log("launchCommand: " + string);
        Exec.log("         from: " + file.getPath());
        launchBatchCommand = true;
        if (OS.isWindows()) {
            string = Exec.getWindowsCommand(string, file.getPath());
        } else if (OS.isUnix()) {
            string = Exec.getUnixCommand(string, file.getPath());
        }
        Exec.launchCommand(string);
        launchBatchCommand = false;
        Exec.removeCommandFile();
    }

    public static void launchCommand(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        if (stringArray != null && stringArray.length > 0) {
            Process process = Exec.execCommand(stringArray);
            if (launchBatchCommand && OS.isWindows()) {
                Exec.log("finished getRuntime. exec; waiting for process output");
                int n = 1000;
                while (process.getErrorStream().available() <= 0 && process.getInputStream().available() <= 0) {
                    Thread.sleep(1000L);
                    Thread.yield();
                }
                Thread.sleep(1000L);
                Thread.yield();
                Exec.log("about to get process output");
                Exec.logProcessOutput(process, stringArray[0]);
            } else {
                Exec.log("about to waitFor process");
                process.waitFor();
                Exec.log("Custom command process result: " + process.exitValue());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getCommandArray(String var0) throws Exception {
        var2_1 = new Vector<String>();
        var3_2 = 0;
        while (var3_2 < var0.length()) {
            block8: {
                var4_3 = new StringBuffer();
                var5_4 = var0.charAt(var3_2);
                if (var5_4 != '\"' && var5_4 != '\'') ** GOTO lbl18
                ++var3_2;
                while (var3_2 < var0.length() && var0.charAt(var3_2) != var5_4) {
                    var4_3.append(var0.charAt(var3_2));
                    ++var3_2;
                }
                ++var3_2;
                break block8;
lbl-1000:
                // 1 sources

                {
                    var4_3.append(var0.charAt(var3_2));
                    ++var3_2;
lbl18:
                    // 2 sources

                    ** while (var3_2 < var0.length() && var0.charAt((int)var3_2) != ' ' && var0.charAt((int)var3_2) != '\t')
                }
lbl19:
                // 1 sources

                ++var3_2;
            }
            if (var4_3 == null || var4_3.toString().length() <= 0) continue;
            var2_1.addElement(var4_3.toString());
        }
        var1_6 = new String[var2_1.size()];
        var2_1.copyInto(var1_6);
        if (var1_6.length > 0 && OS.isUnix() && (var4_3 = var1_6[0]).indexOf(File.separator) < 0) {
            var5_5 = new File((String)var4_3);
            if (var5_5.exists()) {
                var4_3 = "." + File.separator + (String)var4_3;
            } else {
                var6_7 = File.separator + "bin";
                var5_5 = new File(var6_7, (String)var4_3);
                if (!(var5_5.exists() || (var5_5 = new File(var6_7 = File.separator + "usr" + File.separator + "bin", (String)var4_3)).exists() || (var5_5 = new File(var6_7 = File.separator + "sbin", (String)var4_3)).exists())) {
                    var6_7 = File.separator + "usr" + File.separator + "sbin";
                    var5_5 = new File(var6_7, (String)var4_3);
                }
                if (var5_5.exists()) {
                    var4_3 = var5_5.getPath();
                }
            }
            var1_6[0] = var4_3;
        }
        return var1_6;
    }

    private static Process execCommand(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(" ") != -1 && !stringArray[n].startsWith("\"") && !stringArray[n].endsWith("\"")) {
                stringArray[n] = "\"" + stringArray[n] + "\"";
            }
            Exec.log("Command arg [" + n + "]: " + stringArray[n]);
            ++n;
        }
        Exec.log("about to getRuntime.exec ");
        Process process = Runtime.getRuntime().exec(stringArray);
        Exec.log("returned from getRuntime.exec ");
        return process;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getWindowsCommand(String string, String string2) {
        File file = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
        try {
            Exec.log("begin batch file");
            FileWriter fileWriter = new FileWriter(file.getPath());
            PrintWriter printWriter = new PrintWriter(fileWriter);
            if (string2.indexOf(":") == 1) {
                printWriter.println(string2.substring(0, 2));
                string2 = string2.substring(2);
            }
            printWriter.println("cd \"" + string2 + "\"");
            Exec.log("cd \"" + string2 + "\"");
            printWriter.println(string);
            Exec.log(string);
            if (launchBatchCommand) {
                printWriter.println("echo " + EndOfStreamToken);
                Exec.log("echo " + EndOfStreamToken);
            }
            printWriter.flush();
            fileWriter.flush();
            printWriter.close();
            fileWriter.close();
            Exec.log("end batch file");
            TempFiles.add(file.getPath());
            String string3 = OS.isWindows95() ? "command.com" : "CMD.exe";
            return string3 + " /c " + "\"" + file.getPath() + "\"";
        }
        catch (Exception exception) {
            Exec.log(exception);
            file.delete();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getUnixCommand(String string, String string2) {
        File file = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
        try {
            Exec.log("begin shell script");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("cd " + string2);
            Exec.log("cd " + string2);
            printWriter.println(string);
            Exec.log(string);
            printWriter.flush();
            fileOutputStream.flush();
            printWriter.close();
            fileOutputStream.close();
            Exec.log("end shell script");
            TempFiles.add(file.getPath());
            boolean bl = launchBatchCommand;
            launchBatchCommand = false;
            Exec.runCommand("chmod 0755 " + file.getPath());
            Exec.log("chmod 0755 " + file.getPath());
            launchBatchCommand = bl;
            Thread.sleep(1000L);
            Thread.yield();
            return file.getPath();
        }
        catch (Exception exception) {
            Exec.log(exception);
            file.delete();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean removeCommandFile() {
        try {
            File file = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
            file.delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getCommandFilename() {
        String string = OS.isWindows() ? WindowsCommandFilename : UnixCommandFilename;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void logProcessOutput(Process process, String string) throws Exception {
        int n;
        int n2 = 50000;
        byte[] byArray = new byte[50000];
        boolean bl = false;
        Exec.log("entered logProcessOutput");
        while (process.getErrorStream().available() > 0) {
            Exec.log("Error executing " + string + ": ");
            bl = true;
            n = process.getInputStream().read(byArray);
            Exec.logStream(new ByteArrayInputStream(byArray, 0, n));
        }
        if (process.getInputStream().available() > 0 || !bl) {
            Exec.log("Output from " + string + ": ");
            try {
                n = 0;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (n == 0) {
                    String string2 = bufferedReader.readLine();
                    if (string2.endsWith(EndOfStreamToken)) {
                        n = 1;
                    } else if (string2 != null) {
                        Exec.log(string2);
                    }
                    Thread.yield();
                }
            }
            catch (Throwable throwable) {
                Exec.log(throwable);
            }
        }
        Exec.log("exiting logProcessOutput");
    }

    static void log(String string) {
        Exec.startLogging();
        execLog.write(string);
    }

    static void log(Throwable throwable) {
        Exec.startLogging();
        execLog.write(throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void logStream(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (true) {
                if (string == null) {
                    bufferedReader.close();
                    return;
                }
                Exec.log(string);
                Thread.yield();
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            Exec.log(throwable);
        }
    }

    static void startLogging() {
        if (execLog == null) {
            execLog = new Log("exec");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Exec.runCommand("dir >test.zos", ".");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

