/*
 * Decompiled with CFR 0.152.
 */
package com.denova.net;

import com.denova.io.Log;
import com.denova.net.DownloaderStatus;
import com.denova.net.WebFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Downloader
implements Runnable {
    static Log errorLog;
    static Log log;
    final String LastModifiedFilename = "install.lm";
    URL baseUrl;
    File directory;
    Vector urlList;
    DownloaderStatus downloaderStatus;
    String defaultBaseUrl;
    boolean downloading;
    boolean userCanceled;
    Vector reDownloads = new Vector();

    public static void setErrorLog(Log log) {
        errorLog = log;
    }

    public void setUrlVector(Vector vector) {
        this.urlList = vector;
    }

    public void setUrl(String string) {
        this.urlList = new Vector();
        this.urlList.addElement(string);
        this.defaultBaseUrl = string;
    }

    public void setUrlVectorFromUrl(String string) {
        if (this.downloaderStatus != null) {
            this.downloaderStatus.setFilename(string);
            this.downloaderStatus.setTotalFileCount(0);
            this.downloaderStatus.setFileIndex(0);
        }
        this.urlList = Downloader.getUrlAsVectorOfStrings(string);
        this.defaultBaseUrl = string;
    }

    public void setDownloaderStatus(DownloaderStatus downloaderStatus) {
        this.downloaderStatus = downloaderStatus;
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public void startDownload() {
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block6: {
            block5: {
                this.downloading = true;
                if (this.directory == null) break block5;
                if (this.urlList != null) {
                    if (this.baseUrl == null) {
                        try {
                            this.baseUrl = new URL(this.defaultBaseUrl);
                        }
                        catch (Exception exception) {
                            errorLog.write("Bad url: " + this.defaultBaseUrl);
                        }
                    }
                    this.getFiles(this.directory, this.urlList);
                    this.redoDownloads();
                    break block6;
                } else {
                    Downloader.logError("No files to download");
                }
                break block6;
            }
            Downloader.logError("No destination directory for download");
        }
        this.downloading = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getFiles(File file, Vector vector) {
        if (this.downloaderStatus != null) {
            this.downloaderStatus.setTotalFileCount(vector.size());
        }
        file.mkdirs();
        Enumeration enumeration = vector.elements();
        Hashtable hashtable = this.getLastModifiedTable(file);
        int n = 0;
        while (enumeration.hasMoreElements() && !this.userCanceled) {
            String string = (String)enumeration.nextElement();
            try {
                int n2 = 50000;
                URL uRL = this.baseUrl != null ? new URL(this.baseUrl, string) : new URL(string);
                String string2 = string.replace('/', File.separatorChar);
                File file2 = new File(file, string2);
                if (file2.getParent() != null) {
                    new File(file2.getParent()).mkdirs();
                }
                ++n;
                if (!"install.lm".equalsIgnoreCase(file2.getName())) {
                    if (this.downloaderStatus != null) {
                        this.downloaderStatus.setFilename(file2.getName());
                        this.downloaderStatus.setFileIndex(n);
                    }
                    this.getFile(uRL, file2, hashtable);
                    continue;
                }
                if (this.downloaderStatus == null) continue;
                this.downloaderStatus.setFilename("Skipped " + file2.getName());
                this.downloaderStatus.setFileIndex(n);
            }
            catch (Exception exception) {
                Downloader.log(exception);
            }
        }
        if (this.downloaderStatus != null) {
            this.downloaderStatus.setDone(true);
        }
        this.setLastModifiedTable(file, hashtable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Hashtable getLastModifiedTable(File file) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            File file2 = new File(file, "install.lm");
            if (!file2.exists()) return hashtable;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            while (true) {
                if (string == null || string2 == null) {
                    bufferedReader.close();
                    return hashtable;
                }
                hashtable.put(string, new String(string2));
                string = bufferedReader.readLine();
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            Downloader.log(exception);
        }
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLastModifiedTable(File file, Hashtable hashtable) {
        try {
            File file2 = new File(file, "install.lm");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            Enumeration enumeration = hashtable.keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    printWriter.close();
                    return;
                }
                String string = (String)enumeration.nextElement();
                printWriter.println(string);
                String string2 = (String)hashtable.get(string);
                printWriter.println(string2);
            }
        }
        catch (Exception exception) {
            Downloader.log(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getFile(URL uRL, File file, Hashtable hashtable) {
        WebFile webFile = new WebFile();
        webFile.getHeader(uRL.toString());
        if (webFile.isOk()) {
            String string = (String)hashtable.get(uRL.toString());
            if (string != null && webFile.getLastModified().equals(string)) {
                Downloader.log(file.getPath() + " is up to date");
                return;
            }
            Downloader.log("Getting " + file.getName() + " from " + uRL.toString());
            webFile.getFile(uRL.toString(), file);
            try {
                if (this.isText(file)) {
                    this.convertText(file);
                }
                hashtable.put(uRL.toString(), new String(webFile.getLastModified()));
                this.logSaved(uRL, file.getPath());
                return;
            }
            catch (IOException iOException) {
                Downloader.logError("Unable to write to disk: " + uRL.toString());
                return;
            }
        }
        if (webFile.isTimedOut()) {
            this.reDownloads.addElement(uRL.toString());
            Downloader.log(uRL.toString() + ": Timed out. Rescheduled.");
            return;
        }
        this.reDownloads.addElement(uRL.toString());
        Downloader.log(uRL.toString() + ": Unable to get page. Rescheduled.");
    }

    void redoDownloads() {
        int n = 5;
        while (!this.userCanceled && --n >= 0 && !this.reDownloads.isEmpty()) {
            Vector vector = this.reDownloads;
            this.reDownloads = new Vector();
            this.getFiles(this.directory, vector);
        }
        if (!this.reDownloads.isEmpty()) {
            Downloader.logError("After many retries still unable to complete download.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isText(File file) {
        int n = 2000;
        int n2 = 127;
        byte[] byArray = new byte[2000];
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray, 0, 2000);
            fileInputStream.close();
            bl = true;
            int n3 = 0;
            while (bl) {
                if (n3 >= 2000) return bl;
                if (n3 >= byArray.length) {
                    return bl;
                }
                bl = byArray[n3] >= 0 && byArray[n3] <= 127;
                ++n3;
            }
            return bl;
        }
        catch (Exception exception) {
            errorLog.write("Unable to test file for text " + file.getPath() + ": " + exception);
            return false;
        }
    }

    void convertText(File file) throws IOException {
        String string = "qzsaveqz";
        int n = 13;
        int n2 = 10;
        String string2 = file.getPath();
        String string3 = file.getParent();
        File file2 = string3 == null ? new File("qzsaveqz") : new File(string3, "qzsaveqz");
        file.renameTo(file2);
        file = new File(string2);
        FileReader fileReader = new FileReader(file2);
        FileWriter fileWriter = new FileWriter(file);
        int n3 = fileReader.read();
        while (n3 >= 0) {
            if (n3 != 13) {
                if (n3 == 10) {
                    fileWriter.write(System.getProperty("line.separator"));
                } else {
                    fileWriter.write(n3);
                }
            }
            n3 = fileReader.read();
        }
        fileWriter.close();
        fileReader.close();
    }

    public static Vector getUrlAsVectorOfStrings(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = Downloader.getUrlAsString(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(new String(stringTokenizer.nextToken()));
            }
        } else {
            Downloader.logError("Unable to load " + string);
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUrlAsString(String string) {
        String string2 = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            int n = uRLConnection.getContentLength();
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = inputStream.read(byArray, n2, n);
            while (true) {
                if (n3 < 0) {
                    string2 = new String(byArray, "8859_1");
                    inputStream.close();
                    return string2;
                }
                n3 = inputStream.read(byArray, n2 += n3, n -= n3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            Downloader.logError(exception);
        }
        return string2;
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    public void userCanceled() {
        this.userCanceled = true;
    }

    static void logError(String string) {
        if (errorLog != null) {
            errorLog.write(string);
        }
        Downloader.log(string);
        System.out.println(string);
    }

    static void logError(Exception exception) {
        if (errorLog != null) {
            errorLog.write(exception);
        }
        System.out.println(exception);
        exception.printStackTrace();
    }

    static void logError(String string, Exception exception) {
        Downloader.logError(string);
        Downloader.logError(exception);
    }

    static void log(String string) {
        if (log != null) {
            log.write(string);
        }
        System.out.println(string);
    }

    static void log(Exception exception) {
        Downloader.logError(exception);
        if (log != null) {
            log.write(exception);
        }
        System.out.println(exception);
        exception.printStackTrace();
    }

    static void log(String string, Exception exception) {
        Downloader.logError(string, exception);
        Downloader.log(string);
        Downloader.log(exception);
    }

    void logSaved(URL uRL, String string) {
        Downloader.log(uRL.toString() + ": Saved as " + string);
    }

    public Downloader(File file) {
        this.directory = file;
        log = new Log("downloader");
    }
}

