/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.JarException;
import com.denova.io.ZipEntryInputStream;
import com.denova.util.Cancelable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarManifest
implements Cancelable {
    public static final String Name = "Name";
    public static final String DigestAlgorithms = "Digest-Algorithms";
    public static final String SHADigest = "SHA-Digest";
    public static final String MD5Digest = "MD5-Digest";
    public static final String ManifestVersion = "Manifest-Version";
    public static final String ManifestVersionNumber = "1.0";
    public static final String MetaInformationPathname = "META-INF";
    static final String ManifestFilename = "MANIFEST.MF";
    final char Space = (char)32;
    final char Colon = (char)58;
    final int CarriageReturn = 13;
    final int EOL = 10;
    final int EOF = -1;
    boolean isJar;
    InputStream in;
    Vector manifest = new Vector();
    Properties headerSection;
    boolean isPushedBack;
    int pushedBackToken;
    boolean isPushedBackRaw;
    int pushedBackTokenRaw;
    int lineNumber;
    boolean canceled = false;

    public boolean isJar() {
        return this.isJar;
    }

    public Properties getHeader() {
        return this.headerSection;
    }

    void addHeader(String string, String string2) {
        if (this.headerSection == null) {
            this.headerSection = new Properties();
        }
        ((Hashtable)this.headerSection).put(string, string2);
    }

    public Vector getItems() {
        return (Vector)this.manifest.clone();
    }

    public void clear() {
        this.manifest = new Vector();
    }

    public void addSection(Properties properties) {
        if (!this.canceled) {
            this.manifest.addElement(properties);
        }
    }

    public void write(ZipOutputStream zipOutputStream) throws Exception {
        this.isJar = true;
        if (!this.canceled) {
            ZipEntry zipEntry = new ZipEntry(JarManifest.getManifestPathname());
            zipOutputStream.putNextEntry(zipEntry);
            PrintWriter printWriter = new PrintWriter(zipOutputStream);
            this.write(printWriter);
            String string = System.getProperty("java.version");
            if (string.compareTo("1.2") < 0) {
                printWriter.close();
            } else {
                printWriter.flush();
            }
            zipOutputStream.closeEntry();
        }
    }

    public void write(OutputStream outputStream) throws Exception {
        if (!this.canceled) {
            PrintWriter printWriter = new PrintWriter(outputStream);
            this.write(printWriter);
            String string = System.getProperty("java.version");
            if (string.compareTo("1.2") < 0) {
                printWriter.close();
            } else {
                printWriter.flush();
            }
        }
    }

    public void write(PrintWriter printWriter) throws Exception {
        if (this.manifest != null && !this.canceled) {
            Object object;
            Enumeration<Object> enumeration;
            printWriter.println(ManifestVersion + ':' + ' ' + ManifestVersionNumber);
            if (this.headerSection != null) {
                enumeration = this.headerSection.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String string = this.headerSection.getProperty((String)object, "");
                    printWriter.println((String)object + ':' + ' ' + string);
                }
            }
            printWriter.println();
            enumeration = this.manifest.elements();
            while (enumeration.hasMoreElements() && !this.canceled) {
                object = (Properties)enumeration.nextElement();
                this.writeAVPair((Properties)object, Name, printWriter);
                this.writeAVPair((Properties)object, DigestAlgorithms, printWriter);
                this.writeAVPair((Properties)object, SHADigest, printWriter);
                this.writeAVPair((Properties)object, MD5Digest, printWriter);
                printWriter.println();
                Thread.yield();
            }
        }
    }

    public void writeAVPair(Properties properties, String string, PrintWriter printWriter) throws Exception {
        String string2 = properties.getProperty(string);
        printWriter.println(string + ':' + ' ' + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseManifest(InputStream inputStream) throws JarException {
        this.isJar = true;
        this.lineNumber = 1;
        try {
            this.in = inputStream;
            try {
                if (this.moreTokens()) {
                    this.headerSection = this.parseSection();
                }
                while (this.moreTokens() && !this.canceled) {
                    this.addSection(this.parseSection());
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new JarException("Unable to parse manifest at line " + this.lineNumber + ": " + iOException);
            }
            this.in.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JarException("Manifest stream not readable: " + exception);
        }
    }

    public static String getManifestPathname() {
        return MetaInformationPathname + "/" + ManifestFilename;
    }

    public static String getManifestDirname() {
        return MetaInformationPathname;
    }

    Properties parseSection() throws JarException, IOException {
        Properties properties = new Properties();
        int n = this.nextToken();
        while (n != 10 && n != -1 && !this.canceled) {
            this.pushBack(n);
            this.parseAvPair(properties);
            n = this.nextToken();
            Thread.yield();
        }
        while (n == 10 && n != -1 && !this.canceled) {
            n = this.nextToken();
            Thread.yield();
        }
        this.pushBack(n);
        return properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseAvPair(Properties properties) throws JarException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nextToken();
        while (n != 58 && n != 10 && n != -1 && !this.canceled) {
            stringBuffer.append((char)n);
            n = this.nextToken();
            Thread.yield();
        }
        if (this.canceled) return;
        if (n != 58) throw new JarException("Colon expected in manifest at line " + this.lineNumber);
        n = this.nextToken();
        if (n != 32) throw new JarException("Space expected in manifest at line " + this.lineNumber);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = true;
        n = this.nextToken();
        while (bl) {
            if (n == 10) {
                n = this.nextToken();
                if (n != 32) {
                    this.pushBack(n);
                    bl = false;
                    ((Hashtable)properties).put(stringBuffer.toString(), stringBuffer2.toString());
                }
            } else if (n == -1) {
                bl = false;
            } else {
                stringBuffer2.append((char)n);
            }
            if (bl) {
                n = this.nextToken();
            }
            Thread.yield();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean moreTokens() {
        try {
            int n = this.nextToken();
            this.pushBack(n);
            if (n != -1) return true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    int nextToken() throws IOException {
        int n;
        if (this.isPushedBack) {
            n = this.pushedBackToken;
            if (n != -1) {
                this.isPushedBack = false;
            }
        } else if (this.isPushedBackRaw) {
            n = this.pushedBackTokenRaw;
            this.isPushedBackRaw = false;
        } else {
            n = this.in.read();
            if (n == 13 && (n = this.in.read()) != 10) {
                this.pushBackRaw(n);
                n = 10;
            }
            if (n == 10) {
                ++this.lineNumber;
            }
            if (n == -1) {
                this.pushBack(n);
            }
        }
        return n;
    }

    void pushBack(int n) {
        this.isPushedBack = true;
        this.pushedBackToken = n;
    }

    void pushBackRaw(int n) {
        this.isPushedBackRaw = true;
        this.pushedBackTokenRaw = n;
    }

    public void setCancel(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    JarManifest(ZipFile zipFile) throws Exception {
        ZipEntry zipEntry;
        if (zipFile != null && (zipEntry = zipFile.getEntry(JarManifest.getManifestPathname())) != null) {
            ZipEntryInputStream zipEntryInputStream = new ZipEntryInputStream(zipFile, zipEntry);
            this.parseManifest(zipEntryInputStream);
            zipEntryInputStream.close();
        }
    }

    public JarManifest(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.parseManifest(fileInputStream);
        fileInputStream.close();
    }

    public JarManifest(InputStream inputStream) throws JarException {
        this.parseManifest(inputStream);
    }

    public JarManifest() {
    }
}

