/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.CustomMenuInstaller;
import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SetupMenusPanel
extends WizardPanel
implements InstallPropertyNames,
JExpressConstants,
Runnable {
    JLabel doneNotice;
    boolean updated = false;

    public void setActive(boolean bl) {
        if (bl) {
            if (this.updated) {
                this.showNextPanel();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        JExpressInstaller.getInstaller().logToInstaller("Creating menus");
        try {
            CustomMenuInstaller customMenuInstaller = new CustomMenuInstaller(JExpressInstaller.getInstaller(), this.getErrorLog());
            if (customMenuInstaller.addMenus()) {
                this.showNextPanel();
            } else {
                UiUtilities.update((Component)this.doneNotice, (Object)"Unable to add menus. See log.");
                this.getNextButton().setEnabled(true);
            }
        }
        catch (Exception exception) {
            JExpressInstaller.getInstaller().logException(this, "Unable to set up menus.", exception);
            UiUtilities.update((Component)this.doneNotice, (Object)"Unable to add menus. See log.");
            this.getNextButton().setEnabled(true);
        }
        this.updated = true;
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    public boolean isNextButtonEnabled() {
        return false;
    }

    public boolean isPreviousButtonEnabled() {
        return false;
    }

    public boolean isCancelButtonEnabled() {
        return false;
    }

    public void reset() {
        this.updated = false;
    }

    public String getName() {
        return "MenusPanel";
    }

    public SetupMenusPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.setLayout(new BorderLayout());
        this.doneNotice = new JLabel(this.getLocalizedString("SettingUpMenus"), 0);
        this.doneNotice.setFont(new Font("Dialog", 1, 14));
        this.add((Component)this.doneNotice, "Center");
    }
}

