/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.Installer.CustomInstaller;
import com.denova.io.FileSystem;
import com.denova.runtime.WindowsOS;
import com.denova.util.PropertyList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;

class PicardWindowsPlatform
extends PicardPlatform {
    private String UninstallKey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\PowerChute UPS Manager " + PicardInstaller.getMajorVersion() + "." + PicardInstaller.getMinorVersion();
    private String ServiceKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\PowerChuteUpsManager\\Parameters";
    private String MainAppKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\PowerChuteUpsManager";
    private String UninstallSubKey = "UninstallString";
    private static final String kNetworkDriveCommand = "NetworkDrive";
    private static final String kUserNameCommand = "UserName";
    private static final String kHidAttribCommand = "HidAttrib";
    private static final String kAdminCommand = "Admin";
    private static final String kStopNativeUPSServiceCommand = "StopNativeUPSService";
    private static final String kStartNativeUPSServiceCommand = "StartNativeUPSService";
    private static final String kDisableNativeUPSServiceCommand = "DisableNativeUPSService";
    private static final String kEnableNativeUPSServiceCommand = "EnableNativeUPSService";
    private PicardRegistration theRegistrationProgram;
    private WindowsOS winOS = new WindowsOS();
    private boolean theRS232AlreadyInstalledFlag = false;
    private boolean theNativeServiceWasRunning = false;

    PicardWindowsPlatform(PropertyList propertyList) {
        super(propertyList);
        this.theRegistrationProgram = new PicardRegistration(propertyList);
    }

    public void RunRegistrationProgram() {
        this.theRegistrationProgram.run();
    }

    public boolean stopService() {
        boolean bl = true;
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = this.quote(string + File.separator + "pcupsmgr") + " -stop";
        try {
            this.programLaunch(string2);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.theNativeServiceWasRunning = this.stopNativeService();
        return bl;
    }

    private boolean stopNativeService() {
        boolean bl = false;
        int n = this.runCommand(kStopNativeUPSServiceCommand);
        if (0 == n) {
            bl = true;
        }
        return bl;
    }

    private boolean startNativeService() {
        boolean bl = false;
        int n = this.runCommand(kStartNativeUPSServiceCommand);
        if (0 == n) {
            bl = true;
        }
        return bl;
    }

    public boolean startService() {
        boolean bl = true;
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = this.quote(string + File.separator + "pcupsmgr") + " -start";
        try {
            this.programLaunch(string2);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (this.theNativeServiceWasRunning) {
            this.startNativeService();
        }
        return bl;
    }

    public void installRS232() {
        String string = "win32com.dll";
        String string2 = System.getProperty("java.home") + File.separator + "lib";
        String string3 = System.getProperty("java.home") + File.separator + "bin";
        String string4 = CustomInstaller.getTempDirectory() + File.separator + string;
        String string5 = string3 + File.separator + string;
        this.theRS232AlreadyInstalledFlag = new File(string5).exists();
        if (!this.theRS232AlreadyInstalledFlag) {
            try {
                FileSystem.copyFile(string4, string5);
            }
            catch (Exception exception) {
                PicardInstallLogger.debug("Unable to copy RS-232 support:" + exception.getMessage());
            }
            string4 = CustomInstaller.getTempDirectory() + File.separator + "javax.comm.properties";
            string5 = string2 + File.separator + "javax.comm.properties";
            try {
                FileSystem.copyFile(string4, string5);
            }
            catch (Exception exception) {
                PicardInstallLogger.debug("Unable to copy RS-232 support:" + exception.getMessage());
            }
        }
    }

    public void removeRS232() {
        if (!this.theRS232AlreadyInstalledFlag) {
            String string = "win32com.dll";
            String string2 = System.getProperty("java.home") + File.separator + "lib";
            String string3 = System.getProperty("java.home") + File.separator + "bin";
            String string4 = string3 + File.separator + string;
            try {
                FileSystem.removeFile(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string2 + File.separator + "javax.comm.properties";
            try {
                FileSystem.removeFile(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isInDevelopment() {
        WindowsOS windowsOS = new WindowsOS();
        String string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\Software\\APCDevelopment", "Override");
        return string != null;
    }

    public boolean isRoot() {
        return this.isinAdminGroup();
    }

    public long getDiskSpace(String string) {
        return this.winOS.getFreeDiskSpace(string);
    }

    public String getRegistrationDirectory() {
        String string = this.winOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion", "ProgramFilesDir");
        if (string == null) {
            string = "C:\\Program Files";
        }
        string = string + File.separator + "Common Files" + File.separator + "APC" + File.separator + "Registration Agent";
        return string;
    }

    public String getWindowsDirectory() {
        String string = this.winOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "SystemRoot");
        if (string == null) {
            string = "C:\\WINNT";
        }
        return string;
    }

    public String quote(String string) {
        return "\"" + string + "\"";
    }

    public void programLaunch(String string) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        try {
            process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int execProgram(String string) {
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            n = process.exitValue();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        return n;
    }

    public void silentLaunch(String string) throws IOException {
        String string2 = this.quote(CustomInstaller.getTempDirectory() + File.separator + "spawn.exe") + " " + string;
        this.programLaunch(string2);
    }

    private void spawnCommand(String string) throws IOException {
        String string2 = this.quote(CustomInstaller.getTempDirectory() + File.separator + "spawn.exe") + " /CMD:" + string;
        this.programLaunch(string2);
    }

    private int runCommand(String string) {
        String string2 = this.quote(CustomInstaller.getTempDirectory() + File.separator + "spawn.exe") + " /CMD:" + string;
        return this.execProgram(string2);
    }

    private boolean isinAdminGroup() {
        String string = "";
        try {
            this.spawnCommand(kAdminCommand);
            File file = new File(CustomInstaller.getTempDirectory() + File.separator + "spawn.out");
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to get permissions:" + exception.getMessage());
        }
        return string.compareToIgnoreCase("Administrator") == 0;
    }

    public boolean isNetworkDrive(String string) {
        String string2 = "";
        try {
            this.spawnCommand("NetworkDrive " + string);
            File file = new File(CustomInstaller.getTempDirectory() + File.separator + "spawn.out");
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string2 = bufferedReader.readLine();
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to get drive type:" + exception.getMessage());
        }
        return string2.compareToIgnoreCase("Network") == 0;
    }

    private String getCurrentUser() {
        String string = null;
        try {
            this.spawnCommand(kUserNameCommand);
            File file = new File(CustomInstaller.getTempDirectory() + File.separator + "spawn.out");
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to get user's name:" + exception.getMessage());
        }
        return string;
    }

    protected void ModifyBootIni() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        try {
            File file;
            int n = 0;
            do {
                file = new File("C:\\apcboot" + n + ".ini");
                ++n;
            } while (file.exists());
            File file2 = new File("C:\\apcboot.new");
            File file3 = new File("C:\\boot.ini");
            PicardIni.CopyIniFile(file3, file2);
            PicardBootIni picardBootIni = new PicardBootIni(file2);
            picardBootIni.addComPort(PicardInstaller.configuration.getUpsPort());
            file3.renameTo(file);
            file2.renameTo(file3);
            file3.setReadOnly();
            this.spawnCommand("HidAttrib " + file3);
        }
        catch (IOException iOException) {
            PicardInstallLogger.debug("Unable to modify boot.ini:" + iOException.getMessage());
        }
    }

    protected void install() {
        super.install();
        this.addUninstalRegistryKeys();
        this.addServiceRegistryKeys();
        this.addEventLoggingRegistryKeys();
        this.stopNativeService();
        this.theNativeServiceWasRunning = false;
        this.runCommand(kDisableNativeUPSServiceCommand);
        this.registerService();
        this.startService();
        this.theRegistrationProgram.addRegistryKeys();
        this.theRegistrationProgram.installRegistrationProgram();
        this.CreateMenus();
        this.ModifyBootIni();
        this.replaceUninstallProgram();
    }

    protected String getBrowser() {
        int n;
        String string = this.winOS.queryWindowsRegistry("HKEY_CLASSES_ROOT\\.html", "");
        String string2 = this.winOS.queryWindowsRegistry("HKEY_CLASSES_ROOT\\" + string + "\\shell\\open\\command", "");
        if (string2 == null) {
            string2 = this.winOS.queryWindowsRegistry("HKEY_CLASSES_ROOT\\.html\\shell\\open\\command", "");
            if (string2 == null) {
                string2 = this.winOS.queryWindowsRegistry("HKEY_CLASSES_ROOT\\NetscapeMarkup\\shell\\open\\command", "");
            }
            if (string2 == null) {
                string2 = this.winOS.queryWindowsRegistry("HKEY_CLASSES_ROOT\\htmlfile\\shell\\open\\command", "");
            }
            if (string2 == null) {
                string2 = "iexplore.exe";
            }
        }
        if ((n = string2.lastIndexOf("%1")) != -1) {
            int n2 = string2.lastIndexOf("\"%1\"");
            if (n2 != -1) {
                n = n2;
            }
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected void addRegKey(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        if (!this.winOS.replaceWindowsRegistry(string, string2, string3) && string3.compareTo("") != 0) {
            PicardInstallLogger.debug("registry key NOT added: " + string + " " + string2 + " " + string3);
        }
    }

    protected void addRemoveCommands(Vector vector) {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        vector.add(string + File.separator + "rmnative.exe");
        this.theRegistrationProgram.addRemoveCommands(vector);
        String string2 = string + File.separator + "spawn.exe\t/CMD:" + kEnableNativeUPSServiceCommand;
        vector.add(string2);
        super.addRemoveCommands(vector);
    }

    protected void uninstallSetup() {
        this.UpdateUninstallRegistryCommands();
        super.uninstallSetup();
    }

    private void addUninstalRegistryKeys() {
        String string = PicardInstaller.getMajorVersion() + "." + PicardInstaller.getMinorVersion();
        this.addRegKey(this.UninstallKey, "DisplayVersion", string);
        string = PicardInstaller.getMajorVersion();
        this.addRegKey(this.UninstallKey, "VersionMajor", string);
        string = PicardInstaller.getMinorVersion();
        this.addRegKey(this.UninstallKey, "VersionMinor", string);
        string = "American Power Conversion";
        this.addRegKey(this.UninstallKey, "Publisher", string);
        string = "N/A";
        this.addRegKey(this.UninstallKey, "Help Telephone", string);
        string = "";
        this.addRegKey(this.UninstallKey, "URLUpdateInfo", string);
        string = "www.apcc.com";
        this.addRegKey(this.UninstallKey, "URLInfoAbout", string);
    }

    private void addServiceRegistryKeys() {
        String string = this.thePropertyList.getProperty("applicationDirectory");
        this.addRegKey(this.ServiceKey, "AppDirectory", string);
        string = PicardResources.WindowsAppDescription;
        this.addRegKey(this.MainAppKey, "Description", string);
    }

    private void addEventLoggingRegistryKeys() {
        String string = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\PowerChuteUpsManager";
        String string2 = this.thePropertyList.getProperty("applicationDirectory") + File.separator + "comp\\systemlogger\\EventMessage.dll";
        this.addRegKey(string, "EventMessageFile", string2);
        this.winOS.addWindowsRegistry(string, "TypesSupported", new Integer(7));
    }

    private void unregisterService() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = this.quote(string + File.separator + "pcupsmgr") + " -remove";
        try {
            this.programLaunch(string2);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Can't remove service:" + exception.getMessage());
        }
    }

    private void registerService() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = this.quote(string + File.separator + "pcupsmgr");
        String string3 = " -install";
        String string4 = " -Djava.library.path=.\\lib\\win32";
        String string5 = " -Djava.class.path=.\\lib\\jce1_2_1.jar;.\\lib\\sunjce_provider.jar;.\\lib\\application.jar;.\\lib\\jsdk.jar;.\\lib\\comm.jar;.\\lib\\m11.jar;.\\lib\\ds.jar;.\\lib\\activation.jar;.\\lib\\mail.jar";
        String string6 = string2 + string3 + string4 + string5;
        try {
            this.programLaunch(string6);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Can't add service" + exception.getMessage());
        }
    }

    private void updateUninstallRegistryFile(Vector vector) {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = string + File.separator + "JExpress" + File.separator + "specreg";
        String string3 = string + File.separator + "JExpress" + File.separator + "temp";
        try {
            String string4;
            FileInputStream fileInputStream = new FileInputStream(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            int n = 0;
            while (n < vector.size()) {
                printWriter.println((String)vector.get(n));
                ++n;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string4 = bufferedReader.readLine()) != null) {
                printWriter.println(string4);
            }
            printWriter.close();
            fileOutputStream.close();
            fileInputStream.close();
            FileSystem.copyFile(string3, string2);
            FileSystem.removeFile(string3);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error updating specreg file:" + exception.getMessage());
        }
    }

    private void CreateMenus() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        this.winOS.addMenuItem("PowerChute UPS Manager", "Online Registration", string, false, false, false, "", "spawn.exe", this.getRegistrationDirectory() + File.separator + "APCRegMain.exe", "", string + File.separator + "register.ico");
        this.winOS.addMenuItem("PowerChute UPS Manager", "PowerChute Ups Manager", string, false, false, false, "", "spawn.exe", this.getBrowser() + "http://127.0.0.1:" + PicardInstaller.configuration.getWebPort(), "", string + File.separator + "pwrchute.ico");
    }

    private void UpdateUninstallRegistryCommands() {
        Vector<String> vector = new Vector<String>();
        this.theRegistrationProgram.addRemoveRegistryCommands(vector);
        vector.add("delete\t" + this.ServiceKey + "\tParameters");
        String string = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\PowerChuteUpsManager";
        vector.add("delete\t" + string);
        this.updateUninstallRegistryFile(vector);
    }

    private void replaceUninstallProgram() {
        String string = this.winOS.queryWindowsRegistry(this.UninstallKey, this.UninstallSubKey);
        string = this.thePropertyList.getProperty("applicationDirectory") + File.separator + "uninst.exe " + string;
        this.winOS.replaceWindowsRegistry(this.UninstallKey, this.UninstallSubKey, string);
    }
}

