/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class PicardWebPortPanel
extends WizardPanel
implements JExpressConstants {
    private JTextField theWebPortField;

    public PicardWebPortPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.WebPortPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.WebPortDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.WebPortDescriptionMsg02);
        JLabel jLabel4 = new JLabel(PicardResources.WebPortFieldLabel);
        this.theWebPortField = new JTextField(PicardResources.WebPortFieldDefault);
        this.theWebPortField.setToolTipText(PicardResources.WebPortFieldHelp);
        this.theWebPortField.setEditable(true);
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel4);
        gridBagControl.add(gridBagConstraints2, this.theWebPortField);
        gridBagControl.addVerticalSpace();
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            String string = PicardInstaller.configuration.getWebPort();
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                string = PicardInstaller.silentConfiguration.getWebPort(string);
            }
            this.theWebPortField.setText(string);
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                this.showNextPanel();
            }
        } else {
            PicardInstaller.configuration.setWebPort(this.theWebPortField.getText());
        }
    }

    public boolean isOk() {
        long l;
        try {
            l = Long.parseLong(this.theWebPortField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        if (l < 0L || l > 65536L) {
            this.note(PicardResources.MsgBadPort);
            return false;
        }
        return true;
    }

    public String getName() {
        return "PicardWebPortPanel";
    }
}

