/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class PicardUserInfoPanel
extends WizardPanel
implements JExpressConstants {
    private JTextField theUserNameField;
    private JPasswordField thePasswordField;
    private JPasswordField theConfirmationField;
    private static final int cMinPasswordLength = 3;
    private static final int cMaxPasswordLength = 16;
    private static final int cUserNameLength = 16;

    public PicardUserInfoPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.UserInfoPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.UserInfoDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.UserInfoDescriptionMsg02);
        JLabel jLabel4 = new JLabel(PicardResources.UserInfoNameFieldLabel);
        JLabel jLabel5 = new JLabel(PicardResources.UserInfoPasswordFieldLabel);
        JLabel jLabel6 = new JLabel(PicardResources.UserInfoConfirmationFieldLabel);
        this.theUserNameField = new JTextField(PicardResources.UserInfoNameFieldDefault);
        this.theUserNameField.setToolTipText(PicardResources.UserInfoNameFieldHelp);
        this.theUserNameField.setEditable(true);
        this.thePasswordField = new JPasswordField(PicardResources.UserInfoPasswordFieldDefault);
        this.thePasswordField.setToolTipText(PicardResources.UserInfoPasswordFieldHelp);
        this.thePasswordField.setEditable(true);
        this.thePasswordField.setEchoChar('*');
        this.theConfirmationField = new JPasswordField(PicardResources.UserInfoConfirmationFieldDefault);
        this.theConfirmationField.setToolTipText(PicardResources.UserInfoConfirmationFieldHelp);
        this.theConfirmationField.setEditable(true);
        this.theConfirmationField.setEchoChar('*');
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel4);
        gridBagControl.add(gridBagConstraints2, this.theUserNameField);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel5);
        gridBagControl.add(gridBagConstraints2, this.thePasswordField);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel6);
        gridBagControl.add(gridBagConstraints2, this.theConfirmationField);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            String string = PicardInstaller.configuration.getUserName();
            String string2 = PicardInstaller.configuration.getUserPassword();
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                string = PicardInstaller.silentConfiguration.getUserName(string);
                string2 = PicardInstaller.silentConfiguration.getUserPassword(string2);
            }
            this.theUserNameField.setText(string);
            ((JTextComponent)this.thePasswordField).setText(string2);
            ((JTextComponent)this.theConfirmationField).setText(string2);
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                this.showNextPanel();
            }
        } else {
            PicardInstaller.configuration.setUserName(this.theUserNameField.getText());
            String string = new String(this.thePasswordField.getPassword());
            PicardInstaller.configuration.setUserPassword(string);
        }
    }

    public boolean isOk() {
        if (this.theUserNameField.getText().length() == 0 || this.theUserNameField.getText().length() > 16) {
            this.note(PicardResources.MsgUserNameLength);
            return false;
        }
        String string = new String(this.theConfirmationField.getPassword());
        String string2 = new String(this.thePasswordField.getPassword());
        if (string.length() < 3 || string.length() > 16) {
            this.note(PicardResources.MsgPasswordLength);
            return false;
        }
        if (string.compareTo(string2) != 0) {
            this.note(PicardResources.MsgPasswordMismatch);
            return false;
        }
        return true;
    }

    public String getName() {
        return "PicardUserInfoPanel";
    }
}

