/*
 * Decompiled with CFR 0.152.
 */
import com.denova.io.FileSystem;
import com.denova.runtime.Exec;
import com.denova.util.PropertyList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

abstract class PicardUnixPlatform
extends PicardPlatform {
    protected String theStartupScriptName = "bin/startup";
    private String theShutdownScriptName = "bin/shutdown";
    private String theNotifierScriptName = "bin/notifier";
    private String theUninstallScriptName = "bin/uninstall";
    private String theJExpressUninstallScript = "uninstallPowerChuteBusinessEditionAgent";

    PicardUnixPlatform(PropertyList propertyList) {
        super(propertyList);
    }

    public abstract void installRS232();

    public abstract void removeRS232();

    public abstract void createStartupScript();

    public abstract long resolveDiskFree(String var1);

    public void RunRegistrationProgram() {
        String string = this.getBrowser();
        try {
            if (string != null) {
                string = this.getBrowser() + " http://www.apcc.com/support/warranty/";
                Exec.runCommand(string);
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error can't run registration program:" + exception.getMessage());
        }
    }

    public boolean stopService() {
        boolean bl = true;
        try {
            String[] stringArray = new String[]{"sh", "-c", this.getFullStartScriptName() + " stop"};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean startService() {
        boolean bl = true;
        try {
            String[] stringArray = new String[]{"sh", "-c", this.getFullStartScriptName() + " start"};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isRoot() {
        boolean bl;
        try {
            File file = File.createTempFile("UPS", null);
            File file2 = File.createTempFile("UPS", null);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("id | grep \"root\" >" + file2.getCanonicalPath());
            bufferedWriter.close();
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
            this.makeExectuable(file.getCanonicalPath());
            Exec.runCommand("sh -c " + file.getCanonicalPath());
            FileInputStream fileInputStream = new FileInputStream(file2);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            bl = string != null;
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
            file2.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to determine if root:" + exception.getMessage());
            bl = false;
        }
        return bl;
    }

    public long getDiskSpace(String string) {
        File file = new File(string);
        if (file.exists()) {
            return this.resolveDiskFree(this.resolveLinks(string));
        }
        return this.resolveDiskFree(string);
    }

    protected void install() {
        super.install();
        if (!PicardInstaller.RPMBuild()) {
            this.createUninstallScript();
        }
        this.createStartupScript();
        this.registerScripts();
    }

    protected void addRemoveCommands(Vector vector) {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        vector.add(string + File.separator + this.theUninstallScriptName);
        super.addRemoveCommands(vector);
        vector.add("delfile\t/etc/pbeagent.pid");
        vector.add("delfile\t" + string + File.separator + this.theShutdownScriptName);
        vector.add("delfile\t" + string + File.separator + this.theNotifierScriptName);
        vector.add("delfile\t" + string + File.separator + this.theStartupScriptName);
        vector.add("delfile\t" + string + File.separator + this.theUninstallScriptName);
        vector.add("delfile\t" + this.getFullStartScriptName());
    }

    protected abstract String getFullStartScriptName();

    private String getEnvironmentVariable(String string) {
        String string2 = null;
        try {
            File file = File.createTempFile("UPS", null);
            File file2 = File.createTempFile("UPS", null);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("set >" + file2.getCanonicalPath());
            bufferedWriter.close();
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
            this.makeExectuable(file.getCanonicalPath());
            Exec.runCommand("sh -c " + file.getCanonicalPath());
            FileInputStream fileInputStream = new FileInputStream(file2);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            boolean bl = false;
            while (bufferedReader.ready() && !bl) {
                String string3 = bufferedReader.readLine();
                if (!string3.startsWith(string + "=")) continue;
                string2 = string3.substring(string.length() + 1);
            }
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
            file2.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to get environment variable:" + exception.getMessage());
        }
        return string2;
    }

    private void createUninstallScript() {
        PrintWriter printWriter;
        FileOutputStream fileOutputStream;
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = string + File.separator + this.theUninstallScriptName;
        try {
            fileOutputStream = new FileOutputStream(string2);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("if [ -f /etc/pbeagent.pid ]");
            printWriter.println("then");
            printWriter.println(this.getFullStartScriptName() + " stop");
            printWriter.println("fi");
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to create uninstall script:" + exception.getMessage());
        }
        string2 = string + File.separator + this.theJExpressUninstallScript;
        try {
            fileOutputStream = new FileOutputStream(string2);
            printWriter = new PrintWriter(fileOutputStream);
            String string3 = System.getProperty("java.home") + File.separator;
            String string4 = string3 + "bin" + File.separator;
            String string5 = string3 + "lib" + File.separator;
            String string6 = string + File.separator;
            String string7 = string4 + "java" + " -cp " + string5 + "swingall.jar" + ":" + string3 + "JExpressUninstaller.jar" + " com.denova.JExpress.Uninstaller.JUninstall " + "\"" + string6 + "JExpress/uninstall\"" + ">/dev/null 2>/dev/null";
            printWriter.println(string7);
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to create main uninstall script:" + exception.getMessage());
        }
    }

    private void setFilePermissions() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        try {
            String string2 = string + File.separator + "*";
            Exec.runCommand("chown -R root" + string2);
            Exec.runCommand("chgrp -R root" + string2);
            Exec.runCommand("chmod -R 0440" + string2);
            string2 = string + File.separator + this.theShutdownScriptName;
            Exec.runCommand("chmod 0540 " + string2);
            string2 = string + File.separator + this.theNotifierScriptName;
            Exec.runCommand("chmod 0540 " + string2);
            string2 = string + File.separator + this.theStartupScriptName;
            Exec.runCommand("chmod 0540 " + string2);
            string2 = this.getFullStartScriptName();
            Exec.runCommand("chmod 0540 " + string2);
            if (!PicardInstaller.RPMBuild()) {
                string2 = string + File.separator + this.theUninstallScriptName;
                Exec.runCommand("chmod 0540 " + string2);
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error setting file permission:" + exception.getMessage());
        }
    }

    private void registerScripts() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = string + File.separator + this.theStartupScriptName;
        try {
            FileSystem.copyFile(string2, this.getFullStartScriptName());
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error registering scripts:" + exception.getMessage());
        }
        this.setFilePermissions();
    }

    private String resolveLinks(String string) {
        String string2;
        try {
            File file = File.createTempFile("UPS", null);
            File file2 = File.createTempFile("UPS", null);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            string2 = "cd " + string + "; pwd >" + file2.getCanonicalPath();
            bufferedWriter.write(string2);
            bufferedWriter.close();
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
            this.makeExectuable(file.getCanonicalPath());
            Exec.runCommand("sh -c " + file.getCanonicalPath());
            FileInputStream fileInputStream = new FileInputStream(file2);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string2 = bufferedReader.readLine();
            bufferedReader.close();
            ((Reader)inputStreamReader).close();
            fileInputStream.close();
            file.delete();
            file2.delete();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("cd/pwd soft link resolution failed:" + exception.getMessage());
            string2 = string;
        }
        return string2;
    }

    protected String extractField(String string, int n) {
        String string2 = "";
        int n2 = 0;
        boolean bl = true;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (c == ' ' || c == '\t') {
                bl = true;
            } else {
                if (bl) {
                    bl = false;
                    ++n2;
                }
                if (n2 == n) {
                    string2 = string2 + c;
                }
            }
            ++n4;
        }
        return string2;
    }

    protected void makeExectuable(String string) {
        try {
            String string2 = "/bin/chmod +x " + string + " >/dev/null";
            Exec.runCommand(string2);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to chmod:" + exception.getMessage());
        }
    }
}

