/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.Installer.CustomInstaller;
import com.denova.util.PropertyList;
import java.io.File;

class PicardSilent {
    private boolean silentInstall = false;
    private PropertyList silentProperties = new PropertyList();

    PicardSilent() {
    }

    public String getFileName(PropertyList propertyList) {
        File file;
        String string = propertyList.getProperty("silentConfigFilename", "");
        if (string == null) {
            string = propertyList.getProperty("applicationDirectory", "");
        }
        if (!(file = new File(string)).exists()) {
            string = CustomInstaller.getStartDirectory() + File.separator + string;
        }
        if (!(file = new File(string)).exists()) {
            string = CustomInstaller.getStartDirectory() + File.separator + "silentInstall.ini";
        }
        return string;
    }

    public void load(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                this.silentProperties.load(string);
                this.silentInstall = true;
            } else {
                PicardInstallLogger.debug("Can't find silentInstall parameters file:" + string);
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Silent Install ERROR: " + exception);
            System.out.println("Silent Install ERROR: " + exception);
            System.exit(0);
        }
    }

    public boolean isSilentInstall() {
        return this.silentInstall;
    }

    public String getDirectory(String string) {
        return this.silentProperties.getProperty("applicationDirectory", string);
    }

    public boolean getAutoDetect() {
        return this.silentProperties.getProperty("UpsType") == null;
    }

    public String getUpsType(String string) {
        return this.silentProperties.getProperty("UpsType", string);
    }

    public String getUpsSerialNo(String string) {
        return this.silentProperties.getProperty("UpsSerialNo", string);
    }

    public String getUpsPort(String string) {
        return this.silentProperties.getProperty("UpsPort", string);
    }

    public String getWebPort(String string) {
        return this.silentProperties.getProperty("WebPort", string);
    }

    public String getUserName(String string) {
        return this.silentProperties.getProperty("UserName", string);
    }

    public String getUserPassword(String string) {
        return this.silentProperties.getProperty("UserPassword", string);
    }

    public String getContactPerson(String string) {
        return this.silentProperties.getProperty("ContactPerson", string);
    }

    public String getContactLocation(String string) {
        return this.silentProperties.getProperty("ContactLocation", string);
    }

    public boolean installComponent(String string, boolean bl) {
        String string2 = this.silentProperties.getProperty("Install" + string, "");
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true");
    }
}

