/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class PicardSerialConnection {
    private SerialPort thePort;
    private InputStream theInputStream;
    private OutputStream theOutputStream;
    private String thePortName;
    private Integer theWriteTimeout = new Integer(50);
    private Integer theReadTimeout = new Integer(4000);

    public PicardSerialConnection(String string) {
        this.thePortName = string;
    }

    public boolean tryOpenDevice() {
        boolean bl = false;
        try {
            this.openDevice();
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public void enablePlugAndPlay(boolean bl) {
        this.thePort.setRTS(bl);
    }

    public String tryRequest(String string, int n) {
        String string2;
        try {
            this.write(string);
            string2 = this.read(n);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public String getPortName() {
        return this.thePortName;
    }

    public void closeDevice() {
        this.thePort.close();
    }

    public void openDevice() throws IOException {
        CommPortIdentifier commPortIdentifier = null;
        int n = 8;
        int n2 = 1;
        int n3 = 0;
        int n4 = 2400;
        try {
            commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.thePortName);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Couldn't find port" + exception.toString());
            throw new IOException("Couldn't find port" + exception.toString());
        }
        try {
            this.thePort = (SerialPort)commPortIdentifier.open("UPS Software", 4000);
        }
        catch (Exception exception) {
            throw new IOException("Port in use " + exception.toString());
        }
        try {
            this.thePort.setSerialPortParams(n4, n, n2, n3);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unsupported " + exception.toString());
            throw new IOException("Unsupported " + exception.toString());
        }
        try {
            this.theInputStream = this.thePort.getInputStream();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Input Stream Exception " + exception.toString());
            throw new IOException("Input Stream Exception " + exception.toString());
        }
        try {
            this.theOutputStream = this.thePort.getOutputStream();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Output Stream Exception " + exception.toString());
            throw new IOException("Output stream Exception " + exception.toString());
        }
        try {
            this.thePort.enableReceiveTimeout(this.theReadTimeout.intValue());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            PicardInstallLogger.debug("Timeout exception " + unsupportedCommOperationException.getMessage());
            throw new IOException("Timeout exception" + unsupportedCommOperationException.getMessage());
        }
    }

    private String read(int n) throws IOException {
        byte[] byArray = new byte[2];
        String string = null;
        int n2 = 0;
        byArray[0] = 0;
        byArray[1] = 0;
        try {
            n2 = this.theInputStream.read(byArray, 0, 1);
            string = new String(byArray, 0, 1);
        }
        catch (Exception exception) {
            throw new IOException("Write Exception " + exception.toString());
        }
        if (n2 == 0) {
            throw new IOException("No data read");
        }
        try {
            boolean bl = false;
            while (!bl) {
                byArray[0] = 0;
                n2 = this.theInputStream.read(byArray, 0, 1);
                if (n2 <= 0) {
                    throw new IOException("timeout");
                }
                if (byArray[0] != 13 && byArray[0] != 10) {
                    string = string.concat(new String(byArray, 0, 1));
                }
                if (byArray[0] != 10) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new IOException("Read Exception " + exception.toString());
        }
        return string;
    }

    private void write(String string) throws IOException {
        if (string == null) {
            throw new IOException("Write buffer is null");
        }
        byte[] byArray = string.getBytes();
        try {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                this.theOutputStream.write(byArray[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new IOException("Write Exception " + exception.toString());
        }
    }
}

