/*
 * Decompiled with CFR 0.152.
 */
import com.denova.io.FileSystem;
import com.denova.runtime.WindowsOS;
import com.denova.util.PropertyList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

class PicardRegistration {
    static String theAPCKey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\APC\\Application List\\PowerChute UPS Manager";
    static String theBaseDeviceKey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\APC\\device List";
    private PropertyList thePropertyList;

    PicardRegistration(PropertyList propertyList) {
        this.thePropertyList = propertyList;
    }

    public void installRegistrationProgram() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = this.quote(this.getRegSvrFileName()) + " /S " + this.quote(this.getRegDLLFileName());
        try {
            this.moveRegFile("APCRegMain.exe");
            this.moveRegFile("APCRegAgent.dll");
            this.moveRegFile("Mfc42u.dll");
            this.moveRegFile("Msvcp50.dll");
            this.moveRegFile("tls704d.dll");
            FileSystem.removeDirectory(string + File.separator + "reg");
            this.getWindowsPlatform().programLaunch(string2);
            this.CreateRegisterCmd();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to install registration program: " + exception);
        }
    }

    void run() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        try {
            String string2 = this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "APCRegMain.exe";
            this.getWindowsPlatform().silentLaunch(this.quote(string2));
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to run registration program:" + exception);
        }
    }

    public void addRegistryKeys() {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        this.getWindowsPlatform().addRegKey(theAPCKey, "PathName", string);
        string = PicardInstaller.getMajorVersion();
        this.getWindowsPlatform().addRegKey(theAPCKey, "majorRev", string);
        string = PicardInstaller.getMinorVersion();
        this.getWindowsPlatform().addRegKey(theAPCKey, "minorRev", string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        string = gregorianCalendar.get(2) + 1 + "/" + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(1);
        this.getWindowsPlatform().addRegKey(theAPCKey, "installDate", string);
        string = "WinNT";
        String string2 = new WindowsOS().queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentVersion");
        if (string2 != null && (double)Float.parseFloat(string2) >= 5.0) {
            string = "Win2000";
        }
        this.getWindowsPlatform().addRegKey(theAPCKey, "os", string);
        String string3 = PicardInstaller.configuration.getUpsSerialNo();
        if (string3 != null) {
            String string4 = theBaseDeviceKey + '\\' + string3;
            string = PicardInstaller.configuration.getUpsType();
            this.getWindowsPlatform().addRegKey(string4, "make", string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            string = simpleDateFormat.format(new Date());
            this.getWindowsPlatform().addRegKey(string4, "purchaseDate", string);
        }
    }

    public void addRemoveCommands(Vector vector) {
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "reg.cmd");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "unreg.cmd");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "APCRegMain.exe");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "APCRegAgent.dll");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "Mfc42u.dll");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "Msvcp50.dll");
        vector.add("delfile\t" + this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "tls704d.dll");
    }

    public void addRemoveRegistryCommands(Vector vector) {
        vector.add("delete\tHKEY_LOCAL_MACHINE\\SOFTWARE\\APC\\Application List\tPowerChute UPS Manager");
    }

    private PicardWindowsPlatform getWindowsPlatform() {
        return (PicardWindowsPlatform)PicardInstaller.platform;
    }

    private String getRegDLLFileName() {
        return this.getWindowsPlatform().getRegistrationDirectory() + File.separator + "apcregagent.dll";
    }

    private String getRegSvrFileName() {
        return this.getWindowsPlatform().getWindowsDirectory() + "\\system32\\regsvr32.exe";
    }

    private String quote(String string) {
        return this.getWindowsPlatform().quote(string);
    }

    private void moveRegFile(String string) {
        String string2 = this.thePropertyList.getProperty("applicationDirectory", "");
        String string3 = this.getWindowsPlatform().getRegistrationDirectory() + File.separator + string;
        String string4 = string2 + File.separator + "reg" + File.separator + string;
        PicardInstaller.moveFile(string4, string3);
    }

    private void CreateRegisterCmd() {
        try {
            File file = new File(this.getWindowsPlatform().getRegistrationDirectory(), "reg.cmd");
            FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), true);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(this.getRegSvrFileName() + " /S " + this.quote(this.getRegDLLFileName()));
            printWriter.close();
            fileOutputStream.close();
            File file2 = new File(this.getWindowsPlatform().getRegistrationDirectory(), "unreg.cmd");
            fileOutputStream = new FileOutputStream(file2.getPath(), true);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(this.getRegSvrFileName() + " /S /U " + this.quote(this.getRegDLLFileName()));
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to create registration/unregistration scripts:" + exception);
        }
    }
}

