/*
 * Decompiled with CFR 0.152.
 */
import com.denova.io.FileSystem;
import com.denova.util.PropertyList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

abstract class PicardPlatform {
    protected PropertyList thePropertyList;

    PicardPlatform(PropertyList propertyList) {
        this.thePropertyList = propertyList;
    }

    public abstract void RunRegistrationProgram();

    public abstract boolean stopService();

    public abstract boolean startService();

    public abstract void installRS232();

    public abstract void removeRS232();

    public abstract boolean isRoot();

    public abstract long getDiskSpace(String var1);

    public final void configureSystem() {
        this.uninstallSetup();
        Vector vector = new Vector();
        this.addRemoveCommands(vector);
        if (!PicardInstaller.RPMBuild()) {
            this.updateUninstallFile(vector);
        }
        this.install();
    }

    protected void install() {
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            picardInstallableComponent.install(this.thePropertyList);
        }
    }

    protected void addRemoveCommands(Vector vector) {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        vector.add("delfile\t" + string + File.separator + "m11.cfg");
        vector.add("delfile\t" + string + File.separator + "EventLog");
        vector.add("delfile\t" + string + File.separator + "DataLog");
        vector.add("delfile\t" + string + File.separator + "m11.apc");
        vector.add("delfile\t" + string + File.separator + "install.log");
        vector.add("delfile\t" + string + File.separator + "data.dat");
        vector.add("delfile\t" + string + File.separator + "m11-debuglog.apc");
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            picardInstallableComponent.addRemoveCommands(this.thePropertyList, vector);
        }
    }

    protected void uninstallSetup() {
    }

    protected String getBrowser() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int replaceString(String string, String string2, String string3) {
        File file = new File(string);
        String string4 = "temp";
        File file2 = new File(string4);
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            block2: while (true) {
                String string5;
                if ((string5 = bufferedReader.readLine()) == null) {
                    printWriter.close();
                    fileOutputStream.close();
                    fileInputStream.close();
                    FileSystem.copyFile(string4, string);
                    FileSystem.removeFile(string4);
                    return n;
                }
                while (true) {
                    if (string5.indexOf(string2) == -1) {
                        printWriter.println(string5);
                        continue block2;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    int n3 = string5.indexOf(string2);
                    stringBuffer.append(string5.substring(n2, n3));
                    stringBuffer.append(string3);
                    stringBuffer.append(string5.substring(n3 + string2.length()));
                    ++n;
                    string5 = stringBuffer.toString();
                }
                break;
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Unable to replace strings");
        }
        return n;
    }

    private void updateUninstallFile(Vector vector) {
        String string = this.thePropertyList.getProperty("applicationDirectory", "");
        String string2 = string + File.separator + "JExpress" + File.separator + "uninstall";
        String string3 = string + File.separator + "JExpress" + File.separator + "temp";
        try {
            String string4;
            FileInputStream fileInputStream = new FileInputStream(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.indexOf("delmanifest") != -1) {
                    int n = 0;
                    while (n < vector.size()) {
                        printWriter.println((String)vector.get(n));
                        ++n;
                    }
                }
                printWriter.println(string4);
            }
            printWriter.close();
            fileOutputStream.close();
            fileInputStream.close();
            FileSystem.copyFile(string3, string2);
            FileSystem.removeFile(string3);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error updating uninstall file:" + exception);
        }
    }
}

