/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class PicardContactPanel
extends WizardPanel
implements JExpressConstants {
    private JTextField theContactPersonField;
    private JTextField theContactLocationField;
    private static final int cContactLocationLength = 32;
    private static final int cContactPersonLength = 32;

    public PicardContactPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.ContactPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.ContactDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.ContactDescriptionMsg02);
        JLabel jLabel4 = new JLabel(PicardResources.ContactPersonFieldLabel);
        JLabel jLabel5 = new JLabel(PicardResources.ContactLocationFieldLabel);
        this.theContactPersonField = new JTextField(PicardResources.ContactPersonFieldDefault);
        this.theContactPersonField.setToolTipText(PicardResources.ContactPersonFieldHelp);
        this.theContactPersonField.setEditable(true);
        this.theContactLocationField = new JTextField(PicardResources.ContactLocationFieldDefault);
        this.theContactLocationField.setToolTipText(PicardResources.ContactLocationFieldHelp);
        this.theContactLocationField.setEditable(true);
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel4);
        gridBagControl.add(gridBagConstraints2, this.theContactPersonField);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, jLabel5);
        gridBagControl.add(gridBagConstraints2, this.theContactLocationField);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            String string = PicardInstaller.configuration.getContactPerson();
            String string2 = PicardInstaller.configuration.getContactLocation();
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                string = PicardInstaller.silentConfiguration.getContactPerson(string);
                string2 = PicardInstaller.silentConfiguration.getContactLocation(string2);
            }
            this.theContactPersonField.setText(string);
            this.theContactLocationField.setText(string2);
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                this.showNextPanel();
            }
        } else {
            PicardInstaller.configuration.setContactPerson(this.theContactPersonField.getText());
            PicardInstaller.configuration.setContactLocation(this.theContactLocationField.getText());
        }
    }

    public String getName() {
        return "PicardContactPanel";
    }

    public boolean isOk() {
        if (this.theContactPersonField.getText().length() > 32) {
            this.note(PicardResources.MsgContactLength);
            return false;
        }
        if (this.theContactLocationField.getText().length() > 32) {
            this.note(PicardResources.MsgLocationLength);
            return false;
        }
        return true;
    }
}

