/*
 * Decompiled with CFR 0.152.
 */
import com.apcc.m11.util.MD5;
import com.sun.crypto.provider.SunJCE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

class PicardConfiguration {
    public static final Class KEEP_ME = class$java$security$Security == null ? (class$java$security$Security = PicardConfiguration.class$("java.security.Security")) : class$java$security$Security;
    private String theDirectory = null;
    private String theUpsType = null;
    private String theUpsSerialNo = null;
    private String theUpsPort = null;
    private Integer theWebPort;
    private String theUserName;
    private String theUserPassword;
    private String theContactPerson;
    private String theContactLocation;
    private Integer theUpdateInterval;
    private Integer theTransactionDelay;
    private Integer theWriteDelay;
    private Integer theResponseTimeout;
    private Integer theOpenTimeout;
    private String theNotifier = "notifier";
    private Integer theListenerPort;
    private String theVersionOid = ".3.4.100.5";
    private String cUpsTypeKey = "Install.UpsType";
    private String cUpsSerialNoKey = "Install.UpsSerialNo";
    private String cWebPortKey = "httpcomp.PortNumber";
    private String cAppDir = "host.ApplicationDirectory";
    private String cComponentDir = "host.ComponentDirectory";
    private String cExeDir = "host.ExeDirectory";
    private String cPasswordKey = "Security.SecurityPasswords";
    private String cResourceListKey = "Security.SecurityResourceLists";
    private String cNotifierKey = "Notifier.NotifierExe";
    private String cShutdownerKey = "OSshutdownerlet.ShutdownExe";
    private String cContactPersonKey = "RS232Power Source.ContactPerson";
    private String cContactLocationKey = "RS232Power Source.ContactLocation";
    private String cUpdateIntervalKey = "RS232Power Source.UpdateInterval";
    private String cTransactionDelayKey = "RS232Power Source.TransactionDelay";
    private String cWriteDelayKey = "RS232Power Source.WriteDelay";
    private String cCOMPortKey = "RS232Power Source.COMPort";
    private String cResponseTimeoutKey = "RS232Power Source.ResponseTimeout";
    private String cOpenTimeoutKey = "RS232Power Source.OpenTimeout";
    private String cSignalingTypeKey = "RS232Power Source.SignalingType";
    private String cShareUPSModeKey = "RS232Power Source.ShareUpsMode";
    private String cVersionKey = "Install.";
    private String cPicardPermission = "picard";
    private String cListenerPort = "DiscoveryListener.ListenerPort";
    private String cVersionOid = "DiscoveryListener.VersionOid";
    private String cSysLoggerEventMappings = "SystemLogger.EventMappingsFile";
    private String cSysLoggerExe = "SystemLogger.SystemLoggerExe";
    private Hashtable theStorageEntries = new Hashtable();
    static /* synthetic */ Class class$java$security$Security;

    public String getDirectory() {
        return this.theDirectory;
    }

    public String getUpsType() {
        return this.theUpsType;
    }

    public String getUpsSerialNo() {
        return this.theUpsSerialNo;
    }

    public String getUpsPort() {
        return this.theUpsPort;
    }

    public String getWebPort() {
        return this.theWebPort.toString();
    }

    public String getUserName() {
        return this.theUserName;
    }

    public String getUserPassword() {
        return this.theUserPassword;
    }

    public String getContactPerson() {
        return this.theContactPerson;
    }

    public String getContactLocation() {
        return this.theContactLocation;
    }

    public void setDirectory(String string) {
        this.theDirectory = string;
    }

    public void setUpsType(String string) {
        this.theUpsType = string;
    }

    public void setUpsSerialNo(String string) {
        this.theUpsSerialNo = string;
    }

    public void setUpsPort(String string) {
        this.theUpsPort = string;
    }

    public void setWebPort(String string) {
        this.theWebPort = Integer.valueOf(string);
    }

    public void setUserName(String string) {
        this.theUserName = string;
    }

    public void setUserPassword(String string) {
        this.theUserPassword = string;
    }

    public void setContactPerson(String string) {
        this.theContactPerson = string;
    }

    public void setContactLocation(String string) {
        this.theContactLocation = string;
    }

    public PicardConfiguration() {
        this.theWebPort = new Integer(3052);
        this.theUpdateInterval = new Integer(20);
        this.theTransactionDelay = new Integer(3000);
        this.theWriteDelay = new Integer(50);
        this.theResponseTimeout = new Integer(4000);
        this.theOpenTimeout = new Integer(4000);
        this.theListenerPort = new Integer(2161);
        this.theUserName = PicardResources.UserInfoNameFieldDefault;
        this.theUserPassword = PicardResources.UserInfoPasswordFieldDefault;
        this.theContactPerson = PicardResources.ContactPersonFieldDefault;
        this.theContactLocation = PicardResources.ContactLocationFieldDefault;
    }

    public void load(String string) {
        Object object;
        Object object2;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            object2 = new FileInputStream(string);
            object = new ObjectInputStream((InputStream)object2);
            this.theStorageEntries = (Hashtable)((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
            ((InputStream)object2).close();
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error reading configuration file:" + exception);
        }
        try {
            this.theUpsType = this.theStorageEntries.get(this.cUpsTypeKey).toString();
            this.theUpsSerialNo = this.theStorageEntries.get(this.cUpsSerialNoKey).toString();
            this.theWebPort = (Integer)this.theStorageEntries.get(this.cWebPortKey);
            object2 = (Hashtable)this.theStorageEntries.get(this.cPasswordKey);
            object = ((Hashtable)object2).keys();
            this.theUserName = (String)object.nextElement();
            this.theContactPerson = this.theStorageEntries.get(this.cContactPersonKey).toString();
            this.theContactLocation = this.theStorageEntries.get(this.cContactLocationKey).toString();
            this.theDirectory = this.theStorageEntries.get(this.cAppDir).toString();
            this.theUpdateInterval = (Integer)this.theStorageEntries.get(this.cUpdateIntervalKey);
            this.theTransactionDelay = (Integer)this.theStorageEntries.get(this.cTransactionDelayKey);
            this.theWriteDelay = (Integer)this.theStorageEntries.get(this.cWriteDelayKey);
            this.theUpsPort = (String)this.theStorageEntries.get(this.cCOMPortKey);
            this.theResponseTimeout = (Integer)this.theStorageEntries.get(this.cResponseTimeoutKey);
            this.theOpenTimeout = (Integer)this.theStorageEntries.get(this.cOpenTimeoutKey);
            this.theNotifier = (String)this.theStorageEntries.get(this.cNotifierKey);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error extracting configuration values:" + exception);
        }
    }

    public int getVersion(String string) {
        Object v = this.theStorageEntries.get(this.cVersionKey + string);
        if (v == null) {
            return 0;
        }
        return Integer.valueOf(v.toString());
    }

    public void save(String string) {
        Object object;
        FileInputStream fileInputStream;
        Object object2;
        try {
            object2 = new File(string);
            if (((File)object2).exists()) {
                this.theStorageEntries = new Hashtable();
                fileInputStream = new FileInputStream(string);
                object = new ObjectInputStream(fileInputStream);
                this.theStorageEntries = (Hashtable)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
                ((InputStream)fileInputStream).close();
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error reading initial configuration file:" + exception);
        }
        try {
            this.theStorageEntries.put(new String(this.cUpsTypeKey), this.theUpsType);
            this.theStorageEntries.put(new String(this.cUpsSerialNoKey), this.theUpsSerialNo);
            this.theStorageEntries.put(new String(this.cWebPortKey), this.theWebPort);
            this.theStorageEntries.put(new String(this.cContactPersonKey), this.theContactPerson);
            this.theStorageEntries.put(new String(this.cContactLocationKey), this.theContactLocation);
            this.theStorageEntries.put(new String(this.cAppDir), this.theDirectory);
            this.theStorageEntries.put(new String(this.cComponentDir), this.theDirectory + File.separator + "comp");
            this.theStorageEntries.put(new String(this.cExeDir), this.theDirectory + File.separator + "bin");
            this.theStorageEntries.put(new String(this.cUpdateIntervalKey), this.theUpdateInterval);
            this.theStorageEntries.put(new String(this.cTransactionDelayKey), this.theTransactionDelay);
            this.theStorageEntries.put(new String(this.cSignalingTypeKey), this.signalingType(this.theUpsType));
            this.theStorageEntries.put(new String(this.cShareUPSModeKey), this.shareUpsMode(this.theUpsType));
            this.theStorageEntries.put(new String(this.cWriteDelayKey), this.theWriteDelay);
            this.theStorageEntries.put(new String(this.cCOMPortKey), this.theUpsPort);
            this.theStorageEntries.put(new String(this.cResponseTimeoutKey), this.theResponseTimeout);
            this.theStorageEntries.put(new String(this.cOpenTimeoutKey), this.theOpenTimeout);
            this.theStorageEntries.put(new String(this.cNotifierKey), this.theNotifier);
            this.theStorageEntries.put(new String(this.cListenerPort), this.theListenerPort);
            this.theStorageEntries.put(new String(this.cVersionOid), this.theVersionOid);
            object2 = "shutdown";
            if (File.separatorChar == '/' || this.isNetwareOS()) {
                object2 = "shutdown";
            } else {
                object2 = "shutdown.exe";
                this.theStorageEntries.put(new String(this.cSysLoggerEventMappings), this.theDirectory + File.separator + "comp" + File.separator + "systemlogger" + File.separator + "EventMappings.ini");
                this.theStorageEntries.put(new String(this.cSysLoggerExe), this.theDirectory + File.separator + "bin" + File.separator + "syslogger");
            }
            object2 = new String(this.theDirectory + File.separator + "bin" + File.separator + (String)object2);
            this.theStorageEntries.put(new String(this.cShutdownerKey), object2);
            fileInputStream = new MD5();
            fileInputStream.Init();
            fileInputStream.Update(this.theUserPassword);
            object = fileInputStream.asHex();
            Hashtable<String, SealedObject> hashtable = new Hashtable<String, SealedObject>();
            SealedObject sealedObject = PicardConfiguration.encodePassword(this.theUserName, (String)object);
            hashtable.put(new String(this.theUserName), sealedObject);
            this.theStorageEntries.put(new String(this.cPasswordKey), hashtable);
            Vector<String> vector = new Vector<String>();
            vector.add(this.cPicardPermission);
            Hashtable<String, Vector<String>> hashtable2 = new Hashtable<String, Vector<String>>();
            hashtable2.put(new String(this.theUserName), vector);
            this.theStorageEntries.put(new String(this.cResourceListKey), hashtable2);
            this.theStorageEntries.put(new String("Application.Debug_Tracing"), new Boolean(false));
            this.theStorageEntries.put(new String("Application.Debug_Logging"), new Boolean(false));
            this.theStorageEntries.put(new String("Application.Debug_Logging_File_Name"), "m11.apc");
            if (this.isNetwareOS()) {
                this.theStorageEntries.put(new String("SimpleBroadcaster.Load_Command"), "load ");
            }
            Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
            while (enumeration.hasMoreElements()) {
                PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
                String string2 = String.valueOf(picardInstallableComponent.getVersion());
                this.theStorageEntries.put(new String(this.cVersionKey + picardInstallableComponent.getName()), string2);
            }
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error updating hash table");
        }
        try {
            object2 = new ObjectOutputStream(new FileOutputStream(string));
            ((ObjectOutputStream)object2).writeObject(this.theStorageEntries);
        }
        catch (Exception exception) {
            PicardInstallLogger.debug("Error updating configuration file:" + exception);
        }
    }

    private String signalingType(String string) {
        if (string.equalsIgnoreCase("Back-UPS") || string.equalsIgnoreCase("Share-UPS (simple)")) {
            return "Simple";
        }
        return "Smart";
    }

    private String shareUpsMode(String string) {
        if (string.equalsIgnoreCase("Share-UPS (simple)") || string.equalsIgnoreCase("Share-UPS (smart)")) {
            return "Yes";
        }
        return "No";
    }

    private static SealedObject encodePassword(String string, String string2) {
        SealedObject sealedObject = null;
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        try {
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, secretKey);
            sealedObject = new SealedObject((Serializable)((Object)string2), cipher);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return sealedObject;
    }

    private String decodePassword(String string, SealedObject sealedObject) {
        String string2 = null;
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        try {
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, secretKey);
            string2 = (String)sealedObject.getObject(cipher);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private boolean isNetwareOS() {
        return System.getProperty("os.name").toUpperCase().equals("NETWARE");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Security.addProvider(new SunJCE());
    }
}

